/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.client;

import com.linkedin.data.DataMap;
import com.linkedin.restli.client.response.BatchKVResponse;
import com.linkedin.restli.common.ComplexKeySpec;
import com.linkedin.restli.common.CompoundKey;
import com.linkedin.restli.common.ProtocolVersion;
import com.linkedin.restli.common.TypeSpec;
import com.linkedin.restli.common.UpdateStatus;
import com.linkedin.restli.internal.client.RestResponseDecoder;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Map;

public class BatchUpdateResponseDecoder<K>
extends RestResponseDecoder<BatchKVResponse<K, UpdateStatus>> {
    private final TypeSpec<K> _keyType;
    private final Map<String, CompoundKey.TypeInfo> _keyParts;
    private final ComplexKeySpec<?, ?> _complexKeyType;

    public BatchUpdateResponseDecoder(TypeSpec<K> keyType, Map<String, CompoundKey.TypeInfo> keyParts, ComplexKeySpec<?, ?> complexKeyType) {
        this._keyType = keyType;
        this._keyParts = keyParts;
        this._complexKeyType = complexKeyType;
    }

    @Override
    public Class<?> getEntityClass() {
        return UpdateStatus.class;
    }

    @Override
    public BatchKVResponse<K, UpdateStatus> wrapResponse(DataMap dataMap, Map<String, String> headers, ProtocolVersion version) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, IOException {
        if (dataMap == null) {
            return null;
        }
        DataMap mergedResults = new DataMap();
        DataMap inputResults = dataMap.containsKey((Object)"results") ? dataMap.getDataMap("results") : new DataMap();
        DataMap inputErrors = dataMap.containsKey((Object)"errors") ? dataMap.getDataMap("errors") : new DataMap();
        HashSet mergedKeys = new HashSet(inputResults.keySet());
        mergedKeys.addAll(inputErrors.keySet());
        for (String key : mergedKeys) {
            DataMap updateData = inputResults.containsKey((Object)key) ? inputResults.getDataMap(key) : new DataMap();
            DataMap errorData = (DataMap)inputErrors.get((Object)key);
            if (errorData != null) {
                updateData.put((Object)"status", errorData.get((Object)"status"));
                updateData.put((Object)"error", (Object)errorData);
            }
            mergedResults.put((Object)key, (Object)updateData);
        }
        DataMap responseData = new DataMap();
        responseData.put((Object)"results", (Object)mergedResults);
        responseData.put((Object)"errors", (Object)inputErrors);
        return new BatchKVResponse(responseData, this._keyType, new TypeSpec(UpdateStatus.class), this._keyParts, this._complexKeyType, version);
    }
}

