/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.client;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.callback.Callbacks;
import com.linkedin.common.util.None;
import com.linkedin.r2.disruptor.DisruptContext;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.restli.client.Client;
import com.linkedin.restli.client.ErrorHandlingBehavior;
import com.linkedin.restli.client.Request;
import com.linkedin.restli.client.RequestBuilder;
import com.linkedin.restli.client.Response;
import com.linkedin.restli.client.ResponseFuture;
import com.linkedin.restli.client.multiplexer.MultiplexedRequest;
import com.linkedin.restli.client.multiplexer.MultiplexedResponse;
import com.linkedin.restli.common.ResourceMethod;
import com.linkedin.restli.disruptor.DisruptRestController;
import com.linkedin.util.ArgumentUtil;

public class DisruptRestClient
implements Client {
    private final Client _client;
    private final DisruptRestController _controller;

    public DisruptRestClient(Client client, DisruptRestController controller) {
        ArgumentUtil.notNull((Object)client, (String)"client");
        ArgumentUtil.notNull((Object)controller, (String)"controller");
        this._client = client;
        this._controller = controller;
    }

    @Override
    public void shutdown(Callback<None> callback) {
        this._client.shutdown(callback);
    }

    @Override
    public <T> ResponseFuture<T> sendRequest(Request<T> request, RequestContext requestContext) {
        this.doEvaluateDisruptContext(request, requestContext);
        return this._client.sendRequest(request, requestContext);
    }

    @Override
    public <T> ResponseFuture<T> sendRequest(Request<T> request, RequestContext requestContext, ErrorHandlingBehavior errorHandlingBehavior) {
        this.doEvaluateDisruptContext(request, requestContext);
        return this._client.sendRequest(request, requestContext, errorHandlingBehavior);
    }

    @Override
    public <T> ResponseFuture<T> sendRequest(RequestBuilder<? extends Request<T>> requestBuilder, RequestContext requestContext) {
        Request<T> request = requestBuilder.build();
        this.doEvaluateDisruptContext(request, requestContext);
        return this._client.sendRequest(request, requestContext);
    }

    @Override
    public <T> ResponseFuture<T> sendRequest(RequestBuilder<? extends Request<T>> requestBuilder, RequestContext requestContext, ErrorHandlingBehavior errorHandlingBehavior) {
        Request<T> request = requestBuilder.build();
        this.doEvaluateDisruptContext(request, requestContext);
        return this._client.sendRequest(request, requestContext, errorHandlingBehavior);
    }

    @Override
    public <T> void sendRequest(Request<T> request, RequestContext requestContext, Callback<Response<T>> callback) {
        this.doEvaluateDisruptContext(request, requestContext);
        this._client.sendRequest(request, requestContext, callback);
    }

    @Override
    public <T> void sendRequest(RequestBuilder<? extends Request<T>> requestBuilder, RequestContext requestContext, Callback<Response<T>> callback) {
        Request<T> request = requestBuilder.build();
        this.doEvaluateDisruptContext(request, requestContext);
        this._client.sendRequest(request, requestContext, callback);
    }

    @Override
    public <T> ResponseFuture<T> sendRequest(Request<T> request) {
        RequestContext requestContext = new RequestContext();
        this.doEvaluateDisruptContext(request, requestContext);
        return this._client.sendRequest(request, requestContext);
    }

    @Override
    public <T> ResponseFuture<T> sendRequest(Request<T> request, ErrorHandlingBehavior errorHandlingBehavior) {
        RequestContext requestContext = new RequestContext();
        this.doEvaluateDisruptContext(request, requestContext);
        return this._client.sendRequest(request, requestContext, errorHandlingBehavior);
    }

    @Override
    public <T> ResponseFuture<T> sendRequest(RequestBuilder<? extends Request<T>> requestBuilder) {
        Request<T> request = requestBuilder.build();
        RequestContext requestContext = new RequestContext();
        this.doEvaluateDisruptContext(request, requestContext);
        return this._client.sendRequest(request, requestContext);
    }

    @Override
    public <T> ResponseFuture<T> sendRequest(RequestBuilder<? extends Request<T>> requestBuilder, ErrorHandlingBehavior errorHandlingBehavior) {
        Request<T> request = requestBuilder.build();
        RequestContext requestContext = new RequestContext();
        this.doEvaluateDisruptContext(request, requestContext);
        return this._client.sendRequest(request, requestContext, errorHandlingBehavior);
    }

    @Override
    public <T> void sendRequest(Request<T> request, Callback<Response<T>> callback) {
        RequestContext requestContext = new RequestContext();
        this.doEvaluateDisruptContext(request, requestContext);
        this._client.sendRequest(request, requestContext, callback);
    }

    @Override
    public <T> void sendRequest(RequestBuilder<? extends Request<T>> requestBuilder, Callback<Response<T>> callback) {
        Request<T> request = requestBuilder.build();
        RequestContext requestContext = new RequestContext();
        this.doEvaluateDisruptContext(request, requestContext);
        this._client.sendRequest(request, requestContext, callback);
    }

    @Override
    public void sendRequest(MultiplexedRequest multiplexedRequest) {
        RequestContext requestContext = new RequestContext();
        this.doEvaluateDisruptContext(requestContext);
        this._client.sendRequest(multiplexedRequest, requestContext, (Callback<MultiplexedResponse>)Callbacks.empty());
    }

    @Override
    public void sendRequest(MultiplexedRequest multiplexedRequest, Callback<MultiplexedResponse> callback) {
        RequestContext requestContext = new RequestContext();
        this.doEvaluateDisruptContext(requestContext);
        this._client.sendRequest(multiplexedRequest, requestContext, callback);
    }

    @Override
    public void sendRequest(MultiplexedRequest multiplexedRequest, RequestContext requestContext, Callback<MultiplexedResponse> callback) {
        this.doEvaluateDisruptContext(requestContext);
        this._client.sendRequest(multiplexedRequest, requestContext, callback);
    }

    private <T> void doEvaluateDisruptContext(RequestContext requestContext) {
        if (this.isDisruptSourceAlreadySet(requestContext)) {
            return;
        }
        requestContext.putLocalAttr("R2_DISRUPT_SOURCE", (Object)this._controller.getClass().getCanonicalName());
        DisruptContext disruptContext = this._controller.getDisruptContext("mux");
        if (disruptContext != null) {
            requestContext.putLocalAttr("R2_DISRUPT_CONTEXT", (Object)disruptContext);
        }
    }

    private <T> void doEvaluateDisruptContext(Request<T> request, RequestContext requestContext) {
        if (this.isDisruptSourceAlreadySet(requestContext)) {
            return;
        }
        requestContext.putLocalAttr("R2_DISRUPT_SOURCE", (Object)this._controller.getClass().getCanonicalName());
        ResourceMethod method = request.getMethod();
        String resource = request.getBaseUriTemplate();
        String name = request.getMethodName();
        DisruptContext disruptContext = name == null ? this._controller.getDisruptContext(resource, method) : this._controller.getDisruptContext(resource, method, name);
        if (disruptContext != null) {
            requestContext.putLocalAttr("R2_DISRUPT_CONTEXT", (Object)disruptContext);
        }
    }

    private boolean isDisruptSourceAlreadySet(RequestContext requestContext) {
        return requestContext.getLocalAttr("R2_DISRUPT_SOURCE") != null;
    }
}

