/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.client;

import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.restli.client.BatchGetEntityRequest;
import com.linkedin.restli.client.BatchGetRequestUtil;
import com.linkedin.restli.client.BatchKVRequestBuilder;
import com.linkedin.restli.client.RestliRequestOptions;
import com.linkedin.restli.client.response.BatchKVResponse;
import com.linkedin.restli.common.EntityResponse;
import com.linkedin.restli.common.ResourceSpec;
import com.linkedin.restli.internal.client.BatchEntityResponseDecoder;
import com.linkedin.restli.internal.client.RestResponseDecoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class BatchGetEntityRequestBuilder<K, V extends RecordTemplate>
extends BatchKVRequestBuilder<K, V, BatchGetEntityRequest<K, V>> {
    private final RestResponseDecoder<BatchKVResponse<K, EntityResponse<V>>> _decoder;

    public static <K, V extends RecordTemplate> BatchGetEntityRequest<K, V> batch(List<BatchGetEntityRequest<K, V>> requests) {
        return BatchGetEntityRequestBuilder.batch(requests, true);
    }

    public static <K, V extends RecordTemplate> BatchGetEntityRequest<K, V> batch(List<BatchGetEntityRequest<K, V>> requests, boolean batchFields) {
        BatchGetEntityRequest<K, V> firstRequest = requests.get(0);
        ResourceSpec firstResourceSpec = firstRequest.getResourceSpec();
        Map<String, Object> batchQueryParams = BatchGetEntityRequestBuilder.getReadOnlyQueryParameters(BatchGetRequestUtil.getBatchQueryParam(requests, batchFields));
        return new BatchGetEntityRequest(firstRequest.getHeaders(), firstRequest.getCookies(), firstRequest.getResponseDecoder(), batchQueryParams, firstRequest.getQueryParamClasses(), firstResourceSpec, firstRequest.getBaseUriTemplate(), firstRequest.getPathKeys(), firstRequest.getRequestOptions());
    }

    public BatchGetEntityRequestBuilder(String baseUriTemplate, RestResponseDecoder<BatchKVResponse<K, EntityResponse<V>>> decoder, ResourceSpec resourceSpec, RestliRequestOptions requestOptions) {
        super(baseUriTemplate, resourceSpec, requestOptions);
        this._decoder = decoder;
    }

    public BatchGetEntityRequestBuilder(String baseUriTemplate, ResourceSpec resourceSpec, RestliRequestOptions requestOptions) {
        this(baseUriTemplate, new BatchEntityResponseDecoder(resourceSpec.getValueType(), resourceSpec.getKeyType(), resourceSpec.getKeyParts(), resourceSpec.getComplexKeyType()), resourceSpec, requestOptions);
    }

    public BatchGetEntityRequestBuilder<K, V> ids(K ... ids) {
        return this.ids((Collection<K>)Arrays.asList(ids));
    }

    public BatchGetEntityRequestBuilder<K, V> ids(Collection<K> ids) {
        this.addKeys(ids);
        return this;
    }

    @Override
    public BatchGetEntityRequestBuilder<K, V> setParam(String key, Object value) {
        super.setParam(key, value);
        return this;
    }

    @Override
    public BatchGetEntityRequestBuilder<K, V> setReqParam(String key, Object value) {
        super.setReqParam(key, value);
        return this;
    }

    @Override
    public BatchGetEntityRequestBuilder<K, V> addParam(String key, Object value) {
        super.addParam(key, value);
        return this;
    }

    @Override
    public BatchGetEntityRequestBuilder<K, V> addReqParam(String key, Object value) {
        super.addReqParam(key, value);
        return this;
    }

    @Override
    public BatchGetEntityRequestBuilder<K, V> setHeader(String key, String value) {
        super.setHeader(key, value);
        return this;
    }

    public BatchGetEntityRequestBuilder<K, V> setHeaders(Map<String, String> headers) {
        super.setHeaders((Map)headers);
        return this;
    }

    @Override
    public BatchGetEntityRequestBuilder<K, V> addHeader(String name, String value) {
        super.addHeader(name, value);
        return this;
    }

    public BatchGetEntityRequestBuilder<K, V> pathKey(String name, Object value) {
        super.pathKey(name, value);
        return this;
    }

    @Override
    public BatchGetEntityRequest<K, V> build() {
        this.ensureBatchKeys();
        return new BatchGetEntityRequest<K, V>(this.buildReadOnlyHeaders(), this.buildReadOnlyCookies(), this._decoder, this.buildReadOnlyQueryParameters(), this.getQueryParamClasses(), this._resourceSpec, this.getBaseUriTemplate(), this.buildReadOnlyPathKeys(), this.getRequestOptions());
    }

    public BatchGetEntityRequestBuilder<K, V> fields(PathSpec ... fieldPaths) {
        this.addFields(fieldPaths);
        return this;
    }
}

