/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.client;

import com.linkedin.data.DataMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.restli.client.BatchCreateIdEntityRequest;
import com.linkedin.restli.client.RestfulRequestBuilder;
import com.linkedin.restli.client.RestliRequestOptions;
import com.linkedin.restli.common.CollectionRequest;
import com.linkedin.restli.common.ResourceSpec;
import com.linkedin.restli.common.attachments.RestLiAttachmentDataSourceWriter;
import com.linkedin.restli.common.attachments.RestLiDataSourceIterator;
import com.linkedin.restli.internal.client.BatchCreateIdEntityDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class BatchCreateIdEntityRequestBuilder<K, V extends RecordTemplate>
extends RestfulRequestBuilder<K, V, BatchCreateIdEntityRequest<K, V>> {
    private final List<V> _entities = new ArrayList<V>();
    private final Class<V> _valueClass;
    private List<Object> _streamingAttachments;

    protected BatchCreateIdEntityRequestBuilder(String baseURITemplate, Class<V> valueClass, ResourceSpec resourceSpec, RestliRequestOptions requestOptions) {
        super(baseURITemplate, resourceSpec, requestOptions);
        this._valueClass = valueClass;
    }

    public BatchCreateIdEntityRequestBuilder<K, V> input(V entity) {
        this._entities.add(entity);
        return this;
    }

    public BatchCreateIdEntityRequestBuilder<K, V> inputs(List<V> entities) {
        this._entities.addAll(entities);
        return this;
    }

    public BatchCreateIdEntityRequestBuilder<K, V> appendSingleAttachment(RestLiAttachmentDataSourceWriter streamingAttachment) {
        if (this._streamingAttachments == null) {
            this._streamingAttachments = new ArrayList<Object>();
        }
        this._streamingAttachments.add(streamingAttachment);
        return this;
    }

    public BatchCreateIdEntityRequestBuilder<K, V> appendMultipleAttachments(RestLiDataSourceIterator dataSourceIterator) {
        if (this._streamingAttachments == null) {
            this._streamingAttachments = new ArrayList<Object>();
        }
        this._streamingAttachments.add(dataSourceIterator);
        return this;
    }

    @Override
    public BatchCreateIdEntityRequestBuilder<K, V> setParam(String key, Object value) {
        super.setParam(key, value);
        return this;
    }

    @Override
    public BatchCreateIdEntityRequestBuilder<K, V> setReqParam(String key, Object value) {
        super.setReqParam(key, value);
        return this;
    }

    @Override
    public BatchCreateIdEntityRequestBuilder<K, V> addParam(String key, Object value) {
        super.addParam(key, value);
        return this;
    }

    @Override
    public BatchCreateIdEntityRequestBuilder<K, V> addReqParam(String key, Object value) {
        super.addReqParam(key, value);
        return this;
    }

    @Override
    public BatchCreateIdEntityRequestBuilder<K, V> setHeader(String key, String value) {
        super.setHeader(key, value);
        return this;
    }

    public BatchCreateIdEntityRequestBuilder<K, V> setHeaders(Map<String, String> headers) {
        super.setHeaders((Map)headers);
        return this;
    }

    @Override
    public BatchCreateIdEntityRequestBuilder<K, V> addHeader(String name, String value) {
        super.addHeader(name, value);
        return this;
    }

    public BatchCreateIdEntityRequestBuilder<K, V> pathKey(String name, Object value) {
        super.pathKey(name, value);
        return this;
    }

    public BatchCreateIdEntityRequestBuilder<K, V> fields(PathSpec ... fieldPaths) {
        this.addFields(fieldPaths);
        return this;
    }

    @Override
    public BatchCreateIdEntityRequest<K, V> build() {
        BatchCreateIdEntityDecoder decoder = new BatchCreateIdEntityDecoder(this._resourceSpec.getKeyType(), this._resourceSpec.getValueType(), this._resourceSpec.getKeyParts(), this._resourceSpec.getComplexKeyType());
        return new BatchCreateIdEntityRequest(this.buildReadOnlyHeaders(), this.buildReadOnlyCookies(), decoder, this.buildReadOnlyInput(), this._resourceSpec, this.buildReadOnlyQueryParameters(), this.getQueryParamClasses(), this.getBaseUriTemplate(), this.buildReadOnlyPathKeys(), this.getRequestOptions(), this._streamingAttachments == null ? null : Collections.unmodifiableList(this._streamingAttachments));
    }

    private CollectionRequest<V> buildReadOnlyInput() {
        try {
            DataMap map = new DataMap();
            CollectionRequest input = new CollectionRequest(map, this._valueClass);
            for (RecordTemplate entity : this._entities) {
                input.getElements().add(this.getReadOnlyOrCopyDataTemplate(entity));
            }
            map.setReadOnly();
            return input;
        }
        catch (CloneNotSupportedException cloneException) {
            throw new IllegalArgumentException("Entity cannot be copied.", cloneException);
        }
    }
}

