/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.common;

import com.linkedin.data.template.RecordTemplate;
import com.linkedin.restli.common.ComplexKeySpec;
import com.linkedin.restli.common.CompoundKey;
import com.linkedin.restli.common.ResourceMethod;
import com.linkedin.restli.common.ResourceProperties;
import com.linkedin.restli.common.TypeSpec;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ResourcePropertiesImpl
implements ResourceProperties {
    private final Set<ResourceMethod> _supportedMethods;
    private final TypeSpec<?> _keyType;
    private final ComplexKeySpec<? extends RecordTemplate, ? extends RecordTemplate> _complexKeyType;
    private final Map<String, CompoundKey.TypeInfo> _keyParts;
    private final TypeSpec<? extends RecordTemplate> _valueType;

    public ResourcePropertiesImpl(Set<ResourceMethod> supportedMethods, TypeSpec<?> key, ComplexKeySpec<?, ?> complexKeyType, TypeSpec<? extends RecordTemplate> value, Map<String, ?> keyParts) {
        this._supportedMethods = Collections.unmodifiableSet(supportedMethods);
        this._keyType = key;
        this._complexKeyType = complexKeyType;
        this._keyParts = Collections.unmodifiableMap(ResourcePropertiesImpl.toTypeInfoKeyParts(keyParts));
        this._valueType = value;
    }

    @Override
    public Set<ResourceMethod> getSupportedMethods() {
        return this._supportedMethods;
    }

    @Override
    public TypeSpec<?> getKeyType() {
        return this._keyType;
    }

    @Override
    public Map<String, CompoundKey.TypeInfo> getKeyParts() {
        return this._keyParts;
    }

    @Override
    public TypeSpec<? extends RecordTemplate> getValueType() {
        return this._valueType;
    }

    @Override
    public ComplexKeySpec<? extends RecordTemplate, ? extends RecordTemplate> getComplexKeyType() {
        return this._complexKeyType;
    }

    @Override
    public boolean isKeylessResource() {
        return this._keyType == null;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ResourcePropertiesImpl)) {
            return false;
        }
        ResourcePropertiesImpl resourceSpec = (ResourcePropertiesImpl)other;
        return this.fieldEquals(this._supportedMethods, resourceSpec._supportedMethods) && this.fieldEquals(this._keyType, resourceSpec._keyType) && this.fieldEquals(this._complexKeyType, resourceSpec._complexKeyType) && this.fieldEquals(this._valueType, resourceSpec._valueType) && this.fieldEquals(this._keyParts, resourceSpec._keyParts);
    }

    private boolean fieldEquals(Object field1, Object field2) {
        return field1 == null ? field2 == null : field1.equals(field2);
    }

    public int hashCode() {
        int res = 7;
        res = 11 * res + this.hashOrNull(this._supportedMethods);
        res = 11 * res + this.hashOrNull(this._keyType);
        res = 11 * res + this.hashOrNull(this._complexKeyType);
        res = 11 * res + this.hashOrNull(this._valueType);
        res = 11 * res + this.hashOrNull(this._keyParts);
        return res;
    }

    private int hashOrNull(Object o) {
        return o == null ? 0 : o.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("supported: ");
        builder.append(this._supportedMethods);
        builder.append("\n, key: ");
        builder.append(this._keyType);
        builder.append("\n, complexKey: ");
        builder.append(this._complexKeyType);
        builder.append("\n, value: ");
        builder.append(this._valueType);
        builder.append("\n, keyParts: ");
        builder.append(this._keyParts);
        return builder.toString();
    }

    private static HashMap<String, CompoundKey.TypeInfo> toTypeInfoKeyParts(Map<String, ?> keyParts) {
        HashMap<String, CompoundKey.TypeInfo> keyPartTypeInfos = new HashMap<String, CompoundKey.TypeInfo>();
        for (Map.Entry<String, ?> entry : keyParts.entrySet()) {
            if (entry.getValue() instanceof Class) {
                Class entryKeyClass = (Class)entry.getValue();
                keyPartTypeInfos.put(entry.getKey(), new CompoundKey.TypeInfo(entryKeyClass, entryKeyClass));
                continue;
            }
            if (entry.getValue() instanceof CompoundKey.TypeInfo) {
                keyPartTypeInfos.put(entry.getKey(), (CompoundKey.TypeInfo)entry.getValue());
                continue;
            }
            throw new IllegalArgumentException("keyParts values must be either Class<?> or CompoundKey.TypeInfo, but was: " + entry.getValue().getClass());
        }
        return keyPartTypeInfos;
    }
}

