/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.common.validation;

import com.linkedin.data.DataComplex;
import com.linkedin.data.DataMap;
import com.linkedin.data.element.DataElement;
import com.linkedin.data.element.DataElementUtil;
import com.linkedin.data.element.SimpleDataElement;
import com.linkedin.data.it.PathMatchesPatternPredicate;
import com.linkedin.data.it.Predicate;
import com.linkedin.data.it.Predicates;
import com.linkedin.data.it.Wildcard;
import com.linkedin.data.message.Message;
import com.linkedin.data.message.MessageList;
import com.linkedin.data.schema.ArrayDataSchema;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.DataSchemaUtil;
import com.linkedin.data.schema.MapDataSchema;
import com.linkedin.data.schema.Name;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.schema.TyperefDataSchema;
import com.linkedin.data.schema.UnionDataSchema;
import com.linkedin.data.schema.validation.RequiredMode;
import com.linkedin.data.schema.validation.ValidateDataAgainstSchema;
import com.linkedin.data.schema.validation.ValidationOptions;
import com.linkedin.data.schema.validation.ValidationResult;
import com.linkedin.data.schema.validator.DataSchemaAnnotationValidator;
import com.linkedin.data.schema.validator.Validator;
import com.linkedin.data.schema.validator.ValidatorContext;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.TemplateRuntimeException;
import com.linkedin.data.transform.DataComplexProcessor;
import com.linkedin.data.transform.DataProcessingException;
import com.linkedin.data.transform.Interpreter;
import com.linkedin.data.transform.filter.FilterConstants;
import com.linkedin.data.transform.filter.request.MaskTree;
import com.linkedin.data.transform.patch.Patch;
import com.linkedin.restli.common.PatchRequest;
import com.linkedin.restli.common.ResourceMethod;
import com.linkedin.restli.common.validation.CreateOnly;
import com.linkedin.restli.common.validation.ReadOnly;
import com.linkedin.restli.restspec.RestSpecAnnotation;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class RestLiDataValidator {
    private static final Set<ResourceMethod> readOnlyRestrictedMethods = new HashSet<ResourceMethod>(Arrays.asList(ResourceMethod.CREATE, ResourceMethod.PARTIAL_UPDATE, ResourceMethod.BATCH_CREATE, ResourceMethod.BATCH_PARTIAL_UPDATE));
    private static final Set<ResourceMethod> createOnlyRestrictedMethods = new HashSet<ResourceMethod>(Arrays.asList(ResourceMethod.PARTIAL_UPDATE, ResourceMethod.BATCH_PARTIAL_UPDATE));
    private static final Set<ResourceMethod> readOnlyOptional = new HashSet<ResourceMethod>(Arrays.asList(ResourceMethod.CREATE, ResourceMethod.BATCH_CREATE));
    private final Predicate _readOnlyPredicate;
    private final Predicate _createOnlyPredicate;
    private final Predicate _readOnlyDescendantPredicate;
    private final Predicate _createOnlyDescendantPredicate;
    private final Class<? extends RecordTemplate> _valueClass;
    private final ResourceMethod _resourceMethod;
    private final Map<String, Class<? extends Validator>> _validatorClassMap;
    private static final String INSTANTIATION_ERROR = "InstantiationException while trying to instantiate the record template class";
    private static final String ILLEGAL_ACCESS_ERROR = "IllegalAccessException while trying to instantiate the record template class";
    private static final String TEMPLATE_RUNTIME_ERROR = "TemplateRuntimeException while trying to find the schema class";

    private static PathMatchesPatternPredicate stringToPredicate(String path, boolean includeDescendants) {
        if (path.length() > 0 && path.charAt(0) == DataElement.SEPARATOR.charValue()) {
            path = path.substring(1);
        }
        String[] components = path.split(DataElement.SEPARATOR.toString());
        int length = components.length + (includeDescendants ? 1 : 0);
        Object[] componentsWithWildcards = new Object[length];
        int i = 0;
        for (String component : components) {
            componentsWithWildcards[i++] = component.equals(PathSpec.WILDCARD) ? Wildcard.ANY_ONE : component;
        }
        if (includeDescendants) {
            componentsWithWildcards[components.length] = Wildcard.ANY_ZERO_OR_MORE;
        }
        return new PathMatchesPatternPredicate(componentsWithWildcards);
    }

    private static Map<String, List<String>> annotationsToMap(Annotation[] annotations) {
        HashMap<String, List<String>> annotationMap = new HashMap<String, List<String>>();
        if (annotations != null) {
            for (Annotation annotation : annotations) {
                if (annotation.annotationType() == ReadOnly.class) {
                    annotationMap.put(ReadOnly.class.getAnnotation(RestSpecAnnotation.class).name(), Arrays.asList(((ReadOnly)annotation).value()));
                    continue;
                }
                if (annotation.annotationType() != CreateOnly.class) continue;
                annotationMap.put(CreateOnly.class.getAnnotation(RestSpecAnnotation.class).name(), Arrays.asList(((CreateOnly)annotation).value()));
            }
        }
        return annotationMap;
    }

    public RestLiDataValidator(Annotation[] annotations, Class<? extends RecordTemplate> valueClass, ResourceMethod resourceMethod) {
        this(annotations, valueClass, resourceMethod, Collections.emptyMap());
    }

    public RestLiDataValidator(Annotation[] annotations, Class<? extends RecordTemplate> valueClass, ResourceMethod resourceMethod, Map<String, Class<? extends Validator>> validatorClassMap) {
        this(RestLiDataValidator.annotationsToMap(annotations), valueClass, resourceMethod, validatorClassMap);
    }

    public RestLiDataValidator(Map<String, List<String>> annotations, Class<? extends RecordTemplate> valueClass, ResourceMethod resourceMethod) {
        this(annotations, valueClass, resourceMethod, Collections.emptyMap());
    }

    public RestLiDataValidator(Map<String, List<String>> annotations, Class<? extends RecordTemplate> valueClass, ResourceMethod resourceMethod, Map<String, Class<? extends Validator>> validatorClassMap) {
        ArrayList<PathMatchesPatternPredicate> readOnly = new ArrayList<PathMatchesPatternPredicate>();
        ArrayList<PathMatchesPatternPredicate> createOnly = new ArrayList<PathMatchesPatternPredicate>();
        ArrayList<PathMatchesPatternPredicate> readOnlyDescendant = new ArrayList<PathMatchesPatternPredicate>();
        ArrayList<PathMatchesPatternPredicate> createOnlyDescendant = new ArrayList<PathMatchesPatternPredicate>();
        if (annotations != null) {
            for (Map.Entry<String, List<String>> entry : annotations.entrySet()) {
                String annotationName = entry.getKey();
                if (annotationName.equals(ReadOnly.class.getAnnotation(RestSpecAnnotation.class).name()) && readOnlyRestrictedMethods.contains((Object)resourceMethod)) {
                    for (String path : entry.getValue()) {
                        readOnly.add(RestLiDataValidator.stringToPredicate(path, false));
                        readOnlyDescendant.add(RestLiDataValidator.stringToPredicate(path, true));
                    }
                    continue;
                }
                if (!annotationName.equals(CreateOnly.class.getAnnotation(RestSpecAnnotation.class).name()) || !createOnlyRestrictedMethods.contains((Object)resourceMethod)) continue;
                for (String path : entry.getValue()) {
                    createOnly.add(RestLiDataValidator.stringToPredicate(path, false));
                    createOnlyDescendant.add(RestLiDataValidator.stringToPredicate(path, true));
                }
            }
        }
        this._readOnlyPredicate = Predicates.or(readOnly);
        this._createOnlyPredicate = Predicates.or(createOnly);
        this._readOnlyDescendantPredicate = Predicates.or(readOnlyDescendant);
        this._createOnlyDescendantPredicate = Predicates.or(createOnlyDescendant);
        this._valueClass = valueClass;
        this._resourceMethod = resourceMethod;
        this._validatorClassMap = Collections.unmodifiableMap(validatorClassMap);
    }

    @Deprecated
    public ValidationResult validate(DataTemplate<?> dataTemplate) {
        switch (this._resourceMethod) {
            case PARTIAL_UPDATE: 
            case BATCH_PARTIAL_UPDATE: {
                return this.validatePatch((PatchRequest)dataTemplate);
            }
            case CREATE: 
            case BATCH_CREATE: 
            case UPDATE: 
            case BATCH_UPDATE: {
                return this.validateInputEntity((RecordTemplate)dataTemplate);
            }
            case GET: 
            case BATCH_GET: 
            case FINDER: 
            case GET_ALL: {
                return this.validateOutputEntity((RecordTemplate)dataTemplate, null);
            }
        }
        throw new IllegalArgumentException("Cannot perform Rest.li validation for " + this._resourceMethod.toString());
    }

    public ValidationResult validateInput(RecordTemplate dataTemplate) {
        if (dataTemplate == null) {
            throw new IllegalArgumentException("Record template is null.");
        }
        if (dataTemplate.data() == null) {
            throw new IllegalArgumentException("Record template does not have data.");
        }
        if (dataTemplate.schema() == null) {
            throw new IllegalArgumentException("Record template does not have a schema.");
        }
        switch (this._resourceMethod) {
            case CREATE: 
            case BATCH_CREATE: 
            case UPDATE: 
            case BATCH_UPDATE: {
                return this.validateInputEntity(dataTemplate);
            }
        }
        throw new IllegalArgumentException("Cannot perform Rest.li input (entity) validation for " + this._resourceMethod.toString());
    }

    public ValidationResult validateInput(PatchRequest<?> patchRequest) {
        if (patchRequest == null) {
            throw new IllegalArgumentException("Patch request is null.");
        }
        if (patchRequest.getPatchDocument() == null) {
            throw new IllegalArgumentException("Patch request does not have a patch document.");
        }
        switch (this._resourceMethod) {
            case PARTIAL_UPDATE: 
            case BATCH_PARTIAL_UPDATE: {
                return this.validatePatch(patchRequest);
            }
        }
        throw new IllegalArgumentException("Cannot perform Rest.li input (patch) validation for " + this._resourceMethod.toString());
    }

    public ValidationResult validateOutput(RecordTemplate dataTemplate) {
        return this.validateOutput(dataTemplate, null);
    }

    public ValidationResult validateOutput(RecordTemplate dataTemplate, MaskTree projectionMask) {
        if (dataTemplate == null) {
            throw new IllegalArgumentException("Record template is null.");
        }
        if (dataTemplate.data() == null) {
            throw new IllegalArgumentException("Record template does not have data.");
        }
        switch (this._resourceMethod) {
            case CREATE: 
            case BATCH_CREATE: 
            case GET: 
            case BATCH_GET: 
            case FINDER: 
            case GET_ALL: {
                return this.validateOutputEntity(dataTemplate, projectionMask);
            }
        }
        throw new IllegalArgumentException("Cannot perform Rest.li output validation for " + this._resourceMethod.toString());
    }

    private ValidationResult validatePatch(PatchRequest<?> patchRequest) {
        MessageList messages;
        RecordTemplate entity;
        try {
            entity = this._valueClass.newInstance();
        }
        catch (InstantiationException e) {
            return RestLiDataValidator.validationResultWithErrorMessage(INSTANTIATION_ERROR);
        }
        catch (IllegalAccessException e) {
            return RestLiDataValidator.validationResultWithErrorMessage(ILLEGAL_ACCESS_ERROR);
        }
        PatchRequest<?> patch = patchRequest;
        DataComplexProcessor processor = new DataComplexProcessor((Interpreter)new Patch(true), patch.getPatchDocument(), (DataComplex)entity.data());
        try {
            messages = processor.runDataProcessing(false);
        }
        catch (DataProcessingException e) {
            return RestLiDataValidator.validationResultWithErrorMessage("Error while applying patch: " + e.getMessage());
        }
        ValidationErrorResult checkDeleteResult = new ValidationErrorResult();
        this.checkDeletesAreValid((DataSchema)entity.schema(), (MessageList<Message>)messages, checkDeleteResult);
        if (!checkDeleteResult.isValid()) {
            return checkDeleteResult;
        }
        ValidationResult checkSetResult = this.checkNewRecordsAreNotMissingFields(entity, (MessageList<Message>)messages);
        if (checkSetResult != null) {
            return checkSetResult;
        }
        return ValidateDataAgainstSchema.validate((DataElement)new SimpleDataElement((Object)entity.data(), (DataSchema)entity.schema()), (ValidationOptions)new ValidationOptions(RequiredMode.IGNORE), (Validator)new DataValidator((DataSchema)entity.schema()));
    }

    private ValidationResult checkNewRecordsAreNotMissingFields(RecordTemplate entity, MessageList<Message> messages) {
        for (Message message : messages) {
            Object[] path = message.getPath();
            if (!path[path.length - 1].toString().equals("$set")) continue;
            path[path.length - 1] = message.getFormat();
            DataElement element = DataElementUtil.element((DataElement)new SimpleDataElement((Object)entity.data(), (DataSchema)entity.schema()), (Object[])path);
            ValidationResult result = ValidateDataAgainstSchema.validate((DataElement)element, (ValidationOptions)new ValidationOptions());
            if (result.isValid()) continue;
            return result;
        }
        return null;
    }

    private static DataElement hollowElementFromPath(Object[] path) {
        SimpleDataElement root;
        SimpleDataElement current = root = new SimpleDataElement(null, null);
        for (Object component : path) {
            SimpleDataElement child;
            current = child = new SimpleDataElement(null, (Object)component.toString(), null, (DataElement)current);
        }
        return current;
    }

    private void checkDeletesAreValid(DataSchema schema, MessageList<Message> messages, ValidationErrorResult result) {
        for (Message message : messages) {
            DataElement fakeElement;
            Object[] path = message.getPath();
            if (!path[path.length - 1].toString().equals("$delete")) continue;
            path[path.length - 1] = message.getFormat();
            RecordDataSchema.Field field = DataSchemaUtil.getField((DataSchema)schema, (Object[])path);
            if (field != null && !field.getOptional() && field.getDefault() == null) {
                result.addMessage(new Message(path, "cannot delete a required field", new Object[0]));
            }
            if (this._readOnlyDescendantPredicate.evaluate(fakeElement = RestLiDataValidator.hollowElementFromPath(path))) {
                result.addMessage(new Message(path, "cannot delete a ReadOnly field or its descendants", new Object[0]));
                continue;
            }
            if (!this._createOnlyDescendantPredicate.evaluate(fakeElement)) continue;
            result.addMessage(new Message(path, "cannot delete a CreateOnly field or its descendants", new Object[0]));
        }
    }

    private ValidationResult validateInputEntity(RecordTemplate entity) {
        ValidationOptions validationOptions = new ValidationOptions();
        if (readOnlyOptional.contains((Object)this._resourceMethod)) {
            validationOptions.setTreatOptional(this._readOnlyPredicate);
        }
        ValidationResult result = ValidateDataAgainstSchema.validate((DataTemplate)entity, (ValidationOptions)validationOptions, (Validator)new DataValidator((DataSchema)entity.schema()));
        return result;
    }

    private ValidationResult validateOutputEntity(RecordTemplate entity, MaskTree projectionMask) {
        try {
            DataSchema originalSchema = DataTemplateUtil.getSchema(this._valueClass);
            DataSchema validatingSchema = projectionMask != null ? RestLiDataValidator.buildSchemaByProjection(originalSchema, projectionMask.getDataMap()) : originalSchema;
            DataSchemaAnnotationValidator validator = new DataSchemaAnnotationValidator(validatingSchema);
            return ValidateDataAgainstSchema.validate((Object)entity.data(), (DataSchema)validatingSchema, (ValidationOptions)new ValidationOptions(), (Validator)validator);
        }
        catch (TemplateRuntimeException e) {
            return RestLiDataValidator.validationResultWithErrorMessage(TEMPLATE_RUNTIME_ERROR);
        }
    }

    private static DataSchema buildSchemaByProjection(DataSchema schema, DataMap maskMap) {
        if (maskMap == null || maskMap.isEmpty()) {
            throw new IllegalArgumentException("Invalid projection masks.");
        }
        if (schema instanceof RecordDataSchema) {
            return RestLiDataValidator.buildRecordDataSchemaByProjection((RecordDataSchema)schema, maskMap);
        }
        if (schema instanceof UnionDataSchema) {
            return RestLiDataValidator.buildUnionDataSchemaByProjection((UnionDataSchema)schema, maskMap);
        }
        if (schema instanceof ArrayDataSchema) {
            return RestLiDataValidator.buildArrayDataSchemaByProjection((ArrayDataSchema)schema, maskMap);
        }
        if (schema instanceof MapDataSchema) {
            return RestLiDataValidator.buildMapDataSchemaByProjection((MapDataSchema)schema, maskMap);
        }
        if (schema instanceof TyperefDataSchema) {
            return RestLiDataValidator.buildTyperefDataSchemaByProjection((TyperefDataSchema)schema, maskMap);
        }
        throw new IllegalArgumentException("Unexpected data schema type: " + schema);
    }

    private static TyperefDataSchema buildTyperefDataSchemaByProjection(TyperefDataSchema originalSchema, DataMap maskMap) {
        TyperefDataSchema newSchema = new TyperefDataSchema(new Name(originalSchema.getFullName()));
        if (originalSchema.getProperties() != null) {
            newSchema.setProperties(originalSchema.getProperties());
        }
        if (originalSchema.getDoc() != null) {
            newSchema.setDoc(originalSchema.getDoc());
        }
        if (originalSchema.getAliases() != null) {
            newSchema.setAliases(originalSchema.getAliases());
        }
        DataSchema newRefSchema = RestLiDataValidator.buildSchemaByProjection(originalSchema.getRef(), maskMap);
        newSchema.setReferencedType(newRefSchema);
        return newSchema;
    }

    private static MapDataSchema buildMapDataSchemaByProjection(MapDataSchema originalSchema, DataMap maskMap) {
        if (maskMap.containsKey((Object)"$*")) {
            DataSchema newValuesSchema = RestLiDataValidator.reuseOrBuildDataSchema(originalSchema.getValues(), maskMap.get((Object)"$*"));
            MapDataSchema newSchema = new MapDataSchema(newValuesSchema);
            if (originalSchema.getProperties() != null) {
                newSchema.setProperties(originalSchema.getProperties());
            }
            return newSchema;
        }
        throw new IllegalArgumentException("Missing wildcard key in projection mask: " + maskMap.keySet());
    }

    private static ArrayDataSchema buildArrayDataSchemaByProjection(ArrayDataSchema originalSchema, DataMap maskMap) {
        if (maskMap.containsKey((Object)"$*")) {
            DataSchema newItemsSchema = RestLiDataValidator.reuseOrBuildDataSchema(originalSchema.getItems(), maskMap.get((Object)"$*"));
            ArrayDataSchema newSchema = new ArrayDataSchema(newItemsSchema);
            if (originalSchema.getProperties() != null) {
                newSchema.setProperties(originalSchema.getProperties());
            }
            return newSchema;
        }
        throw new IllegalArgumentException("Missing wildcard key in projection mask: " + maskMap.keySet());
    }

    private static UnionDataSchema buildUnionDataSchemaByProjection(UnionDataSchema originalSchema, DataMap maskMap) {
        ArrayList<DataSchema> newUnionTypeSchemas = new ArrayList<DataSchema>();
        for (Map.Entry maskEntry : maskMap.entrySet()) {
            DataSchema originalTypeSchema = originalSchema.getType((String)maskEntry.getKey());
            DataSchema typeSchemaToUse = RestLiDataValidator.reuseOrBuildDataSchema(originalTypeSchema, maskEntry.getValue());
            newUnionTypeSchemas.add(typeSchemaToUse);
        }
        UnionDataSchema newSchema = new UnionDataSchema();
        newSchema.setTypes(newUnionTypeSchemas, new StringBuilder());
        if (originalSchema.getProperties() != null) {
            newSchema.setProperties(originalSchema.getProperties());
        }
        return newSchema;
    }

    private static RecordDataSchema buildRecordDataSchemaByProjection(RecordDataSchema originalSchema, DataMap maskMap) {
        RecordDataSchema newRecordSchema = new RecordDataSchema(new Name(originalSchema.getFullName()), RecordDataSchema.RecordType.RECORD);
        ArrayList<RecordDataSchema.Field> newFields = new ArrayList<RecordDataSchema.Field>();
        for (Map.Entry maskEntry : maskMap.entrySet()) {
            RecordDataSchema.Field originalField = originalSchema.getField((String)maskEntry.getKey());
            DataSchema fieldSchemaToUse = RestLiDataValidator.reuseOrBuildDataSchema(originalField.getType(), maskEntry.getValue());
            RecordDataSchema.Field newField = RestLiDataValidator.buildRecordField(originalField, fieldSchemaToUse, newRecordSchema);
            newFields.add(newField);
        }
        newRecordSchema.setFields(newFields, new StringBuilder());
        if (originalSchema.getAliases() != null) {
            newRecordSchema.setAliases(originalSchema.getAliases());
        }
        if (originalSchema.getDoc() != null) {
            newRecordSchema.setDoc(originalSchema.getDoc());
        }
        if (originalSchema.getProperties() != null) {
            newRecordSchema.setProperties(originalSchema.getProperties());
        }
        return newRecordSchema;
    }

    private static DataSchema reuseOrBuildDataSchema(DataSchema originalSchema, Object maskValue) {
        if (maskValue instanceof Integer && maskValue.equals(FilterConstants.POSITIVE)) {
            return originalSchema;
        }
        if (maskValue instanceof DataMap) {
            return RestLiDataValidator.buildSchemaByProjection(originalSchema, (DataMap)maskValue);
        }
        throw new IllegalArgumentException("Expected mask value to be either positive mask op or DataMap: " + maskValue);
    }

    private static RecordDataSchema.Field buildRecordField(RecordDataSchema.Field originalField, DataSchema fieldSchemaToReplace, RecordDataSchema recordSchemaToReplace) {
        RecordDataSchema.Field newField = new RecordDataSchema.Field(fieldSchemaToReplace);
        if (originalField.getAliases() != null) {
            newField.setAliases(originalField.getAliases(), new StringBuilder());
        }
        if (originalField.getDefault() != null) {
            newField.setDefault(originalField.getDefault());
        }
        if (originalField.getDoc() != null) {
            newField.setDoc(originalField.getDoc());
        }
        if (originalField.getName() != null) {
            newField.setName(originalField.getName(), new StringBuilder());
        }
        if (originalField.getOrder() != null) {
            newField.setOrder(originalField.getOrder());
        }
        if (originalField.getProperties() != null) {
            newField.setProperties(originalField.getProperties());
        }
        newField.setRecord(recordSchemaToReplace);
        newField.setOptional(originalField.getOptional());
        return newField;
    }

    private static ValidationErrorResult validationResultWithErrorMessage(String errorMessage) {
        ValidationErrorResult result = new ValidationErrorResult();
        result.addMessage(new Message(new Object[0], errorMessage, new Object[0]));
        return result;
    }

    private static class ValidationErrorResult
    implements ValidationResult {
        private MessageList<Message> _messages = new MessageList();

        private ValidationErrorResult() {
        }

        public boolean hasFix() {
            return false;
        }

        public boolean hasFixupReadOnlyError() {
            return false;
        }

        public Object getFixed() {
            return null;
        }

        public boolean isValid() {
            return this._messages.isEmpty();
        }

        public void addMessage(Message message) {
            this._messages.add((Object)message);
        }

        public Collection<Message> getMessages() {
            return this._messages;
        }
    }

    private class DataValidator
    extends DataSchemaAnnotationValidator {
        private DataValidator(DataSchema schema) {
            super(schema, RestLiDataValidator.this._validatorClassMap);
        }

        public void validate(ValidatorContext context) {
            super.validate(context);
            DataElement element = context.dataElement();
            if (RestLiDataValidator.this._readOnlyPredicate.evaluate(element)) {
                context.addResult(new Message(element.path(), "ReadOnly field present in a %s request", new Object[]{RestLiDataValidator.this._resourceMethod.toString()}));
            }
            if (RestLiDataValidator.this._createOnlyPredicate.evaluate(element)) {
                context.addResult(new Message(element.path(), "CreateOnly field present in a %s request", new Object[]{RestLiDataValidator.this._resourceMethod.toString()}));
            }
        }
    }
}

