/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.common.util;

import com.linkedin.data.template.StringArray;
import com.linkedin.restli.restspec.ActionSchema;
import com.linkedin.restli.restspec.ActionSchemaArray;
import com.linkedin.restli.restspec.ActionsSetSchema;
import com.linkedin.restli.restspec.AssociationSchema;
import com.linkedin.restli.restspec.CollectionSchema;
import com.linkedin.restli.restspec.CustomAnnotationContentSchemaMap;
import com.linkedin.restli.restspec.EntitySchema;
import com.linkedin.restli.restspec.FinderSchema;
import com.linkedin.restli.restspec.FinderSchemaArray;
import com.linkedin.restli.restspec.ResourceSchema;
import com.linkedin.restli.restspec.RestMethodSchema;
import com.linkedin.restli.restspec.RestMethodSchemaArray;
import com.linkedin.restli.restspec.SimpleSchema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class RichResourceSchema {
    private final ResourceSchema _resourceSchema;
    private final ResourceType _type;
    private final StringArray _supports;
    private final RestMethodSchemaArray _methods;
    private final FinderSchemaArray _finders;
    private final ActionSchemaArray _actions;
    private final EntitySchema _entity;
    private final ActionSchemaArray _entityActions;
    private final Collection<RichResourceSchema> _subresources;
    private final Map<String, RestMethodSchema> _methodsByName;
    private final Map<String, FinderSchema> _findersByName;
    private final Map<String, ActionSchema> _actionsByName;
    private final Map<String, ActionSchema> _entityActionsByName;
    private final Map<String, RichResourceSchema> _subresourcesByName;

    public static Collection<RichResourceSchema> toRichResourceSchemas(Collection<ResourceSchema> resourceSchemas) {
        ArrayList<RichResourceSchema> results = new ArrayList<RichResourceSchema>(resourceSchemas.size());
        for (ResourceSchema resourceSchema : resourceSchemas) {
            results.add(new RichResourceSchema(resourceSchema));
        }
        return results;
    }

    public RichResourceSchema(ResourceSchema resourceSchema) {
        SimpleSchema simple;
        this._resourceSchema = resourceSchema;
        if (resourceSchema.hasCollection()) {
            CollectionSchema collection = resourceSchema.getCollection();
            this._type = ResourceType.COLLECTION;
            this._supports = collection.getSupports();
            this._methods = collection.hasMethods() ? collection.getMethods() : new RestMethodSchemaArray(0);
            this._finders = collection.hasFinders() ? collection.getFinders() : new FinderSchemaArray(0);
            this._actions = collection.hasActions() ? collection.getActions() : new ActionSchemaArray(0);
            this._entity = collection.getEntity();
        } else if (resourceSchema.hasAssociation()) {
            this._type = ResourceType.ASSOCIATION;
            AssociationSchema association = resourceSchema.getAssociation();
            this._supports = association.getSupports();
            this._methods = association.hasMethods() ? association.getMethods() : new RestMethodSchemaArray(0);
            this._finders = association.hasFinders() ? association.getFinders() : new FinderSchemaArray(0);
            this._actions = association.hasActions() ? association.getActions() : new ActionSchemaArray(0);
            this._entity = association.getEntity();
        } else if (resourceSchema.hasSimple()) {
            this._type = ResourceType.SIMPLE;
            simple = resourceSchema.getSimple();
            this._supports = simple.getSupports();
            this._methods = simple.hasMethods() ? simple.getMethods() : new RestMethodSchemaArray(0);
            this._finders = new FinderSchemaArray(0);
            this._actions = new ActionSchemaArray(0);
            this._entity = simple.getEntity();
        } else if (resourceSchema.hasActionsSet()) {
            this._type = ResourceType.ACTION_SET;
            ActionsSetSchema actionSet = resourceSchema.getActionsSet();
            this._supports = new StringArray(0);
            this._methods = new RestMethodSchemaArray(0);
            this._finders = new FinderSchemaArray(0);
            this._actions = actionSet.hasActions() ? actionSet.getActions() : new ActionSchemaArray(0);
            this._entity = null;
        } else {
            throw new IllegalArgumentException("Invalid resourceSchema, must be one of: " + EnumSet.allOf(ResourceType.class));
        }
        this._entityActions = resourceSchema.hasSimple() ? ((simple = resourceSchema.getSimple()).hasActions() ? simple.getActions() : new ActionSchemaArray(0)) : (this._entity != null ? (this._entity.hasActions() ? this._entity.getActions() : new ActionSchemaArray(0)) : new ActionSchemaArray(0));
        this._subresources = this._entity != null ? (this._entity.hasSubresources() ? RichResourceSchema.toRichResourceSchemas((Collection<ResourceSchema>)((Object)this._entity.getSubresources())) : Collections.emptyList()) : Collections.emptyList();
        this._methodsByName = new HashMap<String, RestMethodSchema>(this._methods.size());
        Iterator<RichResourceSchema> iterator = this._methods.iterator();
        while (iterator.hasNext()) {
            RestMethodSchema method = (RestMethodSchema)((Object)iterator.next());
            this._methodsByName.put(method.getMethod(), method);
        }
        this._findersByName = new HashMap<String, FinderSchema>(this._finders.size());
        iterator = this._finders.iterator();
        while (iterator.hasNext()) {
            FinderSchema finder = (FinderSchema)((Object)iterator.next());
            this._findersByName.put(finder.getName(), finder);
        }
        this._actionsByName = new HashMap<String, ActionSchema>(this._actions.size());
        iterator = this._actions.iterator();
        while (iterator.hasNext()) {
            ActionSchema action = (ActionSchema)((Object)iterator.next());
            this._actionsByName.put(action.getName(), action);
        }
        this._entityActionsByName = new HashMap<String, ActionSchema>(this._entityActions.size());
        iterator = this._entityActions.iterator();
        while (iterator.hasNext()) {
            ActionSchema entityAction = (ActionSchema)((Object)iterator.next());
            this._entityActionsByName.put(entityAction.getName(), entityAction);
        }
        this._subresourcesByName = new HashMap<String, RichResourceSchema>(this._subresources.size());
        for (RichResourceSchema subresource : this._subresources) {
            this._subresourcesByName.put(subresource.getName(), subresource);
        }
    }

    public String getName() {
        return this._resourceSchema.getName();
    }

    public String getNamespace() {
        return this._resourceSchema.getNamespace();
    }

    public String getPath() {
        return this._resourceSchema.getPath();
    }

    public String getSchema() {
        return this._resourceSchema.getSchema();
    }

    public String getDoc() {
        return this._resourceSchema.getDoc();
    }

    public CustomAnnotationContentSchemaMap getAnnotations() {
        return this._resourceSchema.getAnnotations();
    }

    public ResourceSchema getResourceSchema() {
        return this._resourceSchema;
    }

    public ResourceType getType() {
        return this._type;
    }

    public StringArray getSupports() {
        return this._supports;
    }

    public RestMethodSchemaArray getMethods() {
        return this._methods;
    }

    public RestMethodSchema getMethod(String name) {
        return this._methodsByName.get(name);
    }

    public FinderSchemaArray getFinders() {
        return this._finders;
    }

    public FinderSchema getFinder(String name) {
        return this._findersByName.get(name);
    }

    public ActionSchemaArray getActions() {
        return this._actions;
    }

    public ActionSchema getAction(String name) {
        return this._actionsByName.get(name);
    }

    public EntitySchema getEntity() {
        return this._entity;
    }

    public ActionSchemaArray getEntityActions() {
        return this._entityActions;
    }

    public ActionSchema getEntityAction(String name) {
        return this._entityActionsByName.get(name);
    }

    public Collection<RichResourceSchema> getSubresources() {
        return this._subresources;
    }

    public RichResourceSchema getSubresource(String name) {
        return this._subresourcesByName.get(name);
    }

    public static enum ResourceType {
        COLLECTION,
        ASSOCIATION,
        SIMPLE,
        ACTION_SET;

    }
}

