/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.common.multiplexer;

import com.linkedin.data.DataMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import com.linkedin.restli.common.multiplexer.IndividualResponseMap;
import java.util.List;
import javax.annotation.Nonnull;

public class MultiplexedResponseContent
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema((String)"{\"type\":\"record\",\"name\":\"MultiplexedResponseContent\",\"namespace\":\"com.linkedin.restli.common.multiplexer\",\"doc\":\"Represents multiple HTTP responses to send as a single multiplexed HTTP response\",\"fields\":[{\"name\":\"responses\",\"type\":{\"type\":\"map\",\"values\":{\"type\":\"record\",\"name\":\"IndividualResponse\",\"doc\":\"Individual HTTP response within a multiplexed response\",\"fields\":[{\"name\":\"status\",\"type\":\"int\",\"doc\":\"HTTP status code\"},{\"name\":\"headers\",\"type\":{\"type\":\"map\",\"values\":\"string\"},\"doc\":\"HTTP headers\",\"default\":{}},{\"name\":\"body\",\"type\":{\"type\":\"record\",\"name\":\"IndividualBody\",\"doc\":\"Represents content that may be in the body of an individual request / response\",\"fields\":[]},\"doc\":\"Response body\",\"optional\":true}]}},\"doc\":\"Individual HTTP responses, where the key is Id of the corresponding individual request.\"}]}");
    private static final RecordDataSchema.Field FIELD_Responses = SCHEMA.getField("responses");

    public MultiplexedResponseContent() {
        super(new DataMap(), SCHEMA);
    }

    public MultiplexedResponseContent(DataMap data) {
        super(data, SCHEMA);
    }

    public static Fields fields() {
        return _fields;
    }

    public boolean hasResponses() {
        return this.contains(FIELD_Responses);
    }

    public void removeResponses() {
        this.remove(FIELD_Responses);
    }

    public IndividualResponseMap getResponses(GetMode mode) {
        return (IndividualResponseMap)this.obtainWrapped(FIELD_Responses, IndividualResponseMap.class, mode);
    }

    @Nonnull
    public IndividualResponseMap getResponses() {
        return (IndividualResponseMap)this.obtainWrapped(FIELD_Responses, IndividualResponseMap.class, GetMode.STRICT);
    }

    public MultiplexedResponseContent setResponses(IndividualResponseMap value, SetMode mode) {
        this.putWrapped(FIELD_Responses, IndividualResponseMap.class, (DataTemplate)value, mode);
        return this;
    }

    public MultiplexedResponseContent setResponses(@Nonnull IndividualResponseMap value) {
        this.putWrapped(FIELD_Responses, IndividualResponseMap.class, (DataTemplate)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public MultiplexedResponseContent clone() throws CloneNotSupportedException {
        return (MultiplexedResponseContent)super.clone();
    }

    public MultiplexedResponseContent copy() throws CloneNotSupportedException {
        return (MultiplexedResponseContent)super.copy();
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public IndividualResponseMap.Fields responses() {
            return new IndividualResponseMap.Fields(this.getPathComponents(), "responses");
        }
    }
}

