/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.common;

import com.linkedin.data.DataMap;
import com.linkedin.data.schema.DataSchema;
import com.linkedin.data.schema.MapDataSchema;
import com.linkedin.data.schema.Name;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.IntegerMap;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.WrappingMapTemplate;
import com.linkedin.restli.common.ErrorResponse;
import com.linkedin.restli.common.ProtocolVersion;
import com.linkedin.restli.internal.common.URIParamUtils;
import java.util.Arrays;
import java.util.Map;

public class BatchResponse<T extends RecordTemplate>
extends RecordTemplate {
    public static final String RESULTS = "results";
    public static final String STATUSES = "statuses";
    public static final String ERRORS = "errors";
    private final Class<T> _valueClass;
    private final MapDataSchema _resultsSchema;
    private final RecordDataSchema.Field _resultsField;
    private final MapDataSchema _errorsSchema;
    private final RecordDataSchema.Field _errorsField;
    private final RecordDataSchema _schema;
    private static final Name _BATCH_RESPONSE_NAME = new Name(BatchResponse.class.getSimpleName());

    public BatchResponse(DataMap data, Class<T> valueClass) {
        this(data, valueClass, 0, 0);
    }

    public BatchResponse(Class<T> valueClass, int resultsCapacity, int errorsCapacity) {
        this(new DataMap(), valueClass, resultsCapacity, errorsCapacity);
    }

    private BatchResponse(DataMap data, Class<T> valueClass, int resultsCapacity, int errorsCapacity) {
        super(data, null);
        this._valueClass = valueClass;
        StringBuilder errorMessageBuilder = new StringBuilder(10);
        Name elementSchemaName = new Name(valueClass.getSimpleName());
        this._resultsSchema = new MapDataSchema((DataSchema)new RecordDataSchema(elementSchemaName, RecordDataSchema.RecordType.RECORD));
        this._resultsField = new RecordDataSchema.Field((DataSchema)this._resultsSchema);
        this._resultsField.setName(RESULTS, errorMessageBuilder);
        Name errorSchemaName = new Name(ErrorResponse.class.getSimpleName());
        this._errorsSchema = new MapDataSchema((DataSchema)new RecordDataSchema(errorSchemaName, RecordDataSchema.RecordType.RECORD));
        this._errorsField = new RecordDataSchema.Field((DataSchema)this._errorsSchema);
        this._errorsField.setName(ERRORS, errorMessageBuilder);
        if (this.data().get((Object)RESULTS) == null) {
            this.data().put((Object)RESULTS, (Object)new DataMap(resultsCapacity));
        }
        if (this.data().get((Object)ERRORS) == null) {
            this.data().put((Object)ERRORS, (Object)new DataMap(errorsCapacity));
        }
        this._schema = new RecordDataSchema(_BATCH_RESPONSE_NAME, RecordDataSchema.RecordType.RECORD);
        this._schema.setFields(Arrays.asList(this._resultsField, this._errorsField), errorMessageBuilder);
    }

    public RecordDataSchema schema() {
        return this._schema;
    }

    public Map<String, T> getResults() {
        DataMap value = this.data().getDataMap(RESULTS);
        return new DynamicRecordMap<T>(value, this._resultsSchema, this._valueClass);
    }

    public Map<String, Integer> getStatuses() {
        DataMap value = this.data().getDataMap(STATUSES);
        return (Map)DataTemplateUtil.wrap((Object)value, IntegerMap.class);
    }

    public Map<String, ErrorResponse> getErrors() {
        DataMap value = this.data().getDataMap(ERRORS);
        return new DynamicRecordMap<ErrorResponse>(value, this._errorsSchema, ErrorResponse.class);
    }

    public static String keyToString(Object key, ProtocolVersion version) {
        return URIParamUtils.encodeKeyForBody(key, false, version);
    }

    private static class DynamicRecordMap<R extends RecordTemplate>
    extends WrappingMapTemplate<R> {
        public DynamicRecordMap(DataMap map, MapDataSchema mapSchema, Class<R> valueClass) {
            super(map, mapSchema, valueClass);
        }
    }
}

