/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.yarn;

import com.google.common.collect.ImmutableSet;
import com.typesafe.config.Config;
import java.io.IOException;
import java.util.Set;
import org.apache.gobblin.util.logs.LogCopier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ContainerId;

class GobblinYarnLogSource {
    GobblinYarnLogSource() {
    }

    protected boolean isLogSourcePresent() {
        return System.getenv().containsKey(ApplicationConstants.Environment.LOG_DIRS.toString());
    }

    protected LogCopier buildLogCopier(Config config, ContainerId containerId, FileSystem destFs, Path appWorkDir) throws IOException {
        LogCopier.Builder builder = LogCopier.newBuilder().useSrcFileSystem((FileSystem)FileSystem.getLocal((Configuration)new Configuration())).useDestFileSystem(destFs).readFrom(this.getLocalLogDir()).writeTo(this.getHdfsLogDir(containerId, destFs, appWorkDir)).acceptsLogFileExtensions((Set)ImmutableSet.of((Object)"stdout", (Object)"stderr")).useLogFileNamePrefix(containerId.toString());
        if (config.hasPath("gobblin.yarn.log.copier.max.file.size")) {
            builder.useMaxBytesPerLogFile(config.getBytes("gobblin.yarn.log.copier.max.file.size").longValue());
        }
        if (config.hasPath("gobblin.yarn.log.copier.scheduler")) {
            builder.useScheduler(config.getString("gobblin.yarn.log.copier.scheduler"));
        }
        return builder.build();
    }

    private Path getLocalLogDir() throws IOException {
        return new Path(System.getenv(ApplicationConstants.Environment.LOG_DIRS.toString()));
    }

    private Path getHdfsLogDir(ContainerId containerId, FileSystem destFs, Path appWorkDir) throws IOException {
        Path logRootDir = new Path(appWorkDir, "_applogs");
        if (!destFs.exists(logRootDir)) {
            destFs.mkdirs(logRootDir);
        }
        return new Path(logRootDir, containerId.toString());
    }
}

