/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.compat.hadoop;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class TextSerializer {
    public static void writeStringAsText(DataOutput stream, String str) throws IOException {
        byte[] utf8Encoded = str.getBytes(StandardCharsets.UTF_8);
        TextSerializer.writeVLong(stream, utf8Encoded.length);
        stream.write(utf8Encoded);
    }

    public static String readTextAsString(DataInput in) throws IOException {
        int bufLen = (int)TextSerializer.readVLong(in);
        byte[] buf = new byte[bufLen];
        in.readFully(buf);
        return new String(buf, StandardCharsets.UTF_8);
    }

    private static void writeVLong(DataOutput stream, long i) throws IOException {
        if (i >= -112L && i <= 127L) {
            stream.writeByte((byte)i);
            return;
        }
        int len = -112;
        if (i < 0L) {
            i ^= 0xFFFFFFFFFFFFFFFFL;
            len = -120;
        }
        long tmp = i;
        while (tmp != 0L) {
            tmp >>= 8;
            --len;
        }
        stream.writeByte((byte)len);
        for (int idx = len = len < -120 ? -(len + 120) : -(len + 112); idx != 0; --idx) {
            int shiftbits = (idx - 1) * 8;
            long mask = 255L << shiftbits;
            stream.writeByte((byte)((i & mask) >> shiftbits));
        }
    }

    private static long readVLong(DataInput stream) throws IOException {
        byte firstByte = stream.readByte();
        int len = TextSerializer.decodeVIntSize(firstByte);
        if (len == 1) {
            return firstByte;
        }
        long i = 0L;
        for (int idx = 0; idx < len - 1; ++idx) {
            byte b = stream.readByte();
            i <<= 8;
            i |= (long)(b & 0xFF);
        }
        return TextSerializer.isNegativeVInt(firstByte) ? i ^ 0xFFFFFFFFFFFFFFFFL : i;
    }

    private static int decodeVIntSize(byte value) {
        if (value >= -112) {
            return 1;
        }
        if (value < -120) {
            return -119 - value;
        }
        return -111 - value;
    }

    private static boolean isNegativeVInt(byte value) {
        return value < -120 || value >= -112 && value < 0;
    }
}

