/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metadata.types;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.DatatypeConverter;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.ObjectCodec;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalMetadata {
    private static final Logger log = LoggerFactory.getLogger(GlobalMetadata.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final JsonFactory jsonFactory = new JsonFactory();
    private static final String EMPTY_ID = "0";
    @JsonProperty(value="dataset")
    private final Map<String, Object> datasetLevel = new ConcurrentHashMap<String, Object>();
    @JsonProperty(value="file")
    private final Map<String, Map<String, Object>> fileLevel = new ConcurrentHashMap<String, Map<String, Object>>();
    @JsonProperty(value="id")
    private String cachedId;
    private transient boolean markedImmutable = false;
    public static final String DATASET_URN_KEY = "Dataset-URN";
    public static final String TRANSFER_ENCODING_KEY = "Transfer-Encoding";
    public static final String CONTENT_TYPE_KEY = "Content-Type";
    public static final String INNER_CONTENT_TYPE_KEY = "Inner-Content-Type";
    public static final String NUM_RECORDS_KEY = "Num-Records";
    public static final String NUM_FILES_KEY = "Num-Files";

    public void markImmutable() {
        this.markedImmutable = true;
    }

    public boolean isImmutable() {
        return this.markedImmutable;
    }

    public static GlobalMetadata fromJson(String json) throws IOException {
        return (GlobalMetadata)objectMapper.readValue(json, GlobalMetadata.class);
    }

    public void addAll(GlobalMetadata other) {
        this.throwIfImmutable();
        this.datasetLevel.putAll(other.datasetLevel);
        for (Map.Entry<String, Map<String, Object>> e : other.fileLevel.entrySet()) {
            ConcurrentHashMap<String, Object> val = new ConcurrentHashMap<String, Object>();
            val.putAll(e.getValue());
            this.fileLevel.put(e.getKey(), val);
        }
        this.cachedId = null;
    }

    public void mergeWithDefaults(GlobalMetadata defaults) {
        List<String> defaultTransferEncoding = defaults.getTransferEncoding();
        List<String> myEncoding = this.getTransferEncoding();
        if (defaultTransferEncoding != null) {
            if (myEncoding == null) {
                this.setDatasetMetadata(TRANSFER_ENCODING_KEY, defaultTransferEncoding);
            } else {
                ArrayList<String> combinedEncoding = new ArrayList<String>();
                combinedEncoding.addAll(myEncoding);
                combinedEncoding.addAll(defaultTransferEncoding);
                this.setDatasetMetadata(TRANSFER_ENCODING_KEY, combinedEncoding);
            }
        }
        for (Map.Entry<String, Object> entry : defaults.datasetLevel.entrySet()) {
            if (this.datasetLevel.containsKey(entry.getKey())) continue;
            this.setDatasetMetadata(entry.getKey(), entry.getValue());
        }
    }

    public byte[] toJsonUtf8() {
        try {
            ByteArrayOutputStream bOs = new ByteArrayOutputStream(512);
            try (JsonGenerator generator = jsonFactory.createJsonGenerator((OutputStream)bOs, JsonEncoding.UTF8).setCodec((ObjectCodec)objectMapper);){
                this.toJsonUtf8(generator);
            }
            return bOs.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected IOException serializing to ByteArray", e);
        }
    }

    public String toJson() throws IOException {
        StringWriter writer = new StringWriter();
        try (JsonGenerator generator = jsonFactory.createJsonGenerator((Writer)writer).setCodec((ObjectCodec)objectMapper);){
            this.toJsonUtf8(generator);
        }
        return writer.toString();
    }

    protected void toJsonUtf8(JsonGenerator generator) throws IOException {
        generator.writeStartObject();
        generator.writeStringField("id", this.getId());
        this.bodyToJsonUtf8(generator);
        generator.writeEndObject();
        generator.flush();
    }

    protected void bodyToJsonUtf8(JsonGenerator generator) throws IOException {
        generator.writeObjectField("dataset", this.datasetLevel);
        generator.writeObjectFieldStart("file");
        for (Map.Entry<String, Map<String, Object>> entry : this.fileLevel.entrySet()) {
            generator.writeObjectField(entry.getKey(), entry.getValue());
        }
        generator.writeEndObject();
    }

    public String getDatasetUrn() {
        return (String)this.datasetLevel.get(DATASET_URN_KEY);
    }

    public void setDatasetUrn(String urn) {
        this.setDatasetMetadata(DATASET_URN_KEY, urn);
    }

    public void setContentType(String contentType) {
        this.setDatasetMetadata(CONTENT_TYPE_KEY, contentType);
    }

    public String getContentType() {
        return (String)this.getDatasetMetadata(CONTENT_TYPE_KEY);
    }

    public void setInnerContentType(String innerContentType) {
        this.setDatasetMetadata(INNER_CONTENT_TYPE_KEY, innerContentType);
    }

    public String getInnerContentType() {
        return (String)this.getDatasetMetadata(INNER_CONTENT_TYPE_KEY);
    }

    public void setNumOutputFiles(int numFiles) {
        this.setDatasetMetadata(NUM_FILES_KEY, numFiles);
    }

    public void setNumRecords(long numRecords) {
        this.setDatasetMetadata(NUM_RECORDS_KEY, numRecords);
    }

    public Object getDatasetMetadata(String key) {
        return this.datasetLevel.get(key);
    }

    public void setDatasetMetadata(String key, Object val) {
        this.throwIfImmutable();
        this.datasetLevel.put(key, val);
        this.cachedId = null;
    }

    public List<String> getTransferEncoding() {
        return (List)this.getDatasetMetadata(TRANSFER_ENCODING_KEY);
    }

    public synchronized void addTransferEncoding(String encoding) {
        this.throwIfImmutable();
        List<String> encodings = this.getTransferEncoding();
        if (encodings == null) {
            encodings = new ArrayList<String>();
        }
        encodings.add(encoding);
        this.setDatasetMetadata(TRANSFER_ENCODING_KEY, encodings);
    }

    public long getNumRecords() {
        Number numRecords = (Number)this.getDatasetMetadata(NUM_RECORDS_KEY);
        return numRecords != null ? numRecords.longValue() : 0L;
    }

    public int getNumFiles() {
        Integer numFiles = (Integer)this.getDatasetMetadata(NUM_FILES_KEY);
        return numFiles != null ? numFiles : 0;
    }

    public Object getFileMetadata(String file, String key) {
        Map<String, Object> fileKeys = this.fileLevel.get(file);
        if (fileKeys == null) {
            return null;
        }
        return fileKeys.get(key);
    }

    public void setFileMetadata(String file, String key, Object val) {
        this.throwIfImmutable();
        Map<String, Object> fileKeys = this.fileLevel.get(file);
        if (fileKeys == null) {
            fileKeys = new ConcurrentHashMap<String, Object>();
            this.fileLevel.put(file, fileKeys);
        }
        fileKeys.put(key, val);
        this.cachedId = null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GlobalMetadata that = (GlobalMetadata)o;
        return this.getId().equals(that.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String getId() {
        if (this.cachedId != null) {
            return this.cachedId;
        }
        if (this.datasetLevel.size() == 0 && this.fileLevel.size() == 0) {
            this.cachedId = EMPTY_ID;
            return this.cachedId;
        }
        try {
            ByteArrayOutputStream bOs = new ByteArrayOutputStream(512);
            MessageDigest md5Digest = MessageDigest.getInstance("MD5");
            try (JsonGenerator generator = jsonFactory.createJsonGenerator((OutputStream)bOs, JsonEncoding.UTF8).setCodec((ObjectCodec)objectMapper);){
                generator.writeStartObject();
                this.bodyToJsonUtf8(generator);
                generator.writeEndObject();
            }
            byte[] digestBytes = md5Digest.digest(bOs.toByteArray());
            this.cachedId = DatatypeConverter.printHexBinary((byte[])digestBytes);
            return this.cachedId;
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new RuntimeException("Unexpected exception generating id", e);
        }
    }

    public boolean isEmpty() {
        return this.getId().equals(EMPTY_ID);
    }

    private void throwIfImmutable() {
        if (this.markedImmutable) {
            throw new UnsupportedOperationException("Metadata is marked as immutable -- cannot modify");
        }
    }
}

