/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metadata.provider;

import com.typesafe.config.Config;
import java.io.IOException;
import org.apache.gobblin.broker.iface.ConfigView;
import org.apache.gobblin.broker.iface.ScopeType;
import org.apache.gobblin.broker.iface.SharedResourcesBroker;
import org.apache.gobblin.metadata.provider.DatasetAwareFsMetadataProvider;
import org.apache.gobblin.metadata.provider.DatasetAwareMetadataProviderFactory;
import org.apache.gobblin.metadata.provider.PermissionMetadataParser;
import org.apache.gobblin.util.ClassAliasResolver;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.gobblin.util.filesystem.FileSystemInstrumentation;
import org.apache.gobblin.util.filesystem.FileSystemInstrumentationFactory;
import org.apache.gobblin.util.filesystem.FileSystemKey;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataAwareFileSystem
extends FileSystemInstrumentation {
    private static final Logger log = LoggerFactory.getLogger(MetadataAwareFileSystem.class);
    public static final String METADATA_PROVIDER_ALIAS = "metadataProviderAlias";
    private DatasetAwareFsMetadataProvider metadataProvider;

    public MetadataAwareFileSystem(FileSystem underlying, DatasetAwareFsMetadataProvider provider) {
        super(underlying);
        this.metadataProvider = provider;
    }

    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        FsPermission realPermission = this.getPermAtPathFromMetadataIfPresent(permission, f);
        return super.mkdirs(f, realPermission);
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        FsPermission realPermission = this.getPermAtPathFromMetadataIfPresent(permission, f);
        return super.create(f, realPermission, overwrite, bufferSize, replication, blockSize, progress);
    }

    public void setPermission(Path f, FsPermission permission) throws IOException {
        super.setPermission(f, this.getPermAtPathFromMetadataIfPresent(permission, f));
    }

    public void setOwner(Path f, String user, String group) throws IOException {
        super.setOwner(f, user, this.getGroupAtPathFromMetadataIfPresent(group, f));
    }

    private String getGroupAtPathFromMetadataIfPresent(String defaultGroup, Path path) {
        String realGroup = defaultGroup;
        if (this.metadataProvider != null) {
            realGroup = PermissionMetadataParser.getGroupOwner(this.metadataProvider.getGlobalMetadataForDatasetAtPath(path));
        }
        return realGroup;
    }

    private FsPermission getPermAtPathFromMetadataIfPresent(FsPermission defaultPermission, Path path) {
        FsPermission realPermission = defaultPermission;
        if (this.metadataProvider != null) {
            realPermission = new FsPermission(Short.parseShort(PermissionMetadataParser.getPermission(this.metadataProvider.getGlobalMetadataForDatasetAtPath(path)), 8));
        }
        return realPermission;
    }

    public static class Factory<S extends ScopeType<S>>
    extends FileSystemInstrumentationFactory<S> {
        public FileSystem instrumentFileSystem(FileSystem fs, SharedResourcesBroker<S> broker, ConfigView<S, FileSystemKey> config) {
            Config metaConfig = config.getConfig();
            String metadataProviderAlias = ConfigUtils.getString((Config)metaConfig, (String)MetadataAwareFileSystem.METADATA_PROVIDER_ALIAS, (String)"");
            log.info("Metadata provider alias is: " + metadataProviderAlias);
            if (!metadataProviderAlias.isEmpty()) {
                DatasetAwareFsMetadataProvider metadataProvider = null;
                try {
                    metadataProvider = (DatasetAwareFsMetadataProvider)((DatasetAwareMetadataProviderFactory)new ClassAliasResolver(DatasetAwareMetadataProviderFactory.class).resolveClass(metadataProviderAlias).newInstance()).createMetadataProvider(metaConfig);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    log.error("Failed to create metadataProvider.", (Throwable)e);
                }
                if (metadataProvider != null) {
                    return new MetadataAwareFileSystem(fs, metadataProvider);
                }
            }
            log.warn("No valid {} found. Will use filesystem {}.", (Object)MetadataAwareFileSystem.METADATA_PROVIDER_ALIAS, (Object)fs.getClass().getName());
            return fs;
        }
    }
}

