/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.converter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.Converter;
import org.apache.gobblin.converter.DataConversionException;
import org.apache.gobblin.converter.SchemaConversionException;
import org.apache.gobblin.metadata.types.GlobalMetadata;
import org.apache.gobblin.type.ContentTypeUtils;
import org.apache.gobblin.type.RecordWithMetadata;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.ObjectCodec;
import org.codehaus.jackson.map.ObjectMapper;

public class RecordWithMetadataToEnvelopedRecordWithMetadata
extends Converter<Object, String, RecordWithMetadata<?>, RecordWithMetadata<byte[]>> {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final JsonFactory jsonFactory = new JsonFactory();
    private static final String CONTENT_TYPE = "lnkd+recordWithMetadata";

    public String convertSchema(Object inputSchema, WorkUnitState workUnit) throws SchemaConversionException {
        return "";
    }

    public Iterable<RecordWithMetadata<byte[]>> convertRecord(String outputSchema, RecordWithMetadata<?> inputRecord, WorkUnitState workUnit) throws DataConversionException {
        try {
            this.updateRecordMetadata(inputRecord);
            ByteArrayOutputStream bOs = new ByteArrayOutputStream(512);
            try (JsonGenerator generator = jsonFactory.createJsonGenerator((OutputStream)bOs, JsonEncoding.UTF8).setCodec((ObjectCodec)objectMapper);){
                generator.writeStartObject();
                this.writeHeaders(inputRecord, generator);
                this.writeRecord(inputRecord, generator);
                generator.writeEndObject();
            }
            return Collections.singleton(new RecordWithMetadata<byte[]>(bOs.toByteArray(), inputRecord.getMetadata()));
        }
        catch (IOException e) {
            throw new DataConversionException((Throwable)e);
        }
    }

    private void writeRecord(RecordWithMetadata<?> inputRecord, JsonGenerator generator) throws IOException {
        if (this.shouldInterpretRecordAsUtf8ByteArray(inputRecord)) {
            generator.writeFieldName("r");
            byte[] bytes = (byte[])inputRecord.getRecord();
            generator.writeUTF8String(bytes, 0, bytes.length);
        } else {
            generator.writeObjectField("r", inputRecord.getRecord());
        }
    }

    private void writeHeaders(RecordWithMetadata<?> inputRecord, JsonGenerator generator) throws IOException {
        generator.writeStringField("mId", inputRecord.getMetadata().getGlobalMetadata().getId());
        if (!inputRecord.getMetadata().getRecordMetadata().isEmpty()) {
            generator.writeObjectField("rMd", inputRecord.getMetadata().getRecordMetadata());
        }
    }

    private void updateRecordMetadata(RecordWithMetadata<?> inputRecord) {
        GlobalMetadata md = inputRecord.getMetadata().getGlobalMetadata();
        String origContentType = md.getContentType();
        if (origContentType != null) {
            md.setInnerContentType(origContentType);
        }
        md.setContentType(CONTENT_TYPE);
        md.markImmutable();
    }

    private boolean shouldInterpretRecordAsUtf8ByteArray(RecordWithMetadata<?> inputRecord) {
        if (inputRecord.getRecord() instanceof byte[]) {
            return ContentTypeUtils.getInstance().inferPrintableFromMetadata(inputRecord.getMetadata());
        }
        return false;
    }
}

