/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.converter;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.converter.Converter;
import org.apache.gobblin.converter.DataConversionException;
import org.apache.gobblin.converter.SchemaConversionException;
import org.apache.gobblin.metadata.types.Metadata;
import org.apache.gobblin.type.RecordWithMetadata;

public class MetadataConverterWrapper<SI, SO, DI, DO>
extends Converter<SI, SO, Object, RecordWithMetadata<DO>> {
    private final Converter<SI, SO, DI, DO> innerConverter;

    public MetadataConverterWrapper(Converter<SI, SO, DI, DO> innerConverter) {
        this.innerConverter = innerConverter;
    }

    public Converter<SI, SO, Object, RecordWithMetadata<DO>> init(WorkUnitState workUnit) {
        super.init(workUnit);
        this.innerConverter.init(workUnit);
        return this;
    }

    public void close() throws IOException {
        this.innerConverter.close();
    }

    public SO convertSchema(SI inputSchema, WorkUnitState workUnit) throws SchemaConversionException {
        return (SO)this.innerConverter.convertSchema(inputSchema, workUnit);
    }

    public Iterable<RecordWithMetadata<DO>> convertRecord(SO outputSchema, Object inputRecord, WorkUnitState workUnit) throws DataConversionException {
        final Metadata metadata = this.getMetadataFromRecord(inputRecord);
        DI innerRecord = this.getRecordFromRecord(inputRecord);
        Iterable outputRecords = this.innerConverter.convertRecord(outputSchema, innerRecord, workUnit);
        return Iterables.transform((Iterable)outputRecords, (Function)new Function<DO, RecordWithMetadata<DO>>(){

            @Nullable
            public RecordWithMetadata<DO> apply(@Nullable DO input) {
                return new RecordWithMetadata(input, metadata);
            }
        });
    }

    private DI getRecordFromRecord(Object inputRecord) {
        if (inputRecord instanceof RecordWithMetadata) {
            Object uncastedRecord = ((RecordWithMetadata)inputRecord).getRecord();
            return (DI)uncastedRecord;
        }
        return (DI)inputRecord;
    }

    private Metadata getMetadataFromRecord(Object inputRecord) {
        if (inputRecord instanceof RecordWithMetadata) {
            return ((RecordWithMetadata)inputRecord).getMetadata();
        }
        return new Metadata();
    }

    public State getFinalState() {
        return this.innerConverter.getFinalState();
    }

    protected Metadata convertMetadata(Metadata metadata) {
        return metadata;
    }
}

