/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.service.validator;

import com.google.common.base.Splitter;
import com.linkedin.data.DataMap;
import com.linkedin.data.element.DataElement;
import com.linkedin.data.message.Message;
import com.linkedin.data.schema.validator.AbstractValidator;
import com.linkedin.data.schema.validator.ValidatorContext;
import java.net.URI;
import java.net.URISyntaxException;

public class TemplateUriValidator
extends AbstractValidator {
    private static final String FS_SCHEME = "FS";

    public TemplateUriValidator(DataMap config) {
        super(config);
    }

    public void validate(ValidatorContext ctx) {
        DataElement element = ctx.dataElement();
        Object value = element.getValue();
        String str = String.valueOf(value);
        boolean valid = true;
        try {
            Iterable uriStrings = Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)str);
            for (String uriString : uriStrings) {
                URI uri = new URI(uriString);
                if (uri.getScheme().equalsIgnoreCase(FS_SCHEME)) continue;
                throw new URISyntaxException(uriString, "Scheme is not FS");
            }
        }
        catch (URISyntaxException e) {
            valid = false;
        }
        if (!valid) {
            ctx.addResult(new Message(element.path(), "\"%1$s\" is not a well-formed comma-separated list of URIs", new Object[]{str}));
        }
    }
}

