/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.tunnel;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.concurrent.Callable;
import org.apache.gobblin.tunnel.HandlerState;
import org.apache.gobblin.tunnel.Tunnel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReadWriteHandler
implements Callable<HandlerState> {
    static final Logger LOG = LoggerFactory.getLogger(Tunnel.class);
    private final SocketChannel proxy;
    private final SocketChannel client;
    private final Selector selector;
    private final ByteBuffer buffer = ByteBuffer.allocate(1000000);
    private HandlerState state = HandlerState.READING;

    ReadWriteHandler(SocketChannel proxy, ByteBuffer mixedServerResponseBuffer, SocketChannel client, Selector selector) throws IOException {
        this.proxy = proxy;
        this.client = client;
        this.selector = selector;
        if (mixedServerResponseBuffer.limit() > mixedServerResponseBuffer.position()) {
            this.client.configureBlocking(true);
            OutputStream clientOut = this.client.socket().getOutputStream();
            clientOut.write(mixedServerResponseBuffer.array(), mixedServerResponseBuffer.position(), mixedServerResponseBuffer.limit() - mixedServerResponseBuffer.position());
            clientOut.flush();
        }
        this.proxy.configureBlocking(false);
        this.client.configureBlocking(false);
        this.client.register(this.selector, 1, this);
        this.proxy.register(this.selector, 1, this);
    }

    @Override
    public HandlerState call() throws Exception {
        try {
            switch (this.state) {
                case READING: {
                    this.read();
                    break;
                }
                case WRITING: {
                    this.write();
                    break;
                }
                default: {
                    throw new IllegalStateException("ReadWriteHandler should never be in state " + (Object)((Object)this.state));
                }
            }
        }
        catch (CancelledKeyException e) {
            LOG.warn("Encountered canceled key while " + (Object)((Object)this.state), (Throwable)e);
        }
        catch (IOException ioe) {
            this.closeChannels();
            throw new IOException(String.format("Could not read/write between %s and %s", this.proxy, this.client), ioe);
        }
        catch (Exception e) {
            LOG.error("Unexpected exception", (Throwable)e);
            try {
                this.closeChannels();
            }
            finally {
                throw e;
            }
        }
        return this.state;
    }

    private void write() throws IOException {
        SelectionKey proxyKey = this.proxy.keyFor(this.selector);
        SelectionKey clientKey = this.client.keyFor(this.selector);
        SocketChannel writeChannel = null;
        SocketChannel readChannel = null;
        SelectionKey writeKey = null;
        if (this.selector.selectedKeys().contains(proxyKey) && proxyKey.isValid() && proxyKey.isWritable()) {
            writeChannel = this.proxy;
            readChannel = this.client;
            writeKey = proxyKey;
        } else if (this.selector.selectedKeys().contains(clientKey) && clientKey.isValid() && clientKey.isWritable()) {
            writeChannel = this.client;
            readChannel = this.proxy;
            writeKey = clientKey;
        }
        if (writeKey != null) {
            int lastWrite;
            int totalWrite = 0;
            this.buffer.flip();
            int available = this.buffer.remaining();
            while ((lastWrite = writeChannel.write(this.buffer)) > 0) {
                totalWrite += lastWrite;
            }
            LOG.debug("{} bytes written to {}", (Object)totalWrite, (Object)(writeChannel == this.proxy ? "proxy" : "client"));
            if (totalWrite == available) {
                this.buffer.clear();
                if (readChannel.isOpen()) {
                    readChannel.register(this.selector, 1, this);
                    writeChannel.register(this.selector, 1, this);
                } else {
                    writeChannel.close();
                }
                this.state = HandlerState.READING;
            } else {
                this.buffer.compact();
            }
            if (lastWrite == -1) {
                this.closeChannels();
            }
        }
    }

    private void read() throws IOException {
        SelectionKey proxyKey = this.proxy.keyFor(this.selector);
        SelectionKey clientKey = this.client.keyFor(this.selector);
        SocketChannel readChannel = null;
        SocketChannel writeChannel = null;
        SelectionKey readKey = null;
        if (this.selector.selectedKeys().contains(proxyKey) && proxyKey.isReadable()) {
            readChannel = this.proxy;
            writeChannel = this.client;
            readKey = proxyKey;
        } else if (this.selector.selectedKeys().contains(clientKey) && clientKey.isReadable()) {
            readChannel = this.client;
            writeChannel = this.proxy;
            readKey = clientKey;
        }
        if (readKey != null) {
            int lastRead;
            int totalRead = 0;
            while ((lastRead = readChannel.read(this.buffer)) > 0) {
                totalRead += lastRead;
            }
            LOG.debug("{} bytes read from {}", (Object)totalRead, (Object)(readChannel == this.proxy ? "proxy" : "client"));
            if (totalRead > 0) {
                readKey.cancel();
                writeChannel.register(this.selector, 4, this);
                this.state = HandlerState.WRITING;
            }
            if (lastRead == -1) {
                readChannel.close();
            }
        }
    }

    private void closeChannels() {
        if (this.proxy.isOpen()) {
            try {
                this.proxy.close();
            }
            catch (IOException log) {
                LOG.warn("Failed to close proxy channel {}", (Object)this.proxy, (Object)log);
            }
        }
        if (this.client.isOpen()) {
            try {
                this.client.close();
            }
            catch (IOException log) {
                LOG.warn("Failed to close client channel {}", (Object)this.client, (Object)log);
            }
        }
    }
}

