/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.tunnel;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.gobblin.configuration.ConfigurationKeys;
import org.apache.gobblin.tunnel.Config;
import org.apache.gobblin.tunnel.HandlerState;
import org.apache.gobblin.tunnel.ReadWriteHandler;
import org.apache.gobblin.tunnel.Tunnel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProxySetupHandler
implements Callable<HandlerState> {
    private static final Logger LOG = LoggerFactory.getLogger(Tunnel.class);
    public static final String HTTP_1_1_OK = "HTTP/1.1 200";
    private static final ByteBuffer OK_REPLY = ByteBuffer.wrap("HTTP/1.1 200".getBytes(ConfigurationKeys.DEFAULT_CHARSET_ENCODING));
    public static final String HTTP_1_0_OK = "HTTP/1.0 200";
    private static final Set<ByteBuffer> OK_REPLIES = new HashSet<ByteBuffer>(Arrays.asList(OK_REPLY, ByteBuffer.wrap("HTTP/1.0 200".getBytes(ConfigurationKeys.DEFAULT_CHARSET_ENCODING))));
    private final SocketChannel client;
    private final Selector selector;
    private final SocketChannel proxy;
    private HandlerState state = HandlerState.CONNECTING;
    private ByteBuffer buffer;
    private final long connectStartTime;
    private int totalBytesRead = 0;
    private final Config config;

    ProxySetupHandler(SocketChannel client, Selector selector, Config config) throws IOException {
        this.config = config;
        this.client = client;
        this.selector = selector;
        this.buffer = ByteBuffer.wrap(String.format("CONNECT %s:%d HTTP/1.1\r%nUser-Agent: GobblinTunnel\r%nservice-name: gobblin\r%nConnection: keep-alive\r%nHost: %s:%d\r%n\r%n", config.getRemoteHost(), config.getRemotePort(), config.getRemoteHost(), config.getRemotePort()).getBytes(ConfigurationKeys.DEFAULT_CHARSET_ENCODING));
        this.proxy = SocketChannel.open();
        this.proxy.configureBlocking(false);
        this.connectStartTime = System.currentTimeMillis();
        boolean connected = this.proxy.connect(new InetSocketAddress(this.config.getProxyHost(), this.config.getProxyPort()));
        if (!connected) {
            this.client.configureBlocking(false);
            this.client.register(this.selector, 1, this);
            this.proxy.register(this.selector, 8, this);
        } else {
            this.state = HandlerState.WRITING;
            this.proxy.register(this.selector, 4, this);
        }
    }

    @Override
    public HandlerState call() throws Exception {
        try {
            switch (this.state) {
                case CONNECTING: {
                    this.connect();
                    break;
                }
                case WRITING: {
                    this.write();
                    break;
                }
                case READING: {
                    this.read();
                    break;
                }
                default: {
                    throw new IllegalStateException("ProxySetupHandler should not be in state " + (Object)((Object)this.state));
                }
            }
        }
        catch (IOException ioe) {
            LOG.warn("Failed to establish a proxy connection for {}", (Object)this.client.getRemoteAddress(), (Object)ioe);
            this.closeChannels();
        }
        return this.state;
    }

    private void connect() throws IOException {
        if (this.proxy.isOpen()) {
            if (this.proxy.finishConnect()) {
                this.proxy.register(this.selector, 4, this);
                SelectionKey clientKey = this.client.keyFor(this.selector);
                if (clientKey != null) {
                    clientKey.cancel();
                }
                this.state = HandlerState.WRITING;
            } else if (this.connectStartTime + 5000L < System.currentTimeMillis()) {
                LOG.warn("Proxy connect timed out for client {}", (Object)this.client);
                this.closeChannels();
            }
        }
    }

    private void write() throws IOException {
        while (this.proxy.write(this.buffer) > 0) {
        }
        if (this.buffer.remaining() == 0) {
            this.proxy.register(this.selector, 1, this);
            this.state = HandlerState.READING;
            this.buffer = ByteBuffer.allocate(1024);
        }
    }

    private void read() throws IOException {
        int lastBytes = 0;
        while ((lastBytes = this.proxy.read(this.buffer)) > 0) {
            this.totalBytesRead += lastBytes;
        }
        if (this.totalBytesRead >= OK_REPLY.limit()) {
            byte[] temp = this.buffer.array();
            this.buffer.flip();
            if (OK_REPLIES.contains(ByteBuffer.wrap(temp, 0, OK_REPLY.limit()))) {
                for (int i = OK_REPLY.limit(); i <= this.buffer.limit() - 4; ++i) {
                    if (!(temp[i] == 10 && temp[i + 1] == 10 || temp[i + 1] == 10 && temp[i + 2] == 10 || temp[i + 2] == 10 && temp[i + 3] == 10) && (temp[i] != 13 || temp[i + 1] != 10 || temp[i + 2] != 13 || temp[i + 3] != 10)) continue;
                    this.state = null;
                    this.buffer.position(i + 4);
                    new ReadWriteHandler(this.proxy, this.buffer, this.client, this.selector);
                    return;
                }
            } else {
                LOG.error("Got non-200 response from proxy: [" + new String(temp, 0, OK_REPLY.limit(), ConfigurationKeys.DEFAULT_CHARSET_ENCODING) + "], closing connection.");
                this.closeChannels();
            }
        }
    }

    private void closeChannels() {
        if (this.proxy.isOpen()) {
            try {
                this.proxy.close();
            }
            catch (IOException log) {
                LOG.warn("Failed to close proxy channel {}", (Object)this.proxy, (Object)log);
            }
        }
        if (this.client.isOpen()) {
            try {
                this.client.close();
            }
            catch (IOException log) {
                LOG.warn("Failed to close client channel {}", (Object)this.client, (Object)log);
            }
        }
    }
}

