/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.util;

import java.beans.ConstructorProperties;
import java.util.Iterator;
import org.apache.gobblin.source.workunit.MultiWorkUnit;
import org.apache.gobblin.source.workunit.WorkUnit;

public class MultiWorkUnitUnpackingIterator
implements Iterator<WorkUnit> {
    private final Iterator<WorkUnit> workUnits;
    private Iterator<WorkUnit> currentIterator;
    private WorkUnit nextWu;
    private boolean needSeek = true;

    @Override
    public boolean hasNext() {
        this.seekNext();
        return this.nextWu != null;
    }

    @Override
    public WorkUnit next() {
        this.seekNext();
        WorkUnit wu = this.nextWu;
        if (this.nextWu instanceof MultiWorkUnit) {
            wu = this.currentIterator.next();
        }
        this.needSeek = true;
        return wu;
    }

    private void seekNext() {
        if (!this.needSeek) {
            return;
        }
        if (this.currentIterator != null && this.currentIterator.hasNext()) {
            this.needSeek = false;
            return;
        }
        this.nextWu = null;
        this.currentIterator = null;
        while (this.nextWu == null && this.workUnits.hasNext()) {
            this.nextWu = this.workUnits.next();
            if (!(this.nextWu instanceof MultiWorkUnit)) continue;
            this.currentIterator = ((MultiWorkUnit)this.nextWu).getWorkUnits().iterator();
            if (this.currentIterator.hasNext()) continue;
            this.nextWu = null;
        }
        this.needSeek = false;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @ConstructorProperties(value={"workUnits"})
    public MultiWorkUnitUnpackingIterator(Iterator<WorkUnit> workUnits) {
        this.workUnits = workUnits;
    }
}

