/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.local;

import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.util.Properties;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.gobblin.runtime.JobException;
import org.apache.gobblin.runtime.JobLauncher;
import org.apache.gobblin.runtime.app.ApplicationException;
import org.apache.gobblin.runtime.app.ApplicationLauncher;
import org.apache.gobblin.runtime.app.ServiceBasedAppLauncher;
import org.apache.gobblin.runtime.cli.CliOptions;
import org.apache.gobblin.runtime.listeners.JobListener;
import org.apache.gobblin.runtime.local.LocalJobLauncher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CliLocalJobLauncher
implements ApplicationLauncher,
JobLauncher {
    private static final Logger LOG = LoggerFactory.getLogger(CliLocalJobLauncher.class);
    private final Closer closer = Closer.create();
    private final ApplicationLauncher applicationLauncher;
    private final LocalJobLauncher localJobLauncher;

    private CliLocalJobLauncher(Properties properties) throws Exception {
        this.applicationLauncher = (ApplicationLauncher)this.closer.register((Closeable)new ServiceBasedAppLauncher(properties, properties.getProperty("app.name", "CliLocalJob-" + UUID.randomUUID())));
        this.localJobLauncher = (LocalJobLauncher)this.closer.register((Closeable)new LocalJobLauncher(properties));
    }

    public void run() throws ApplicationException, JobException, IOException {
        try {
            this.start();
            this.launchJob(null);
        }
        finally {
            try {
                this.stop();
            }
            finally {
                this.close();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        Properties jobProperties = CliOptions.parseArgs(CliLocalJobLauncher.class, args);
        LOG.debug(String.format("Running job with properties:%n%s", jobProperties));
        new CliLocalJobLauncher(jobProperties).run();
    }

    @Override
    public void start() throws ApplicationException {
        this.applicationLauncher.start();
    }

    @Override
    public void stop() throws ApplicationException {
        this.applicationLauncher.stop();
    }

    @Override
    public void launchJob(@Nullable JobListener jobListener) throws JobException {
        this.localJobLauncher.launchJob(jobListener);
    }

    @Override
    public void cancelJob(@Nullable JobListener jobListener) throws JobException {
        this.localJobLauncher.cancelJob(jobListener);
    }

    @Override
    public void close() throws IOException {
        this.closer.close();
    }
}

