/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime.job_catalog;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.runtime.api.GobblinInstanceEnvironment;
import org.apache.gobblin.runtime.api.JobCatalogListener;
import org.apache.gobblin.runtime.api.JobSpec;
import org.apache.gobblin.runtime.api.JobSpecNotFoundException;
import org.apache.gobblin.runtime.job_catalog.JobCatalogBase;
import org.slf4j.Logger;

public class StaticJobCatalog
extends JobCatalogBase {
    private final Map<URI, JobSpec> jobs;

    public StaticJobCatalog(Collection<JobSpec> jobSpecs) {
        this.jobs = this.parseJobs(jobSpecs);
    }

    public StaticJobCatalog(Optional<Logger> log, Collection<JobSpec> jobSpecs) {
        super(log);
        this.jobs = this.parseJobs(jobSpecs);
    }

    public StaticJobCatalog(GobblinInstanceEnvironment env, Collection<JobSpec> jobSpecs) {
        super(env);
        this.jobs = this.parseJobs(jobSpecs);
    }

    public StaticJobCatalog(Optional<Logger> log, Optional<MetricContext> parentMetricContext, boolean instrumentationEnabled, Collection<JobSpec> jobSpecs) {
        super(log, parentMetricContext, instrumentationEnabled);
        this.jobs = this.parseJobs(jobSpecs);
    }

    private Map<URI, JobSpec> parseJobs(Collection<JobSpec> jobSpecs) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (JobSpec jobSpec : jobSpecs) {
            mapBuilder.put((Object)jobSpec.getUri(), (Object)jobSpec);
        }
        return mapBuilder.build();
    }

    @Override
    @SuppressWarnings(value={"UR_UNINIT_READ_CALLED_FROM_SUPER_CONSTRUCTOR"}, justification="Uninitialized variable has been checked.")
    public void addListener(JobCatalogListener jobListener) {
        if (this.jobs == null) {
            return;
        }
        for (Map.Entry<URI, JobSpec> entry : this.jobs.entrySet()) {
            jobListener.onAddJob(entry.getValue());
        }
    }

    @Override
    public Collection<JobSpec> getJobs() {
        return this.jobs.values();
    }

    @Override
    public void removeListener(JobCatalogListener jobListener) {
    }

    @Override
    public JobSpec getJobSpec(URI uri) throws JobSpecNotFoundException {
        return this.jobs.get(uri);
    }
}

