/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.runtime;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Phaser;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class CountUpAndDownLatch
extends CountDownLatch {
    private final Phaser phaser;

    public CountUpAndDownLatch(int count) {
        super(0);
        this.phaser = new Phaser(count);
    }

    @Override
    public void await() throws InterruptedException {
        this.phaser.awaitAdvance(0);
    }

    @Override
    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        try {
            this.phaser.awaitAdvanceInterruptibly(0, timeout, unit);
            return true;
        }
        catch (TimeoutException te) {
            return false;
        }
    }

    @Override
    public void countDown() {
        this.phaser.arrive();
    }

    public void countUp() {
        this.phaser.register();
    }

    @Override
    public long getCount() {
        return this.phaser.getUnarrivedParties();
    }

    public long getRegisteredParties() {
        return this.phaser.getRegisteredParties();
    }

    @Override
    public String toString() {
        return "Unarrived parties: " + this.phaser.getUnarrivedParties();
    }
}

