/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.extractor.extract.google;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.repackaged.com.google.common.base.Preconditions;
import com.google.api.services.drive.Drive;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.gobblin.configuration.SourceState;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.source.extractor.Extractor;
import org.apache.gobblin.source.extractor.extract.google.GoogleCommon;
import org.apache.gobblin.source.extractor.extract.google.GoogleDriveExtractor;
import org.apache.gobblin.source.extractor.extract.google.GoogleDriveFsHelper;
import org.apache.gobblin.source.extractor.filebased.FileBasedHelper;
import org.apache.gobblin.source.extractor.filebased.FileBasedHelperException;
import org.apache.gobblin.source.extractor.filebased.FileBasedSource;
import org.apache.gobblin.source.extractor.filebased.TimestampAwareFileBasedHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleDriveSource<S, D>
extends FileBasedSource<S, D> {
    private static final Logger LOG = LoggerFactory.getLogger(GoogleDriveSource.class);
    public static final String GOOGLE_DRIVE_PREFIX = "source.google.drive.";
    public static final String BUFFER_BYTE_SIZE = "buffer_byte_size";
    private final Closer closer = Closer.create();

    public Extractor<S, D> getExtractor(WorkUnitState state) throws IOException {
        Preconditions.checkNotNull((Object)state, (Object)"WorkUnitState should not be null");
        LOG.info("WorkUnitState from getExtractor: " + state);
        try {
            this.initFileSystemHelper((State)state);
        }
        catch (FileBasedHelperException e) {
            throw new IOException(e);
        }
        Preconditions.checkNotNull((Object)this.fsHelper, (Object)"File system helper should not be null");
        return new GoogleDriveExtractor(state, (FileBasedHelper)this.fsHelper);
    }

    public synchronized void initFileSystemHelper(State state) throws FileBasedHelperException {
        if (this.fsHelper == null) {
            Credential credential = new GoogleCommon.CredentialBuilder(state.getProp("source.conn.private.key"), state.getPropAsList("source.google.api_scopes")).fileSystemUri(state.getProp("source.google.privatekey_fs_uri")).proxyUrl(state.getProp("source.conn.use.proxy.url")).port(state.getProp("source.conn.use.proxy.port")).serviceAccountId(state.getProp("source.conn.username")).build();
            Drive driveClient = new Drive.Builder(credential.getTransport(), GoogleCommon.getJsonFactory(), (HttpRequestInitializer)credential).setApplicationName((String)Preconditions.checkNotNull((Object)state.getProp("source.google.application_name"), (Object)"ApplicationName is required")).build();
            this.fsHelper = (TimestampAwareFileBasedHelper)this.closer.register((Closeable)((Object)new GoogleDriveFsHelper(state, driveClient)));
        }
    }

    public List<String> getcurrentFsSnapshot(State state) {
        ArrayList<String> results = new ArrayList<String>();
        String folderId = state.getProp("source.filebased.data.directory", "");
        try {
            LOG.info("Running ls with folderId: " + folderId);
            List fileIds = this.fsHelper.ls(folderId);
            for (String fileId : fileIds) {
                results.add(fileId + this.splitPattern + this.fsHelper.getFileMTime(fileId));
            }
        }
        catch (FileBasedHelperException e) {
            throw new RuntimeException("Failed to retrieve list of file IDs for folderID: " + folderId, e);
        }
        return results;
    }

    public void shutdown(SourceState state) {
        try {
            this.closer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

