/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.extractor.extract.google;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.gson.GsonFactory;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermissions;
import java.security.GeneralSecurityException;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleCommon {
    private static final Logger LOG = LoggerFactory.getLogger(GoogleCommon.class);
    private static final JsonFactory JSON_FACTORY = GsonFactory.getDefaultInstance();
    private static final String JSON_FILE_EXTENSION = ".json";
    private static final FsPermission USER_READ_PERMISSION_ONLY = new FsPermission(FsAction.READ, FsAction.NONE, FsAction.NONE);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Credential buildCredentialFromP12(String privateKeyPath, Optional<String> fsUri, Optional<String> id, HttpTransport transport, Collection<String> serviceAccountScopes) throws IOException, GeneralSecurityException {
        Preconditions.checkArgument((boolean)id.isPresent(), (Object)"user id is required.");
        FileSystem fs = GoogleCommon.getFileSystem(fsUri);
        Path keyPath = GoogleCommon.getPrivateKey(fs, privateKeyPath);
        File localCopied = GoogleCommon.copyToLocal(fs, keyPath);
        localCopied.deleteOnExit();
        try {
            GoogleCredential googleCredential = new GoogleCredential.Builder().setTransport(transport).setJsonFactory(JSON_FACTORY).setServiceAccountId((String)id.get()).setServiceAccountPrivateKeyFromP12File(localCopied).setServiceAccountScopes(serviceAccountScopes).build();
            return googleCredential;
        }
        finally {
            boolean isDeleted = localCopied.delete();
            if (!isDeleted) {
                throw new RuntimeException(localCopied.getAbsolutePath() + " has not been deleted.");
            }
        }
    }

    private static Path getPrivateKey(FileSystem fs, String privateKeyPath) throws IOException {
        Path keyPath = new Path(privateKeyPath);
        FileStatus fileStatus = fs.getFileStatus(keyPath);
        Preconditions.checkArgument((boolean)USER_READ_PERMISSION_ONLY.equals((Object)fileStatus.getPermission()), (Object)("Private key file should only have read only permission only on user. " + keyPath));
        return keyPath;
    }

    private static FileSystem getFileSystem(Optional<String> fsUri) throws IOException {
        if (fsUri.isPresent()) {
            return FileSystem.get((URI)URI.create((String)fsUri.get()), (Configuration)new Configuration());
        }
        return FileSystem.get((Configuration)new Configuration());
    }

    private static Credential buildCredentialFromJson(String privateKeyPath, Optional<String> fsUri, HttpTransport transport, Collection<String> serviceAccountScopes) throws IOException {
        FileSystem fs = GoogleCommon.getFileSystem(fsUri);
        Path keyPath = GoogleCommon.getPrivateKey(fs, privateKeyPath);
        return GoogleCredential.fromStream((InputStream)fs.open(keyPath), (HttpTransport)transport, (JsonFactory)JSON_FACTORY).createScoped(serviceAccountScopes);
    }

    public static HttpTransport newTransport(String proxyUrl, String portStr) throws NumberFormatException, GeneralSecurityException, IOException {
        if (!StringUtils.isEmpty((CharSequence)proxyUrl) && !StringUtils.isEmpty((CharSequence)portStr)) {
            return new NetHttpTransport.Builder().trustCertificates(GoogleUtils.getCertificateTrustStore()).setProxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyUrl, Integer.parseInt(portStr)))).build();
        }
        return GoogleNetHttpTransport.newTrustedTransport();
    }

    private static File copyToLocal(FileSystem fs, Path keyPath) throws IOException {
        java.nio.file.Path tmpKeyPath = Files.createTempFile(GoogleCommon.class.getSimpleName(), "tmp", PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwx------")));
        File copied = tmpKeyPath.toFile();
        copied.deleteOnExit();
        fs.copyToLocalFile(keyPath, new Path(copied.getAbsolutePath()));
        return copied;
    }

    public static JsonFactory getJsonFactory() {
        return JSON_FACTORY;
    }

    public static class CredentialBuilder {
        private final String privateKeyPath;
        private final Collection<String> serviceAccountScopes;
        private String fileSystemUri;
        private String serviceAccountId;
        private String proxyUrl;
        private String portStr;

        public CredentialBuilder(String privateKeyPath, Collection<String> serviceAccountScopes) {
            Preconditions.checkArgument((!StringUtils.isEmpty((CharSequence)privateKeyPath) ? 1 : 0) != 0, (Object)"privateKeyPath is required.");
            Preconditions.checkArgument((serviceAccountScopes != null && !serviceAccountScopes.isEmpty() ? 1 : 0) != 0, (Object)"serviceAccountScopes is required.");
            this.privateKeyPath = privateKeyPath;
            this.serviceAccountScopes = ImmutableList.copyOf(serviceAccountScopes);
        }

        public CredentialBuilder fileSystemUri(String fileSystemUri) {
            this.fileSystemUri = fileSystemUri;
            return this;
        }

        public CredentialBuilder serviceAccountId(String serviceAccountId) {
            this.serviceAccountId = serviceAccountId;
            return this;
        }

        public CredentialBuilder proxyUrl(String proxyUrl) {
            this.proxyUrl = proxyUrl;
            return this;
        }

        public CredentialBuilder port(int port) {
            this.portStr = Integer.toString(port);
            return this;
        }

        public CredentialBuilder port(String portStr) {
            this.portStr = portStr;
            return this;
        }

        public Credential build() {
            try {
                HttpTransport transport = GoogleCommon.newTransport(this.proxyUrl, this.portStr);
                if (this.privateKeyPath.trim().toLowerCase().endsWith(GoogleCommon.JSON_FILE_EXTENSION)) {
                    LOG.info("Getting Google service account credential from JSON");
                    return GoogleCommon.buildCredentialFromJson(this.privateKeyPath, (Optional<String>)Optional.fromNullable((Object)this.fileSystemUri), transport, this.serviceAccountScopes);
                }
                LOG.info("Getting Google service account credential from P12");
                return GoogleCommon.buildCredentialFromP12(this.privateKeyPath, (Optional<String>)Optional.fromNullable((Object)this.fileSystemUri), (Optional<String>)Optional.fromNullable((Object)this.serviceAccountId), transport, this.serviceAccountScopes);
            }
            catch (IOException | GeneralSecurityException e) {
                throw new RuntimeException("Failed to create credential", e);
            }
        }
    }
}

