/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.ingestion.google.webmaster;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.gobblin.ingestion.google.webmaster.GoogleWebmasterFilter;
import org.apache.gobblin.ingestion.google.webmaster.UrlGrouper;
import org.apache.gobblin.ingestion.google.webmaster.UrlTrie;
import org.apache.gobblin.ingestion.google.webmaster.UrlTrieNode;
import org.apache.gobblin.ingestion.google.webmaster.UrlTriePostOrderIterator;

public class UrlTriePrefixGrouper
implements UrlGrouper {
    private final int _groupSize;
    private final UrlTrie _trie;
    private final Iterator<Pair<String, UrlTrieNode>> _iterator;
    private Triple<String, GoogleWebmasterFilter.FilterOperator, UrlTrieNode> _retVal;

    public UrlTriePrefixGrouper(UrlTrie trie, int groupSize) {
        this._trie = trie;
        this._groupSize = groupSize;
        this._iterator = new UrlTriePostOrderIterator(trie, groupSize);
    }

    @Override
    public boolean hasNext() {
        if (this._retVal != null) {
            return true;
        }
        while (this._iterator.hasNext() && this._retVal == null) {
            Pair<String, UrlTrieNode> nextPair = this._iterator.next();
            UrlTrieNode nextNode = (UrlTrieNode)nextPair.getRight();
            if (nextNode.getSize() <= this._groupSize) {
                this._retVal = Triple.of((Object)nextPair.getLeft(), (Object)((Object)GoogleWebmasterFilter.FilterOperator.CONTAINS), (Object)nextNode);
                return true;
            }
            if (!nextNode.isExist()) continue;
            this._retVal = Triple.of((Object)nextPair.getLeft(), (Object)((Object)GoogleWebmasterFilter.FilterOperator.EQUALS), (Object)nextNode);
            return true;
        }
        return false;
    }

    @Override
    public Triple<String, GoogleWebmasterFilter.FilterOperator, UrlTrieNode> next() {
        if (this.hasNext()) {
            Triple<String, GoogleWebmasterFilter.FilterOperator, UrlTrieNode> retVal = this._retVal;
            this._retVal = null;
            return retVal;
        }
        throw new NoSuchElementException();
    }

    public UrlTrie getTrie() {
        return this._trie;
    }

    public static ArrayList<String> groupToPages(Triple<String, GoogleWebmasterFilter.FilterOperator, UrlTrieNode> group) {
        ArrayList<String> ret = new ArrayList<String>();
        if (((GoogleWebmasterFilter.FilterOperator)((Object)group.getMiddle())).equals((Object)GoogleWebmasterFilter.FilterOperator.EQUALS)) {
            if (((UrlTrieNode)group.getRight()).isExist()) {
                ret.add((String)group.getLeft());
            }
        } else if (((GoogleWebmasterFilter.FilterOperator)((Object)group.getMiddle())).equals((Object)GoogleWebmasterFilter.FilterOperator.CONTAINS)) {
            UrlTrie trie = new UrlTrie((String)group.getLeft(), (UrlTrieNode)group.getRight());
            UrlTriePostOrderIterator iterator = new UrlTriePostOrderIterator(trie, 1);
            while (iterator.hasNext()) {
                Pair next = (Pair)iterator.next();
                if (!((UrlTrieNode)next.getRight()).isExist()) continue;
                ret.add((String)next.getLeft());
            }
        }
        return ret;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getGroupSize() {
        return this._groupSize;
    }
}

