/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.ingestion.google.webmaster;

import avro.shaded.com.google.common.collect.Iterables;
import com.google.api.services.webmasters.model.ApiDimensionFilter;
import com.google.common.base.Splitter;
import com.google.gson.JsonArray;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.gobblin.annotation.Alpha;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.ingestion.google.webmaster.GoogleWebmasterClient;
import org.apache.gobblin.ingestion.google.webmaster.GoogleWebmasterDataFetcher;
import org.apache.gobblin.ingestion.google.webmaster.GoogleWebmasterDataFetcherImpl;
import org.apache.gobblin.ingestion.google.webmaster.GoogleWebmasterExtractorIterator;
import org.apache.gobblin.ingestion.google.webmaster.GoogleWebmasterFilter;
import org.apache.gobblin.source.extractor.DataRecordException;
import org.apache.gobblin.source.extractor.Extractor;
import org.apache.gobblin.source.extractor.Watermark;
import org.apache.gobblin.source.extractor.extract.LongWatermark;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alpha
public class GoogleWebmasterExtractor
implements Extractor<String, String[]> {
    private static final Logger log = LoggerFactory.getLogger(GoogleWebmasterExtractor.class);
    private static final Splitter splitter = Splitter.on((String)",").omitEmptyStrings().trimResults();
    private final JsonArray _schema;
    private final WorkUnitState _wuState;
    private final DateTimeFormatter dateFormatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    private final boolean _includeSource;
    private int _current = 0;
    private List<GoogleWebmasterExtractorIterator> _iterators = new ArrayList<GoogleWebmasterExtractorIterator>();
    private List<int[]> _positionMaps = new ArrayList<int[]>();
    private final DateTime _startDate;
    private final long _expectedHighWaterMark;
    private final DateTime _expectedHighWaterMarkDate;

    public GoogleWebmasterExtractor(GoogleWebmasterClient gscClient, WorkUnitState wuState, long lowWatermark, long expectedHighWaterMark, Map<String, Integer> columnPositionMap, List<GoogleWebmasterFilter.Dimension> requestedDimensions, List<GoogleWebmasterDataFetcher.Metric> requestedMetrics, JsonArray schemaJson) throws IOException {
        this(wuState, lowWatermark, expectedHighWaterMark, columnPositionMap, requestedDimensions, requestedMetrics, schemaJson, GoogleWebmasterExtractor.createGoogleWebmasterDataFetchers(wuState.getProp("source.google_webmasters.property_urls"), gscClient, wuState));
    }

    private static List<GoogleWebmasterDataFetcher> createGoogleWebmasterDataFetchers(String properties, GoogleWebmasterClient gscClient, WorkUnitState wuState) throws IOException {
        ArrayList<GoogleWebmasterDataFetcher> fetchers = new ArrayList<GoogleWebmasterDataFetcher>();
        Iterable props = splitter.split((CharSequence)properties);
        for (String prop : props) {
            fetchers.add(new GoogleWebmasterDataFetcherImpl(prop, gscClient, (State)wuState));
        }
        return fetchers;
    }

    GoogleWebmasterExtractor(WorkUnitState wuState, long lowWatermark, long expectedHighWaterMark, Map<String, Integer> columnPositionMap, List<GoogleWebmasterFilter.Dimension> requestedDimensions, List<GoogleWebmasterDataFetcher.Metric> requestedMetrics, JsonArray schemaJson, List<GoogleWebmasterDataFetcher> dataFetchers) {
        DateTimeFormatter watermarkFormatter = DateTimeFormat.forPattern((String)"yyyyMMddHHmmss");
        this._startDate = watermarkFormatter.parseDateTime(Long.toString(lowWatermark));
        this._expectedHighWaterMark = expectedHighWaterMark;
        this._expectedHighWaterMarkDate = watermarkFormatter.parseDateTime(Long.toString(expectedHighWaterMark));
        log.info(String.format("Creating GoogleWebmasterExtractor for [%s, %s] for job %s.", this._startDate.toString(), this._expectedHighWaterMarkDate.toString(), wuState.getProp("source.entity")));
        this._wuState = wuState;
        this._schema = schemaJson;
        this._includeSource = wuState.getWorkunit().getPropAsBoolean("source.google_webmasters.source_property.include", false);
        Iterable<Map<GoogleWebmasterFilter.Dimension, ApiDimensionFilter>> filterGroups = this.getFilterGroups(wuState);
        for (GoogleWebmasterDataFetcher dataFetcher : dataFetchers) {
            for (Map<GoogleWebmasterFilter.Dimension, ApiDimensionFilter> filters : filterGroups) {
                ArrayList<GoogleWebmasterFilter.Dimension> actualDimensionRequests = new ArrayList<GoogleWebmasterFilter.Dimension>(requestedDimensions);
                for (Map.Entry<GoogleWebmasterFilter.Dimension, ApiDimensionFilter> filter : filters.entrySet()) {
                    if (filter.getValue() != null) continue;
                    actualDimensionRequests.remove((Object)filter.getKey());
                }
                String startDate = this.dateFormatter.print((ReadableInstant)this._startDate);
                String endDate = this.dateFormatter.print((ReadableInstant)this._expectedHighWaterMarkDate);
                GoogleWebmasterExtractorIterator iterator = new GoogleWebmasterExtractorIterator(dataFetcher, startDate, endDate, actualDimensionRequests, requestedMetrics, filters, wuState);
                log.info("Created " + iterator.toString());
                int[] positionMapping = new int[actualDimensionRequests.size() + requestedMetrics.size()];
                for (int i = 0; i < actualDimensionRequests.size(); ++i) {
                    positionMapping[i] = columnPositionMap.get(((GoogleWebmasterFilter.Dimension)((Object)actualDimensionRequests.get(i))).toString());
                }
                for (GoogleWebmasterDataFetcher.Metric requestedMetric : requestedMetrics) {
                    positionMapping[i++] = columnPositionMap.get(requestedMetric.toString());
                }
                this._iterators.add(iterator);
                this._positionMaps.add(positionMapping);
            }
        }
    }

    private Iterable<Map<GoogleWebmasterFilter.Dimension, ApiDimensionFilter>> getFilterGroups(WorkUnitState wuState) {
        ArrayList<Map<GoogleWebmasterFilter.Dimension, ApiDimensionFilter>> filters = new ArrayList<Map<GoogleWebmasterFilter.Dimension, ApiDimensionFilter>>();
        for (String filter : splitter.split((CharSequence)wuState.getProp("source.google_webmasters.request.filters"))) {
            String[] parts = (String[])Iterables.toArray((Iterable)Splitter.on((String)".").split((CharSequence)filter), String.class);
            String dimString = parts[0].toUpperCase();
            String valueString = parts[1].toUpperCase();
            GoogleWebmasterFilter.Dimension dimension = GoogleWebmasterFilter.Dimension.valueOf(dimString);
            HashMap<GoogleWebmasterFilter.Dimension, ApiDimensionFilter> map = new HashMap<GoogleWebmasterFilter.Dimension, ApiDimensionFilter>();
            if (dimension != GoogleWebmasterFilter.Dimension.COUNTRY) {
                throw new UnsupportedOperationException("Only country filter is supported for now");
            }
            map.put(GoogleWebmasterFilter.Dimension.COUNTRY, GoogleWebmasterFilter.countryEqFilter(valueString));
            filters.add(map);
        }
        return filters;
    }

    public String getSchema() throws IOException {
        return this._schema.toString();
    }

    public String[] readRecord(@Deprecated String[] reuse) throws DataRecordException, IOException {
        while (this._current < this._iterators.size()) {
            GoogleWebmasterExtractorIterator iterator = this._iterators.get(this._current);
            if (iterator.isFailed()) {
                log.info(String.format("Extractor failed at iterator %d: %s", this._current, iterator.toString()));
                for (int i = 0; i <= this._current; ++i) {
                    this._iterators.set(i, new GoogleWebmasterExtractorIterator(this._iterators.get(i)));
                }
                log.info(String.format("Resetting _current index from %d to 0 to restart from the beginning", this._current));
                this._current = 0;
                iterator = this._iterators.get(this._current);
            }
            int[] positionMap = this._positionMaps.get(this._current);
            if (iterator.hasNext()) {
                String[] apiResponse = (String[])iterator.next();
                int size = this._schema.size();
                String[] record = new String[size];
                for (int i = 0; i < positionMap.length; ++i) {
                    record[positionMap[i]] = apiResponse[i];
                }
                if (this._includeSource) {
                    record[size - 1] = iterator.getProperty();
                }
                return record;
            }
            log.info(iterator.toString() + " finished successfully. ^_^");
            ++this._current;
        }
        return null;
    }

    public long getExpectedRecordCount() {
        if (this._current == this._iterators.size()) {
            return 1L;
        }
        return 0L;
    }

    public long getHighWatermark() {
        throw new UnsupportedOperationException("This method has been deprecated!");
    }

    public void close() throws IOException {
        if (this._current == this._iterators.size()) {
            log.info(String.format("Successfully finished fetching data from Google Search Console from %s to %s.", this.dateFormatter.print((ReadableInstant)this._startDate), this.dateFormatter.print((ReadableInstant)this._expectedHighWaterMarkDate)));
            this._wuState.setActualHighWatermark((Watermark)new LongWatermark(this._expectedHighWaterMark));
        } else {
            log.error(String.format("Had problems fetching data from Google Search Console from %s to %s.", this.dateFormatter.print((ReadableInstant)this._startDate), this.dateFormatter.print((ReadableInstant)this._expectedHighWaterMarkDate)));
        }
    }

    List<GoogleWebmasterExtractorIterator> getIterators() {
        return this._iterators;
    }

    List<int[]> getPositionMaps() {
        return this._positionMaps;
    }
}

