/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.jmx;

import com.linkedin.d2.balancer.LoadBalancerState;
import com.linkedin.d2.balancer.clients.TrackerClient;
import com.linkedin.d2.balancer.simple.SimpleLoadBalancerState;
import com.linkedin.d2.jmx.SimpleLoadBalancerStateJmxMBean;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;

public class SimpleLoadBalancerStateJmx
implements SimpleLoadBalancerStateJmxMBean {
    private final SimpleLoadBalancerState _state;

    public SimpleLoadBalancerStateJmx(SimpleLoadBalancerState state) {
        this._state = state;
    }

    @Override
    public int getClusterCount() {
        return this._state.getClusterCount();
    }

    @Override
    public int getClusterListenCount() {
        return this._state.getClusterListenCount();
    }

    @Override
    public int getListenerCount() {
        return this._state.getListenerCount();
    }

    @Override
    public int getServiceCount() {
        return this._state.getServiceCount();
    }

    @Override
    public int getServiceListenCount() {
        return this._state.getServiceListenCount();
    }

    @Override
    public List<String> getSupportedSchemes() {
        return new ArrayList<String>(this._state.getSupportedSchemes());
    }

    @Override
    public List<String> getSupportedStrategies() {
        return new ArrayList<String>(this._state.getSupportedStrategies());
    }

    @Override
    public int getTrackerClientCount(String clusterName) {
        return this._state.getTrackerClientCount(clusterName);
    }

    @Override
    public int getUriCount() {
        return this._state.getUriCount();
    }

    @Override
    public void setVersion(long version) {
        this._state.setVersion(version);
    }

    @Override
    public String getUriProperty(String clusterName) {
        return this._state.getUriProperties(clusterName) + "";
    }

    @Override
    public String getServiceProperty(String serviceName) {
        return this._state.getServiceProperties(serviceName) + "";
    }

    @Override
    public String getClusterProperty(String clusterName) {
        return this._state.getClusterProperties(clusterName) + "";
    }

    @Override
    public long getVersion() {
        return this._state.getVersion();
    }

    @Override
    public boolean isListeningToCluster(String clusterName) {
        return this._state.isListeningToCluster(clusterName);
    }

    @Override
    public boolean isListeningToService(String serviceName) {
        return this._state.isListeningToService(serviceName);
    }

    @Override
    public void listenToCluster(String clusterName) {
        this._state.listenToCluster(clusterName, new LoadBalancerState.NullStateListenerCallback());
    }

    @Override
    public long getDelayedExecution() {
        return this._state.getDelayedExecution();
    }

    @Override
    public void setDelayedExecution(long milliseconds) {
        this._state.setDelayedExecution(milliseconds);
    }

    @Override
    public String getServerUrisForServiceName(String serviceName) {
        return this._state.getServerUrisForServiceName(serviceName).toString();
    }

    @Override
    public String getTrackerClientInformation(String trackerClientUri, String serviceName) throws URISyntaxException {
        URI uri = new URI(trackerClientUri);
        TrackerClient client = this._state.getClient(serviceName, uri);
        return client.toString();
    }

    @Override
    public String getInternalMappingServicesForClusterName(String clusterName) {
        return this._state.getServicesForCluster(clusterName).toString();
    }

    @Override
    public void listenToService(String serviceName) {
        this._state.listenToService(serviceName, new LoadBalancerState.NullStateListenerCallback());
    }
}

