/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.jmx;

import com.linkedin.d2.balancer.strategies.degrader.DegraderLoadBalancerStrategyV3;
import com.linkedin.d2.balancer.util.hashing.Ring;
import com.linkedin.d2.jmx.DegraderLoadBalancerStrategyV3JmxMBean;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;

public class DegraderLoadBalancerStrategyV3Jmx
implements DegraderLoadBalancerStrategyV3JmxMBean {
    private final DegraderLoadBalancerStrategyV3 _strategy;

    public DegraderLoadBalancerStrategyV3Jmx(DegraderLoadBalancerStrategyV3 strategy) {
        this._strategy = strategy;
    }

    @Override
    public double getOverrideClusterDropRate() {
        double rate = this._strategy.getState().getPartitionState(0).getCurrentOverrideDropRate();
        return rate;
    }

    @Override
    public String toString() {
        return "DegraderLoadBalancerStrategyV3Jmx [_strategy=" + this._strategy + "]";
    }

    @Override
    public int getTotalPointsInHashRing() {
        Map<URI, Integer> uris = this._strategy.getState().getPartitionState(0).getPointsMap();
        int total = 0;
        for (Map.Entry<URI, Integer> entry : uris.entrySet()) {
            total += entry.getValue().intValue();
        }
        return total;
    }

    @Override
    public String getPointsMap(int partitionId) {
        return this._strategy.getState().getPartitionState(partitionId).getPointsMap().toString();
    }

    @Override
    public String getUnhealthyClientsPoints(int partitionId) {
        int pointsPerWeight = this._strategy.getConfig().getPointsPerWeight();
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<URI, Integer> entry : this._strategy.getState().getPartitionState(partitionId).getPointsMap().entrySet()) {
            if (entry.getValue() >= pointsPerWeight) continue;
            result.add(entry.getKey().toString() + ":" + entry.getValue() + "/" + pointsPerWeight);
        }
        return ((Object)result).toString();
    }

    @Override
    public String getRingInformation(int partitionId) {
        Ring<URI> ring = this._strategy.getRing(partitionId);
        if (ring == null) {
            return "Ring for that partition is null";
        }
        return ring.toString();
    }

    @Override
    public long getCurrentClusterCallCount(int partitionId) {
        long currentClusterCallCount = this._strategy.getState().getPartitionState(partitionId).getCurrentClusterCallCount();
        return currentClusterCallCount;
    }

    @Override
    public double getCurrentAvgClusterLatency(int partitionId) {
        double currentAvgClusterLatency = this._strategy.getState().getPartitionState(partitionId).getCurrentAvgClusterLatency();
        return currentAvgClusterLatency;
    }
}

