/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.discovery.stores.zk;

import com.linkedin.common.callback.Callback;
import com.linkedin.d2.discovery.PropertySerializationException;
import com.linkedin.d2.discovery.PropertySerializer;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkUtil {
    private static final Logger LOG = LoggerFactory.getLogger(ZkUtil.class);

    private ZkUtil() {
    }

    public static <T> AsyncCallback.DataCallback zkDataCallback(final Callback<T> callback, final PropertySerializer<T> serializer) {
        return new AsyncCallback.DataCallback(){

            public void processResult(int rc, String path, Object context, byte[] bytes, Stat stat) {
                LOG.trace("Data callback got rc {} for path {}", (Object)rc, (Object)path);
                KeeperException.Code result = KeeperException.Code.get((int)rc);
                switch (result) {
                    case OK: {
                        try {
                            callback.onSuccess(serializer.fromBytes(bytes));
                        }
                        catch (PropertySerializationException e) {
                            callback.onError((Throwable)e);
                        }
                        break;
                    }
                    case NONODE: {
                        callback.onSuccess(null);
                        break;
                    }
                    default: {
                        callback.onError((Throwable)KeeperException.create((KeeperException.Code)result));
                    }
                }
            }
        };
    }
}

