/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.discovery.stores.zk;

import com.linkedin.d2.discovery.stores.zk.ZKConnection;
import com.linkedin.d2.discovery.stores.zk.ZooKeeper;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.zookeeper.Watcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKPersistentConnection {
    private static final Logger LOG = LoggerFactory.getLogger(ZKPersistentConnection.class);
    private final String _connectionString;
    private final int _sessionTimeout;
    private final boolean _shutdownAsynchronously;
    private final boolean _isSymlinkAware;
    private final Object _mutex = new Object();
    private ZKConnection _zkConnection;
    private Set<EventListener> _listeners;
    private State _state = State.INIT;

    public ZKPersistentConnection(String connect, int timeout, Collection<? extends EventListener> listeners) {
        this(connect, timeout, listeners, false);
    }

    public ZKPersistentConnection(String connect, int timeout, Collection<? extends EventListener> listeners, boolean shutdownAsynchronously) {
        this(connect, timeout, listeners, shutdownAsynchronously, false);
    }

    public ZKPersistentConnection(String connect, int timeout, Collection<? extends EventListener> listeners, boolean shutdownAsynchronously, boolean isSymlinkAware) {
        this._connectionString = connect;
        this._sessionTimeout = timeout;
        this._shutdownAsynchronously = shutdownAsynchronously;
        this._isSymlinkAware = isSymlinkAware;
        this._zkConnection = new ZKConnection(connect, timeout, shutdownAsynchronously, isSymlinkAware);
        this._zkConnection.addStateListener(new Listener());
        this._listeners = new HashSet<EventListener>(listeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws IOException {
        Object object = this._mutex;
        synchronized (object) {
            if (this._state != State.INIT) {
                throw new IllegalStateException("Can not start ZKConnection when " + (Object)((Object)this._state));
            }
            this._state = State.STARTED;
            this._listeners = Collections.unmodifiableSet(this._listeners);
            this._zkConnection.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws InterruptedException {
        Object object = this._mutex;
        synchronized (object) {
            if (this._state != State.STARTED) {
                throw new IllegalStateException("Can not shutdown ZKConnection when " + (Object)((Object)this._state));
            }
            this._state = State.STOPPED;
            this._zkConnection.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZooKeeper getZooKeeper() {
        Object object = this._mutex;
        synchronized (object) {
            return this._zkConnection.getZooKeeper();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZKConnection getZKConnection() {
        Object object = this._mutex;
        synchronized (object) {
            return this._zkConnection;
        }
    }

    private class Listener
    implements ZKConnection.StateListener {
        private long _sessionId;

        private Listener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notifyStateChange(Watcher.Event.KeeperState state) {
            long sessionId = ZKPersistentConnection.this.getZooKeeper().getSessionId();
            LOG.info("Got event {} for session 0x{}", (Object)state, (Object)Long.toHexString(sessionId));
            boolean newSession = false;
            if (state == Watcher.Event.KeeperState.SyncConnected && sessionId != this._sessionId) {
                newSession = true;
                this._sessionId = sessionId;
            }
            switch (state) {
                case SyncConnected: {
                    this.deliver(newSession ? Event.SESSION_ESTABLISHED : Event.CONNECTED);
                    break;
                }
                case Disconnected: {
                    this.deliver(Event.DISCONNECTED);
                    break;
                }
                case Expired: {
                    this.deliver(Event.SESSION_EXPIRED);
                }
            }
            if (state == Watcher.Event.KeeperState.Expired) {
                try {
                    Object object = ZKPersistentConnection.this._mutex;
                    synchronized (object) {
                        if (ZKPersistentConnection.this._state == State.STARTED) {
                            ZKPersistentConnection.this._zkConnection.shutdown();
                            ZKPersistentConnection.this._zkConnection = new ZKConnection(ZKPersistentConnection.this._connectionString, ZKPersistentConnection.this._sessionTimeout, ZKPersistentConnection.this._shutdownAsynchronously, ZKPersistentConnection.this._isSymlinkAware);
                            ZKPersistentConnection.this._zkConnection.addStateListener(new Listener());
                            ZKPersistentConnection.this._zkConnection.start();
                        }
                    }
                }
                catch (InterruptedException e) {
                    LOG.error("Failed to shutdown ZKConnection after expiration", (Throwable)e);
                }
                catch (IOException e) {
                    LOG.error("Failed to restart ZKConnection after expiration", (Throwable)e);
                }
            }
        }

        private void deliver(Event event) {
            for (EventListener listener : ZKPersistentConnection.this._listeners) {
                listener.notifyEvent(event);
            }
        }
    }

    public static interface EventListener {
        public void notifyEvent(Event var1);
    }

    public static enum Event {
        SESSION_ESTABLISHED,
        DISCONNECTED,
        CONNECTED,
        SESSION_EXPIRED;

    }

    private static enum State {
        INIT,
        STARTED,
        STOPPED;

    }
}

