/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.discovery.stores.zk;

import com.linkedin.common.callback.Callback;
import com.linkedin.common.callback.Callbacks;
import com.linkedin.common.util.None;
import com.linkedin.d2.discovery.PropertySerializer;
import com.linkedin.d2.discovery.stores.zk.RetryZooKeeper;
import com.linkedin.d2.discovery.stores.zk.SymlinkAwareRetryZooKeeper;
import com.linkedin.d2.discovery.stores.zk.SymlinkAwareZooKeeper;
import com.linkedin.d2.discovery.stores.zk.SymlinkUtil;
import com.linkedin.d2.discovery.stores.zk.VanillaZooKeeperAdapter;
import com.linkedin.d2.discovery.stores.zk.ZooKeeper;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKConnection {
    private static final Logger LOG = LoggerFactory.getLogger(ZKConnection.class);
    private static final int MAX_RETRIES = 10;
    private final String _connectString;
    private final int _timeout;
    private final int _retryLimit;
    private final boolean _exponentialBackoff;
    private final ScheduledExecutorService _scheduler;
    private final long _initInterval;
    private final boolean _shutdownAsynchronously;
    private final boolean _isSymlinkAware;
    private PropertySerializer<String> _symlinkSerializer = new SymlinkAwareZooKeeper.DefaultSerializer();
    private final CountDownLatch _zkRefLatch = new CountDownLatch(1);
    private final AtomicReference<ZooKeeper> _zkRef = new AtomicReference();
    private final Object _mutex = new Object();
    private final Set<StateListener> _listeners = new HashSet<StateListener>();
    private Watcher.Event.KeeperState _currentState;

    public ZKConnection(String connectString, int timeout) {
        this(connectString, timeout, false);
    }

    public ZKConnection(String connectString, int timeout, boolean shutdownAsynchronously) {
        this(connectString, timeout, 0, shutdownAsynchronously);
    }

    public ZKConnection(String connectString, int timeout, boolean shutdownAsynchronously, boolean isSymlinkAware) {
        this(connectString, timeout, 0, shutdownAsynchronously, isSymlinkAware);
    }

    public ZKConnection(String connectString, int timeout, int retryLimit) {
        this(connectString, timeout, retryLimit, false);
    }

    public ZKConnection(String connectString, int timeout, int retryLimit, boolean shutdownAsynchronously) {
        this(connectString, timeout, retryLimit, false, null, 0L, shutdownAsynchronously);
    }

    public ZKConnection(String connectString, int timeout, int retryLimit, boolean shutdownAsynchronously, boolean isSymlinkAware) {
        this(connectString, timeout, retryLimit, false, null, 0L, shutdownAsynchronously, isSymlinkAware);
    }

    public ZKConnection(String connectString, int timeout, int retryLimit, boolean exponentialBackoff, ScheduledExecutorService scheduler, long initInterval) {
        this(connectString, timeout, retryLimit, exponentialBackoff, scheduler, initInterval, false);
    }

    public ZKConnection(String connectString, int timeout, int retryLimit, boolean exponentialBackoff, ScheduledExecutorService scheduler, long initInterval, boolean shutdownAsynchronously) {
        this(connectString, timeout, retryLimit, exponentialBackoff, scheduler, initInterval, shutdownAsynchronously, false);
    }

    public ZKConnection(String connectString, int timeout, int retryLimit, boolean exponentialBackoff, ScheduledExecutorService scheduler, long initInterval, boolean shutdownAsynchronously, boolean isSymlinkAware) {
        this._connectString = connectString;
        this._timeout = timeout;
        this._retryLimit = retryLimit;
        this._exponentialBackoff = exponentialBackoff;
        this._scheduler = scheduler;
        this._initInterval = initInterval;
        this._shutdownAsynchronously = shutdownAsynchronously;
        this._isSymlinkAware = isSymlinkAware;
    }

    public void start() throws IOException {
        if (this._zkRef.get() != null) {
            throw new IllegalStateException("Already started");
        }
        DefaultWatcher defaultWatcher = new DefaultWatcher();
        ZooKeeper zk = new VanillaZooKeeperAdapter(this._connectString, this._timeout, defaultWatcher);
        if (this._retryLimit <= 0) {
            if (this._isSymlinkAware) {
                zk = new SymlinkAwareZooKeeper(zk, defaultWatcher, this._symlinkSerializer);
                LOG.info("Using symlink aware ZooKeeper without retry");
            } else {
                LOG.info("Using vanilla ZooKeeper without retry.");
            }
        } else {
            zk = new RetryZooKeeper(zk, this._retryLimit, this._exponentialBackoff, this._scheduler, this._initInterval);
            if (this._isSymlinkAware) {
                zk = new SymlinkAwareRetryZooKeeper((RetryZooKeeper)zk, (Watcher)defaultWatcher, this._symlinkSerializer);
                LOG.info("Using symlink aware RetryZooKeeper with retry limit set to " + this._retryLimit);
            } else {
                LOG.info("Using RetryZooKeeper with retry limit set to " + this._retryLimit);
            }
            if (this._exponentialBackoff) {
                LOG.info("Exponential backoff enabled. Initial retry interval set to " + this._initInterval + " ms.");
            } else {
                LOG.info("Exponential backoff disabled.");
            }
        }
        LOG.debug("Going to set zkRef");
        if (!this._zkRef.compareAndSet(null, zk)) {
            try {
                this.doShutdown(zk);
            }
            catch (InterruptedException e) {
                LOG.warn("Failed to shutdown extra ZooKeeperConnection", (Throwable)e);
            }
            throw new IllegalStateException("Already started");
        }
        LOG.debug("counting down");
        this._zkRefLatch.countDown();
    }

    public void shutdown() throws InterruptedException {
        ZooKeeper zk = this._zkRef.get();
        if (zk == null || !this._zkRef.compareAndSet(zk, null)) {
            throw new IllegalStateException("Already shutdown");
        }
        this.doShutdown(zk);
    }

    private void doShutdown(final ZooKeeper zk) throws InterruptedException {
        if (this._shutdownAsynchronously) {
            Runnable asyncShutdownRunnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        zk.close();
                    }
                    catch (InterruptedException e) {
                        LOG.warn("Failed to shutdown ZooKeeperConnection", (Throwable)e);
                    }
                }
            };
            LOG.info("Shutting down ZKConnection asynchronously");
            Thread shutdownThread = new Thread(asyncShutdownRunnable, "Asynchronous ZooKeeperConnection shutdown thread");
            shutdownThread.start();
        } else {
            LOG.info("Shutting down ZKConnection now");
            zk.close();
        }
    }

    private ZooKeeper zk() {
        ZooKeeper zk;
        try {
            if (!this._zkRefLatch.await(this._timeout, TimeUnit.MILLISECONDS)) {
                throw new RuntimeException("Wait for zkRef timed out.");
            }
            LOG.debug("zkRefLatch complete");
            zk = this._zkRef.get();
            if (zk == null) {
                throw new IllegalStateException("Null zkRef after countdownlatch.");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Got Interrupt Exception while waiting for zk", e);
        }
        return zk;
    }

    public ZooKeeper getZooKeeper() {
        return this.zk();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForState(Watcher.Event.KeeperState state, long timeout, TimeUnit timeUnit) throws InterruptedException, TimeoutException {
        long endTime = System.currentTimeMillis() + timeUnit.toMillis(timeout);
        Object object = this._mutex;
        synchronized (object) {
            while (!state.equals((Object)this._currentState)) {
                long waitTime = endTime - System.currentTimeMillis();
                if (waitTime > 0L) {
                    this._mutex.wait(waitTime);
                    continue;
                }
                throw new TimeoutException("timeout expired without state being reached");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStateListener(StateListener listener) {
        Object object = this._mutex;
        synchronized (object) {
            this._listeners.add(listener);
        }
    }

    public void ensurePersistentNodeExists(String path, final Callback<None> callback) {
        ZooKeeper zk = this.zk();
        while (path.endsWith("/") && path.length() > 1) {
            path = path.substring(0, path.length() - 1);
        }
        final String normalizedPath = path;
        AsyncCallback.StringCallback createCallback = new AsyncCallback.StringCallback(){

            public void processResult(int rc, String unused, Object ctx, String name) {
                KeeperException.Code code = KeeperException.Code.get((int)rc);
                switch (code) {
                    case OK: 
                    case NODEEXISTS: {
                        callback.onSuccess((Object)None.none());
                        break;
                    }
                    case NONODE: {
                        String parent = normalizedPath.substring(0, normalizedPath.lastIndexOf(47));
                        ZKConnection.this.ensurePersistentNodeExists(parent, new Callback<None>(){

                            public void onSuccess(None none) {
                                ZKConnection.this.ensurePersistentNodeExists(normalizedPath, (Callback<None>)callback);
                            }

                            public void onError(Throwable e) {
                                callback.onError(e);
                            }
                        });
                        break;
                    }
                    default: {
                        callback.onError((Throwable)KeeperException.create((KeeperException.Code)code));
                    }
                }
            }
        };
        try {
            zk.create(normalizedPath, null, ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, createCallback, null);
        }
        catch (Exception e) {
            callback.onError((Throwable)e);
        }
    }

    public void setDataUnsafe(String path, byte[] data, Callback<None> callback) {
        this.setDataUnsafe(path, data, callback, 0);
    }

    private void setDataUnsafe(String path, final byte[] data, final Callback<None> callback, final int count) {
        final ZooKeeper zk = this.zk();
        final AsyncCallback.StatCallback dataCallback = new AsyncCallback.StatCallback(){

            public void processResult(int rc, String path, Object ctx, Stat stat) {
                KeeperException.Code code = KeeperException.Code.get((int)rc);
                switch (code) {
                    case OK: {
                        callback.onSuccess((Object)None.none());
                        break;
                    }
                    case BADVERSION: {
                        if (count < 10) {
                            LOG.info("setDataUnsafe: ignored BADVERSION for {}", (Object)path);
                            ZKConnection.this.setDataUnsafe(path, data, (Callback<None>)callback, count + 1);
                            break;
                        }
                        callback.onError((Throwable)KeeperException.create((KeeperException.Code)code));
                        break;
                    }
                    default: {
                        callback.onError((Throwable)KeeperException.create((KeeperException.Code)code));
                    }
                }
            }
        };
        AsyncCallback.StatCallback statCallback = new AsyncCallback.StatCallback(){

            public void processResult(int rc, String path, Object ctx, Stat stat) {
                KeeperException.Code code = KeeperException.Code.get((int)rc);
                switch (code) {
                    case OK: {
                        zk.setData(path, data, stat.getVersion(), dataCallback, null);
                        break;
                    }
                    default: {
                        callback.onError((Throwable)KeeperException.create((KeeperException.Code)code));
                    }
                }
            }
        };
        try {
            if (zk instanceof SymlinkAwareZooKeeper) {
                ((SymlinkAwareZooKeeper)zk).rawExists(path, false, statCallback, null);
            } else {
                zk.exists(path, false, statCallback, null);
            }
        }
        catch (Exception e) {
            callback.onError((Throwable)e);
        }
    }

    public void removeNodeUnsafe(String path, Callback<None> callback) {
        this.removeNodeUnsafe(path, callback, 0);
    }

    private void removeNodeUnsafe(String path, final Callback<None> callback, final int count) {
        final ZooKeeper zk = this.zk();
        final AsyncCallback.VoidCallback deleteCallback = new AsyncCallback.VoidCallback(){

            public void processResult(int rc, String path, Object ctx) {
                KeeperException.Code code = KeeperException.Code.get((int)rc);
                switch (code) {
                    case OK: {
                        callback.onSuccess((Object)None.none());
                        break;
                    }
                    case BADVERSION: {
                        if (count < 10) {
                            LOG.info("removeNodeUnsafe: retrying after ignoring BADVERSION for {}", (Object)path);
                            ZKConnection.this.removeNodeUnsafe(path, (Callback<None>)callback, count + 1);
                            break;
                        }
                        callback.onError((Throwable)KeeperException.create((KeeperException.Code)code));
                        break;
                    }
                    default: {
                        callback.onError((Throwable)KeeperException.create((KeeperException.Code)code));
                    }
                }
            }
        };
        AsyncCallback.StatCallback existsCallback = new AsyncCallback.StatCallback(){

            public void processResult(int rc, String path, Object ctx, Stat stat) {
                KeeperException.Code code = KeeperException.Code.get((int)rc);
                switch (code) {
                    case OK: {
                        zk.delete(path, stat.getVersion(), deleteCallback, null);
                        break;
                    }
                    case NONODE: {
                        callback.onSuccess((Object)None.none());
                        break;
                    }
                    default: {
                        callback.onError((Throwable)KeeperException.create((KeeperException.Code)code));
                    }
                }
            }
        };
        try {
            if (zk instanceof SymlinkAwareZooKeeper) {
                ((SymlinkAwareZooKeeper)zk).rawExists(path, false, existsCallback, null);
            } else {
                zk.exists(path, false, existsCallback, null);
            }
        }
        catch (Exception e) {
            callback.onError((Throwable)e);
        }
    }

    public void removeNodeUnsafeRecursive(final String path, final Callback<None> callback) {
        ZooKeeper zk = this.zk();
        Callback<None> deleteThisNodeCallback = new Callback<None>(){

            public void onSuccess(None none) {
                ZKConnection.this.removeNodeUnsafe(path, (Callback<None>)callback);
            }

            public void onError(Throwable e) {
                callback.onError(e);
            }
        };
        AsyncCallback.ChildrenCallback childCallback = new AsyncCallback.ChildrenCallback((Callback)deleteThisNodeCallback, callback){
            final /* synthetic */ Callback val$deleteThisNodeCallback;
            final /* synthetic */ Callback val$callback;
            {
                this.val$deleteThisNodeCallback = callback;
                this.val$callback = callback2;
            }

            public void processResult(int rc, String path, Object ctx, List<String> children) {
                KeeperException.Code code = KeeperException.Code.get((int)rc);
                switch (code) {
                    case OK: {
                        Callback multiCallback = Callbacks.countDown((Callback)this.val$deleteThisNodeCallback, (int)children.size());
                        for (String child : children) {
                            ZKConnection.this.removeNodeUnsafeRecursive(path + "/" + child, (Callback<None>)multiCallback);
                        }
                        break;
                    }
                    default: {
                        this.val$callback.onError((Throwable)KeeperException.create((KeeperException.Code)code));
                    }
                }
            }
        };
        try {
            if (zk instanceof SymlinkAwareZooKeeper) {
                ((SymlinkAwareZooKeeper)zk).rawGetChildren(path, false, childCallback, null);
            } else {
                zk.getChildren(path, false, childCallback, null);
            }
        }
        catch (Exception e) {
            callback.onError((Throwable)e);
        }
    }

    public void createSymlink(String symlinkPath, String realPath, final Callback<None> callback) {
        if (!SymlinkUtil.containsSymlink(symlinkPath) || SymlinkUtil.firstSymlinkIndex(symlinkPath) < symlinkPath.length()) {
            callback.onError((Throwable)new IllegalArgumentException("Cannot create symbolic link for path " + symlinkPath));
            return;
        }
        ZooKeeper zk = this.zk();
        AsyncCallback.StringCallback createCallback = new AsyncCallback.StringCallback(){

            public void processResult(int rc, String path, Object ctx, String name) {
                KeeperException.Code code = KeeperException.Code.get((int)rc);
                switch (code) {
                    case OK: {
                        callback.onSuccess((Object)None.none());
                        break;
                    }
                    default: {
                        callback.onError((Throwable)KeeperException.create((KeeperException.Code)code));
                    }
                }
            }
        };
        try {
            zk.create(symlinkPath, this._symlinkSerializer.toBytes(realPath), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT, createCallback, null);
        }
        catch (Exception e) {
            callback.onError((Throwable)e);
        }
    }

    public void setSymlinkData(String symlinkPath, String realPath, Callback<None> callback) {
        if (!SymlinkUtil.containsSymlink(symlinkPath) || SymlinkUtil.firstSymlinkIndex(symlinkPath) < symlinkPath.length()) {
            callback.onError((Throwable)new IllegalArgumentException("Cannot set data to symbolic link " + symlinkPath));
            return;
        }
        this.setSymlinkData(symlinkPath, realPath, callback, 0);
    }

    private void setSymlinkData(final String symlinkPath, final String realPath, final Callback<None> callback, final int count) {
        final ZooKeeper zk = this.zk();
        final AsyncCallback.StatCallback dataCallback = new AsyncCallback.StatCallback(){

            public void processResult(int rc, String path, Object ctx, Stat stat) {
                KeeperException.Code code = KeeperException.Code.get((int)rc);
                switch (code) {
                    case OK: {
                        callback.onSuccess((Object)None.none());
                        break;
                    }
                    case BADVERSION: {
                        if (count >= 10) break;
                        ZKConnection.this.setSymlinkData(symlinkPath, realPath, (Callback<None>)callback, count + 1);
                        break;
                    }
                    default: {
                        callback.onError((Throwable)KeeperException.create((KeeperException.Code)code));
                    }
                }
            }
        };
        AsyncCallback.StatCallback existsCallback = new AsyncCallback.StatCallback(){

            public void processResult(int rc, String path, Object ctx, Stat stat) {
                KeeperException.Code code = KeeperException.Code.get((int)rc);
                switch (code) {
                    case OK: {
                        zk.setData(symlinkPath, ZKConnection.this._symlinkSerializer.toBytes(realPath), stat.getVersion(), dataCallback, null);
                        break;
                    }
                    case NONODE: {
                        ZKConnection.this.createSymlink(symlinkPath, realPath, (Callback<None>)callback);
                        break;
                    }
                    default: {
                        callback.onError((Throwable)KeeperException.create((KeeperException.Code)code));
                    }
                }
            }
        };
        try {
            if (zk instanceof SymlinkAwareZooKeeper) {
                ((SymlinkAwareZooKeeper)zk).rawExists(symlinkPath, null, existsCallback, null);
            } else {
                zk.exists(symlinkPath, null, existsCallback, null);
            }
        }
        catch (Exception e) {
            callback.onError((Throwable)e);
        }
    }

    private class DefaultWatcher
    implements Watcher {
        private DefaultWatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(WatchedEvent watchedEvent) {
            ZooKeeper zk = ZKConnection.this.zk();
            long sessionID = zk.getSessionId();
            if (watchedEvent.getType() == Watcher.Event.EventType.None) {
                Watcher.Event.KeeperState state = watchedEvent.getState();
                LOG.info("Received state notification {} for session 0x{}", (Object)state, (Object)Long.toHexString(sessionID));
                Set<StateListener> listeners = Collections.emptySet();
                Iterator<StateListener> iterator = ZKConnection.this._mutex;
                synchronized (iterator) {
                    if (ZKConnection.this._currentState != state) {
                        ZKConnection.this._currentState = state;
                        ZKConnection.this._mutex.notifyAll();
                        listeners = new HashSet<StateListener>(ZKConnection.this._listeners);
                    }
                }
                for (StateListener listener : listeners) {
                    listener.notifyStateChange(state);
                }
            } else {
                LOG.warn("Received unexpected event of type {} for session 0x{}", (Object)watchedEvent.getType(), (Object)Long.toHexString(sessionID));
            }
        }
    }

    public static interface StateListener {
        public void notifyStateChange(Watcher.Event.KeeperState var1);
    }
}

