/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.discovery.event;

import com.linkedin.d2.discovery.util.LogUtil;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyEventThread
extends Thread {
    private static final Logger _log = LoggerFactory.getLogger(PropertyEventThread.class);
    private BlockingQueue<PropertyEvent> _messages;

    public PropertyEventThread(String name) {
        this(name, Integer.MAX_VALUE);
    }

    public PropertyEventThread(String name, int size) {
        this(name, size, false);
    }

    public PropertyEventThread(String name, int size, boolean start) {
        this._messages = new LinkedBlockingQueue<PropertyEvent>(size);
        this.setDaemon(true);
        this.setName("PropertyEventThread-" + this.getId() + "-" + name);
        if (start) {
            this.start();
        }
    }

    public int getRemainingCapacity() {
        return this._messages.remainingCapacity();
    }

    public int getQueuedMessageCount() {
        return this._messages.size();
    }

    @Override
    public void start() {
        LogUtil.info(_log, "starting thread: ", this.getName());
        super.start();
    }

    public boolean send(PropertyEvent message) {
        if (message == null) {
            LogUtil.warn(_log, "send called with null message");
        } else if (!this.isAlive()) {
            LogUtil.error(_log, "sending message while thread ", this.getName(), " is down: ", message);
        } else {
            LogUtil.debug(_log, this.getName(), " got message: ", message);
            return this._messages.add(message);
        }
        int remainingCapacity = this.getRemainingCapacity();
        if (remainingCapacity < 1000) {
            LogUtil.warn(_log, "remaining capacity for thread ", this.getName(), " is dangerously low: ", remainingCapacity);
        }
        return false;
    }

    @Override
    public void run() {
        boolean shutdown = false;
        while (!shutdown || this._messages.size() > 0) {
            try {
                PropertyEvent message = this._messages.poll(1L, TimeUnit.SECONDS);
                if (message != null) {
                    message.run();
                    continue;
                }
                LogUtil.debug(_log, "received null message in thread: ", this.getName());
            }
            catch (InterruptedException e) {
                shutdown = true;
                LogUtil.info(_log, "thread ", this.getName(), " got interrupt, so shutting down");
            }
            catch (Exception e) {
                _log.error("Unhandled exception in event thread", (Throwable)e);
            }
        }
        LogUtil.info(_log, "thread ", this.getName(), " finished run() and is now dying");
    }

    public static interface PropertyEventShutdownCallback {
        public void done();
    }

    public static abstract class PropertyEvent
    implements Runnable {
        private String _description;

        public PropertyEvent(String description) {
            this._description = description;
        }

        public String toString() {
            return "PropertyEvent [_description=" + this._description + "]";
        }

        @Override
        public final void run() {
            try {
                this.innerRun();
            }
            catch (RuntimeException e) {
                _log.error("Received exception from: " + this._description, (Throwable)e);
            }
        }

        public abstract void innerRun();
    }
}

