/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.zkfs;

import com.linkedin.common.callback.Callback;
import com.linkedin.d2.balancer.Directory;
import com.linkedin.d2.balancer.zkfs.ZKFSUtil;
import com.linkedin.d2.discovery.stores.zk.ZKConnection;
import com.linkedin.d2.discovery.stores.zk.ZooKeeper;
import java.util.Collections;
import java.util.List;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;

public class ZKFSDirectory
implements Directory {
    private final String _basePath;
    private volatile ZKConnection _connection;

    public ZKFSDirectory(String basePath) {
        this._basePath = basePath;
    }

    @Override
    public void getServiceNames(final Callback<List<String>> callback) {
        ZooKeeper zk = this._connection.getZooKeeper();
        String path = ZKFSUtil.servicePath(this._basePath);
        zk.getChildren(path, false, new AsyncCallback.Children2Callback(){

            public void processResult(int rc, String path, Object ctx, List<String> children, Stat stat) {
                KeeperException.Code code = KeeperException.Code.get((int)rc);
                switch (code) {
                    case OK: {
                        callback.onSuccess(children);
                        break;
                    }
                    case NONODE: {
                        callback.onSuccess(Collections.emptyList());
                        break;
                    }
                    default: {
                        callback.onError((Throwable)KeeperException.create((KeeperException.Code)code));
                    }
                }
            }
        }, null);
    }

    @Override
    public void getClusterNames(final Callback<List<String>> callback) {
        ZooKeeper zk = this._connection.getZooKeeper();
        String path = ZKFSUtil.clusterPath(this._basePath);
        zk.getChildren(path, false, new AsyncCallback.Children2Callback(){

            public void processResult(int rc, String path, Object ctx, List<String> children, Stat stat) {
                KeeperException.Code code = KeeperException.Code.get((int)rc);
                switch (code) {
                    case OK: {
                        callback.onSuccess(children);
                        break;
                    }
                    case NONODE: {
                        callback.onSuccess(Collections.emptyList());
                        break;
                    }
                    default: {
                        callback.onError((Throwable)KeeperException.create((KeeperException.Code)code));
                    }
                }
            }
        }, null);
    }

    public void setConnection(ZKConnection connection) {
        this._connection = connection;
    }
}

