/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.util.hashing;

import com.linkedin.common.util.MapUtil;
import com.linkedin.d2.balancer.util.hashing.HashFunction;
import com.linkedin.d2.balancer.util.hashing.MD5Hash;
import com.linkedin.r2.message.Request;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URIRegexHash
implements HashFunction<Request> {
    public static final String KEY_REGEXES = "regexes";
    public static final String KEY_FAIL_ON_NO_MATCH = "failOnNoMatch";
    public static final String KEY_WARN_ON_NO_MATCH = "warnOnNoMatch";
    private static final Logger LOG = LoggerFactory.getLogger(URIRegexHash.class);
    private final List<Pattern> _patterns;
    private final boolean _failOnNoMatch;
    private final boolean _warnOnNoMatch;
    private final Random _random = new Random();
    private final MD5Hash _md5 = new MD5Hash();

    public URIRegexHash(Map<String, Object> config) {
        this((List)config.get(KEY_REGEXES), (Boolean)MapUtil.getWithDefault(config, (Object)KEY_FAIL_ON_NO_MATCH, (Object)false), (Boolean)MapUtil.getWithDefault(config, (Object)KEY_WARN_ON_NO_MATCH, (Object)true));
    }

    public URIRegexHash(List<String> patterns, boolean failOnNoMatch) {
        this(patterns, failOnNoMatch, true);
    }

    public URIRegexHash(List<String> patterns, boolean failOnNoMatch, boolean warnOnNoMatch) {
        ArrayList<Pattern> compiledPatterns = new ArrayList<Pattern>(patterns.size());
        for (String p : patterns) {
            compiledPatterns.add(Pattern.compile(p));
        }
        this._patterns = Collections.unmodifiableList(compiledPatterns);
        this._failOnNoMatch = failOnNoMatch;
        this._warnOnNoMatch = warnOnNoMatch;
    }

    @Override
    public int hash(Request request) {
        String uriString = request.getURI().toString();
        for (Pattern p : this._patterns) {
            Matcher matcher = p.matcher(uriString);
            if (!matcher.find()) continue;
            int count = matcher.groupCount();
            if (count > 0) {
                int i;
                if (LOG.isDebugEnabled()) {
                    StringBuilder builder = new StringBuilder();
                    for (i = 0; i < count; ++i) {
                        builder.append(matcher.group(i + 1));
                    }
                    LOG.debug("URI {} matched pattern {} with result: {}", new Object[]{uriString, p.pattern(), builder.toString()});
                }
                String[] keyTokens = new String[count];
                for (i = 0; i < count; ++i) {
                    keyTokens[i] = matcher.group(i + 1);
                }
                return this._md5.hash(keyTokens);
            }
            LOG.warn("Ignoring pattern '{}' which matched but produced no capture groups for URI '{}'", (Object)p, (Object)uriString);
        }
        if (this._failOnNoMatch) {
            throw new RuntimeException("No expression matched URI " + uriString);
        }
        if (this._warnOnNoMatch) {
            LOG.warn("No expression matched URI {}, falling back to random", (Object)uriString);
        } else {
            LOG.debug("No expression matched URI {}, falling back to random", (Object)uriString);
        }
        return this._random.nextInt();
    }

    @Override
    public long hashLong(Request request) {
        throw new UnsupportedOperationException("hashLong is not supported yet by URIRegexHash.");
    }
}

