/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.strategies.degrader;

import com.linkedin.d2.balancer.KeyMapper;
import com.linkedin.d2.balancer.clients.TrackerClient;
import com.linkedin.d2.balancer.strategies.LoadBalancerStrategy;
import com.linkedin.d2.balancer.strategies.degrader.DegraderLoadBalancerStrategyConfig;
import com.linkedin.d2.balancer.util.hashing.ConsistentHashRing;
import com.linkedin.d2.balancer.util.hashing.HashFunction;
import com.linkedin.d2.balancer.util.hashing.RandomHash;
import com.linkedin.d2.balancer.util.hashing.Ring;
import com.linkedin.d2.balancer.util.hashing.URIRegexHash;
import com.linkedin.d2.discovery.util.LogUtil;
import com.linkedin.r2.message.Request;
import com.linkedin.r2.message.RequestContext;
import com.linkedin.util.degrader.DegraderImpl;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DegraderLoadBalancerStrategyV2
implements LoadBalancerStrategy {
    public static final String HASH_METHOD_NONE = "none";
    public static final String HASH_METHOD_URI_REGEX = "uriRegex";
    public static final int DEFAULT_PARTITION_ID = 0;
    private static final Logger _log = LoggerFactory.getLogger(DegraderLoadBalancerStrategyV2.class);
    private boolean _updateEnabled = true;
    private volatile DegraderLoadBalancerStrategyConfig _config;
    private volatile HashFunction<Request> _hashFunction;
    private volatile DegraderLoadBalancerState _state;
    private volatile Object _lock;

    public Ring<URI> getRing() {
        return this._state.getRing();
    }

    public DegraderLoadBalancerStrategyV2(DegraderLoadBalancerStrategyConfig config, String serviceName, Map<String, String> degraderProperties) {
        this.setConfig(config);
        this._lock = new Object();
        if (degraderProperties == null) {
            degraderProperties = Collections.emptyMap();
        }
        this._state = new DegraderLoadBalancerState(this._config.getUpdateIntervalMs(), -1L, new HashMap<URI, Integer>(), this._config.getClock().currentTimeMillis(), DegraderLoadBalancerState.Strategy.LOAD_BALANCE, 0.0, 0.0, false, new HashMap<TrackerClient, Double>(), serviceName, degraderProperties, 0L);
    }

    @Override
    public TrackerClient getTrackerClient(Request request, RequestContext requestContext, long clusterGenerationId, int partitionId, List<TrackerClient> trackerClients) {
        boolean dropCall;
        if (partitionId != 0) {
            throw new UnsupportedOperationException("Trying to access partition: " + partitionId + "on an unpartitioned cluster");
        }
        LogUtil.debug(_log, "getTrackerClient with generation id ", clusterGenerationId, " on tracker clients: ", clusterGenerationId);
        if (trackerClients == null || trackerClients.size() == 0) {
            LogUtil.warn(_log, "getTrackerClient called with null/empty trackerClients, so returning null");
            return null;
        }
        this.checkUpdateState(clusterGenerationId, trackerClients);
        boolean hasInitializationError = this._state.hasError();
        URI targetHostUri = KeyMapper.TargetHostHints.getRequestContextTargetHost(requestContext);
        Set<URI> excludedUris = LoadBalancerStrategy.ExcludedHostHints.getRequestContextExcludedHosts(requestContext);
        URI hostHeaderUri = targetHostUri;
        if (!hasInitializationError && targetHostUri == null) {
            int hashCode = this._hashFunction.hash(request);
            Ring<URI> ring = this._state.getRing();
            Iterator<URI> iterator = ring.getIterator(hashCode);
            while (iterator.hasNext() && targetHostUri == null) {
                URI uri = iterator.next();
                if (excludedUris != null && excludedUris.contains(uri)) continue;
                targetHostUri = uri;
            }
            LoadBalancerStrategy.ExcludedHostHints.addRequestContextExcludedHost(requestContext, targetHostUri);
        } else if (hasInitializationError && targetHostUri == null) {
            targetHostUri = trackerClients.get(new Random().nextInt(trackerClients.size())).getUri();
        } else {
            LogUtil.debug(_log, "Degrader honoring target host header in request, skipping hashing.  URI: " + targetHostUri.toString());
        }
        TrackerClient client = null;
        if (targetHostUri != null) {
            for (TrackerClient trackerClient : trackerClients) {
                if (!trackerClient.getUri().equals(targetHostUri)) continue;
                client = trackerClient;
                break;
            }
            if (client == null) {
                LogUtil.warn(_log, "No client found for " + targetHostUri + (hostHeaderUri == null ? ", degrader load balancer state is inconsistent with cluster manager" : ", target host specified is no longer part of cluster"));
            }
        } else {
            LogUtil.warn(_log, "unable to find a URI to use");
        }
        boolean bl = dropCall = client == null;
        if (!dropCall) {
            dropCall = client.getDegrader(0).checkDrop();
            if (dropCall) {
                LogUtil.warn(_log, "client's degrader is dropping call for: ", client);
            } else {
                LogUtil.debug(_log, "returning client: ", client);
            }
        }
        return !dropCall ? client : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void checkUpdateState(long clusterGenerationId, List<TrackerClient> trackerClients) {
        block21: {
            currentState = this.getState();
            if (!DegraderLoadBalancerStrategyV2.shouldUpdate(clusterGenerationId, currentState, config = this.getConfig(), this._updateEnabled)) break block21;
            var6_5 = this._lock;
            synchronized (var6_5) {
                block20: {
                    try {
                        LogUtil.debug(DegraderLoadBalancerStrategyV2._log, new Object[]{"updating for cluster generation id: " + clusterGenerationId + " state last updated timestamp: " + currentState.getLastUpdated()});
                        LogUtil.debug(DegraderLoadBalancerStrategyV2._log, new Object[]{"old state was: ", currentState});
                        if (!currentState.isInitialized()) {
                            DegraderLoadBalancerStrategyV2._log.info("Starting to initialize state");
                        }
                        this._state = DegraderLoadBalancerStrategyV2.updateState(clusterGenerationId, trackerClients, currentState, config);
                        if (this._state.isInitialized()) break block20;
                        DegraderLoadBalancerStrategyV2._log.error("Failed to initialize state");
                    }
                    catch (RuntimeException e) {
                        try {
                            if (!this._state.isInitialized()) {
                                this._state = new DegraderLoadBalancerState(this._state, DegraderLoadBalancerState.access$000(this._state), config.getUpdateIntervalMs(), config.getClock().currentTimeMillis(), true, true);
                                DegraderLoadBalancerStrategyV2._log.error("Encountered an error while initializing the load balancer's strategy.", (Throwable)e);
                            } else {
                                DegraderLoadBalancerStrategyV2.revertTrackerClientsToOldState(trackerClients, currentState, config);
                                this._state = new DegraderLoadBalancerState(this._state, DegraderLoadBalancerState.access$000(this._state), config.getUpdateIntervalMs(), config.getClock().currentTimeMillis(), true, true);
                                DegraderLoadBalancerStrategyV2._log.error("Encountered an error while updating the load balancer's strategy. We will fallback to use the previous strategy which is " + currentState, (Throwable)e);
                            }
                            this._lock.notifyAll();
                            currentState = this.getState();
                            errorDuringUpdate = currentState.isInitialized() == false || currentState.hasError() != false;
                        }
                        catch (Throwable var8_9) {
                            this._lock.notifyAll();
                            currentState = this.getState();
                            errorDuringUpdate = currentState.isInitialized() == false || currentState.hasError() != false;
                            this._state = new DegraderLoadBalancerState(this._state, DegraderLoadBalancerState.access$000(this._state), config.getUpdateIntervalMs(), this._state.getLastUpdated(), errorDuringUpdate, false);
                            if (!currentState.isInitialized()) {
                                DegraderLoadBalancerStrategyV2._log.error("Uncaught throwable is causing state initialization to fail. Continuing... currentState = " + currentState);
                            }
                            throw var8_9;
                        }
                        this._state = new DegraderLoadBalancerState(this._state, DegraderLoadBalancerState.access$000(this._state), config.getUpdateIntervalMs(), this._state.getLastUpdated(), errorDuringUpdate, false);
                        if (!currentState.isInitialized()) {
                            DegraderLoadBalancerStrategyV2._log.error("Uncaught throwable is causing state initialization to fail. Continuing... currentState = " + currentState);
                        } else {
                            ** GOTO lbl46
                        }
                    }
                }
                this._lock.notifyAll();
                currentState = this.getState();
                errorDuringUpdate = currentState.isInitialized() == false || currentState.hasError() != false;
                this._state = new DegraderLoadBalancerState(this._state, DegraderLoadBalancerState.access$000(this._state), config.getUpdateIntervalMs(), this._state.getLastUpdated(), errorDuringUpdate, false);
                if (!currentState.isInitialized()) {
                    DegraderLoadBalancerStrategyV2._log.error("Uncaught throwable is causing state initialization to fail. Continuing... currentState = " + currentState);
                }
lbl46:
                // 3 sources

            }
        }
        if (!this._state.isInitialized()) {
            var6_5 = this._lock;
            synchronized (var6_5) {
                while (!this._state.isInitialized() && !this._state.hasError()) {
                    try {
                        this._lock.wait();
                    }
                    catch (InterruptedException var7_8) {}
                }
            }
        }
    }

    private static void restoreSnapshot(List<TrackerClient> clients, Map<TrackerClient, Double> undoLog, Double configMaxDropRate) {
        for (TrackerClient client : clients) {
            Double maxDropRate = undoLog.get(client);
            if (maxDropRate != null) {
                client.getDegraderControl(0).setMaxDropRate(maxDropRate.doubleValue());
                continue;
            }
            client.getDegraderControl(0).setMaxDropRate(configMaxDropRate.doubleValue());
        }
    }

    private static void revertTrackerClientsToOldState(List<TrackerClient> trackerClients, DegraderLoadBalancerState oldState, DegraderLoadBalancerStrategyConfig config) {
        String configMaxDropRateString = oldState.getDegraderProperties().get("degrader.maxDropRate");
        Double configMaxDropRate = DegraderImpl.DEFAULT_MAX_DROP_RATE;
        if (configMaxDropRateString != null) {
            try {
                configMaxDropRate = (double)configMaxDropRate;
            }
            catch (NumberFormatException e) {
                LogUtil.warn(_log, "converting maxDropRate string to double throw an exception", e);
            }
        }
        DegraderLoadBalancerStrategyV2.restoreSnapshot(trackerClients, oldState.getPreviousMaxDropRate(), configMaxDropRate);
        DegraderLoadBalancerStrategyV2.overrideClusterDropRate(oldState.getCurrentOverrideDropRate(), trackerClients);
        DegraderLoadBalancerStrategyV2.overrideMinCallCount(oldState.getCurrentOverrideDropRate(), trackerClients, oldState.getPointsMap(), config.getPointsPerWeight());
    }

    static boolean isNewStateHealthy(DegraderLoadBalancerState newState, DegraderLoadBalancerStrategyConfig config, List<TrackerClient> trackerClients) {
        if (newState.getCurrentAvgClusterLatency() > config.getLowWaterMark()) {
            return false;
        }
        Map<URI, Integer> pointsMap = newState.getPointsMap();
        for (TrackerClient client : trackerClients) {
            int perfectHealth = (int)(client.getPartitionWeight(0) * (double)config.getPointsPerWeight());
            Integer point = pointsMap.get(client.getUri());
            if (point >= perfectHealth) continue;
            return false;
        }
        return true;
    }

    static boolean isOldStateTheSameAsNewState(DegraderLoadBalancerState oldState, DegraderLoadBalancerState newState) {
        return oldState.getClusterGenerationId() == newState.getClusterGenerationId() && oldState.getCurrentOverrideDropRate() == newState.getCurrentOverrideDropRate() && oldState.getPointsMap().equals(newState.getPointsMap()) && oldState.getRecoveryMap().equals(newState.getRecoveryMap());
    }

    private static void logState(DegraderLoadBalancerState oldState, DegraderLoadBalancerState newState, DegraderLoadBalancerStrategyConfig config, List<TrackerClient> trackerClients) {
        if (_log.isDebugEnabled()) {
            _log.debug("Strategy updated: newState=" + newState + ", unhealthyClients = " + DegraderLoadBalancerStrategyV2.getUnhealthyTrackerClients(trackerClients, newState._pointsMap, config) + ", config=" + config + ", HashRing coverage=" + newState.getRing());
        } else if (!DegraderLoadBalancerStrategyV2.isOldStateTheSameAsNewState(oldState, newState) || !DegraderLoadBalancerStrategyV2.isNewStateHealthy(newState, config, trackerClients)) {
            _log.info("Strategy updated: newState=" + newState + ", unhealthyClients = " + DegraderLoadBalancerStrategyV2.getUnhealthyTrackerClients(trackerClients, newState._pointsMap, config) + ", oldState =" + oldState + ", new state's config=" + config);
        }
    }

    private static List<String> getUnhealthyTrackerClients(List<TrackerClient> trackerClients, Map<URI, Integer> pointsMap, DegraderLoadBalancerStrategyConfig config) {
        ArrayList<String> unhealthyClients = new ArrayList<String>();
        for (TrackerClient client : trackerClients) {
            int perfectHealth = (int)(client.getPartitionWeight(0) * (double)config.getPointsPerWeight());
            Integer point = pointsMap.get(client.getUri());
            if (point >= perfectHealth) continue;
            unhealthyClients.add(client.getUri() + ":" + point + "/" + perfectHealth);
        }
        return unhealthyClients;
    }

    private static DegraderLoadBalancerState updateState(long clusterGenerationId, List<TrackerClient> trackerClients, DegraderLoadBalancerState oldState, DegraderLoadBalancerStrategyConfig config) {
        DegraderLoadBalancerState newState;
        LogUtil.debug(_log, "updating state for: ", trackerClients);
        double sumOfClusterLatencies = 0.0;
        double computedClusterDropSum = 0.0;
        double computedClusterWeight = 0.0;
        long totalClusterCallCount = 0L;
        boolean hashRingChanges = false;
        boolean recoveryMapChanges = false;
        DegraderLoadBalancerState.Strategy strategy = oldState.getStrategy();
        Map<TrackerClient, Double> oldRecoveryMap = oldState.getRecoveryMap();
        HashMap<TrackerClient, Double> newRecoveryMap = new HashMap<TrackerClient, Double>(oldRecoveryMap);
        double currentOverrideDropRate = oldState.getCurrentOverrideDropRate();
        double initialRecoveryLevel = config.getInitialRecoveryLevel();
        double ringRampFactor = config.getRingRampFactor();
        int pointsPerWeight = config.getPointsPerWeight();
        for (TrackerClient client : trackerClients) {
            double averageLatency = client.getDegraderControl(0).getLatency();
            long callCount = client.getDegraderControl(0).getCallCount();
            oldState.getPreviousMaxDropRate().put(client, client.getDegraderControl(0).getMaxDropRate());
            sumOfClusterLatencies += averageLatency * (double)callCount;
            totalClusterCallCount += callCount;
            double clientDropRate = client.getDegraderControl(0).getCurrentComputedDropRate();
            computedClusterDropSum += client.getPartitionWeight(0) * clientDropRate;
            computedClusterWeight += client.getPartitionWeight(0).doubleValue();
            boolean recoveryMapContainsClient = newRecoveryMap.containsKey(client);
            if (callCount == 0L) {
                if (!recoveryMapContainsClient) continue;
                if (strategy == DegraderLoadBalancerState.Strategy.LOAD_BALANCE) {
                    double oldMaxDropRate = client.getDegraderControl(0).getMaxDropRate();
                    double transmissionRate = 1.0 - oldMaxDropRate;
                    if (transmissionRate <= 0.0) {
                        transmissionRate = initialRecoveryLevel;
                    } else {
                        transmissionRate *= ringRampFactor;
                        transmissionRate = Math.min(transmissionRate, 1.0);
                    }
                    double newMaxDropRate = 1.0 - transmissionRate;
                    client.getDegraderControl(0).setMaxDropRate(newMaxDropRate);
                }
                recoveryMapChanges = true;
                continue;
            }
            if (!recoveryMapContainsClient) continue;
            client.getDegraderControl(0).setMaxDropRate(((Double)newRecoveryMap.get(client)).doubleValue());
            newRecoveryMap.remove(client);
            recoveryMapChanges = true;
        }
        double computedClusterDropRate = computedClusterDropSum / computedClusterWeight;
        LogUtil.debug(_log, "total cluster call count: ", totalClusterCallCount);
        LogUtil.debug(_log, "computed cluster drop rate for ", trackerClients.size(), " nodes: ", computedClusterDropRate);
        if (oldState.getClusterGenerationId() == clusterGenerationId && totalClusterCallCount <= 0L && !recoveryMapChanges) {
            LogUtil.debug(_log, "New state is the same as the old state so we're not changing anything. Old state = ", oldState, ", config=", config);
            return new DegraderLoadBalancerState(oldState, clusterGenerationId, config.getUpdateIntervalMs(), config.getClock().currentTimeMillis());
        }
        double newCurrentAvgClusterLatency = -1.0;
        if (totalClusterCallCount > 0L) {
            newCurrentAvgClusterLatency = sumOfClusterLatencies / (double)totalClusterCallCount;
        }
        LogUtil.debug(_log, "average cluster latency: ", newCurrentAvgClusterLatency);
        Map<URI, Integer> points = new HashMap<URI, Integer>();
        Map<URI, Integer> oldPointsMap = oldState.getPointsMap();
        for (TrackerClient client : trackerClients) {
            URI clientUri = client.getUri();
            double dropRate = Math.min(client.getDegraderControl(0).getCurrentComputedDropRate(), client.getDegraderControl(0).getMaxDropRate());
            double successfulTransmissionWeight = client.getPartitionWeight(0) * (1.0 - dropRate);
            LogUtil.debug(_log, "computed new weight for uri ", clientUri, ": ", successfulTransmissionWeight);
            int newPoints = (int)(successfulTransmissionWeight * (double)pointsPerWeight);
            if (newPoints == 0) {
                Double oldMaxDropRate = client.getDegraderControl(0).getMaxDropRate();
                newPoints = (int)(initialRecoveryLevel * (double)pointsPerWeight);
                if (!newRecoveryMap.containsKey(client)) {
                    newRecoveryMap.put(client, oldMaxDropRate);
                    client.getDegraderControl(0).setMaxDropRate(1.0 - initialRecoveryLevel);
                }
            }
            points.put(clientUri, newPoints);
            if (oldPointsMap.containsKey(clientUri) && oldPointsMap.get(clientUri) == newPoints) continue;
            hashRingChanges = true;
        }
        if (strategy == DegraderLoadBalancerState.Strategy.LOAD_BALANCE && hashRingChanges || oldState.getClusterGenerationId() != clusterGenerationId) {
            newState = new DegraderLoadBalancerState(config.getUpdateIntervalMs(), clusterGenerationId, points, config.getClock().currentTimeMillis(), DegraderLoadBalancerState.Strategy.CALL_DROPPING, currentOverrideDropRate, newCurrentAvgClusterLatency, true, newRecoveryMap, oldState.getServiceName(), oldState.getDegraderProperties(), totalClusterCallCount);
            DegraderLoadBalancerStrategyV2.logState(oldState, newState, config, trackerClients);
        } else {
            double newDropLevel = Math.max(0.0, currentOverrideDropRate);
            if (newCurrentAvgClusterLatency > 0.0 && totalClusterCallCount >= config.getMinClusterCallCountHighWaterMark()) {
                if (newCurrentAvgClusterLatency >= config.getHighWaterMark() && currentOverrideDropRate != 1.0) {
                    newDropLevel = Math.min(1.0, newDropLevel + config.getGlobalStepUp());
                } else if (newCurrentAvgClusterLatency <= config.getLowWaterMark() && currentOverrideDropRate != 0.0) {
                    newDropLevel = Math.max(0.0, newDropLevel - config.getGlobalStepDown());
                }
            } else if (newCurrentAvgClusterLatency > 0.0 && totalClusterCallCount >= config.getMinClusterCallCountLowWaterMark()) {
                if (newCurrentAvgClusterLatency <= config.getLowWaterMark() && currentOverrideDropRate != 0.0) {
                    newDropLevel = Math.max(0.0, newDropLevel - config.getGlobalStepDown());
                }
            } else {
                newDropLevel = Math.max(0.0, newDropLevel - config.getGlobalStepDown());
            }
            if (newDropLevel != currentOverrideDropRate) {
                DegraderLoadBalancerStrategyV2.overrideClusterDropRate(newDropLevel, trackerClients);
            }
            newState = new DegraderLoadBalancerState(config.getUpdateIntervalMs(), clusterGenerationId, oldPointsMap, config.getClock().currentTimeMillis(), DegraderLoadBalancerState.Strategy.LOAD_BALANCE, newDropLevel, newCurrentAvgClusterLatency, true, oldRecoveryMap, oldState.getServiceName(), oldState.getDegraderProperties(), totalClusterCallCount);
            DegraderLoadBalancerStrategyV2.logState(oldState, newState, config, trackerClients);
            points = oldPointsMap;
        }
        DegraderLoadBalancerStrategyV2.overrideMinCallCount(currentOverrideDropRate, trackerClients, points, pointsPerWeight);
        return newState;
    }

    public static void overrideClusterDropRate(double override, List<TrackerClient> trackerClients) {
        LogUtil.warn(_log, "overriding degrader drop rate to ", override, " for clients: ", trackerClients);
        for (TrackerClient client : trackerClients) {
            client.getDegraderControl(0).setOverrideDropRate(override);
        }
    }

    public static void overrideMinCallCount(double newOverrideDropRate, List<TrackerClient> trackerClients, Map<URI, Integer> pointsMap, int pointsPerWeight) {
        for (TrackerClient client : trackerClients) {
            int currentOverrideMinCallCount = client.getDegraderControl(0).getOverrideMinCallCount();
            double hashFactor = pointsMap.get(client.getUri()) / pointsPerWeight;
            double transmitFactor = 1.0 - newOverrideDropRate;
            int newOverrideMinCallCount = (int)Math.max(Math.round((double)client.getDegraderControl(0).getMinCallCount() * hashFactor * transmitFactor), 1L);
            if (newOverrideMinCallCount == currentOverrideMinCallCount) continue;
            client.getDegraderControl(0).setOverrideMinCallCount(newOverrideMinCallCount);
            LogUtil.warn(_log, "overriding Min Call Count to ", newOverrideMinCallCount, " for client: ", client.getUri());
        }
    }

    protected static boolean shouldUpdate(long clusterGenerationId, DegraderLoadBalancerState currentState, DegraderLoadBalancerStrategyConfig config, boolean updateEnabled) {
        return updateEnabled && (!currentState.hasError() && (currentState.getClusterGenerationId() != clusterGenerationId || config.getClock().currentTimeMillis() - currentState.getLastUpdated() >= config.getUpdateIntervalMs() || currentState.getClusterGenerationId() == -1L) || currentState.hasError() && config.getClock().currentTimeMillis() - currentState.getLastUpdated() >= config.getUpdateIntervalMs()) && currentState.compareAndSetUpdateStarted();
    }

    public DegraderLoadBalancerState getState() {
        return this._state;
    }

    public DegraderLoadBalancerStrategyConfig getConfig() {
        return this._config;
    }

    public void setConfig(DegraderLoadBalancerStrategyConfig config) {
        this._config = config;
        String hashMethod = this._config.getHashMethod();
        Map<String, Object> hashConfig = this._config.getHashConfig();
        if (hashMethod == null || hashMethod.equals(HASH_METHOD_NONE)) {
            this._hashFunction = new RandomHash();
        } else if (HASH_METHOD_URI_REGEX.equals(hashMethod)) {
            this._hashFunction = new URIRegexHash(hashConfig);
        } else {
            _log.warn("Unknown hash method {}, falling back to random", (Object)hashMethod);
            this._hashFunction = new RandomHash();
        }
    }

    @Override
    public Ring<URI> getRing(long clusterGenerationId, int partitionId, List<TrackerClient> trackerClients) {
        if (partitionId != 0) {
            throw new UnsupportedOperationException("Trying to access partition: " + partitionId + "on an unpartitioned cluster");
        }
        this.checkUpdateState(clusterGenerationId, trackerClients);
        return this._state.getRing();
    }

    public boolean getUpdateEnabled() {
        return this._updateEnabled;
    }

    public void setUpdateEnabled(boolean enabled) {
        this._updateEnabled = enabled;
    }

    void setStrategy(DegraderLoadBalancerState.Strategy strategy) {
        DegraderLoadBalancerState newState;
        this._state = newState = new DegraderLoadBalancerState(this._state.getUpdateIntervalMs(), this._state.getClusterGenerationId(), this._state.getPointsMap(), this._state.getLastUpdated(), strategy, this._state.getCurrentOverrideDropRate(), this._state.getCurrentAvgClusterLatency(), this._state.isInitialized(), this._state.getRecoveryMap(), this._state.getServiceName(), this._state.getDegraderProperties(), this._state.getCurrentClusterCallCount());
    }

    public String toString() {
        return "DegraderLoadBalancerStrategyV2 [_config=" + this._config + ", _state=" + this._state + ", _updateEnabled=" + this._updateEnabled + "]";
    }

    public double getCurrentOverrideDropRate() {
        return this._state.getCurrentOverrideDropRate();
    }

    public static class DegraderLoadBalancerState {
        private final long _lastUpdated;
        private final long _updateIntervalMs;
        private final long _clusterGenerationId;
        private final Ring<URI> _ring;
        private final String _serviceName;
        private final Map<String, String> _degraderProperties;
        private final Map<URI, Integer> _pointsMap;
        private final Map<TrackerClient, Double> _recoveryMap;
        private final Strategy _strategy;
        private final double _currentOverrideDropRate;
        private final double _currentAvgClusterLatency;
        private final long _currentClusterCallCount;
        private final boolean _initialized;
        private final AtomicBoolean _updateStarted;
        private final boolean _errorDuringUpdateFlag;
        private final Map<TrackerClient, Double> _previousMaxDropRate;

        public DegraderLoadBalancerState(DegraderLoadBalancerState state, long clusterGenerationId, long updateIntervalMs, long lastUpdated) {
            this._clusterGenerationId = clusterGenerationId;
            this._lastUpdated = lastUpdated;
            this._updateIntervalMs = updateIntervalMs;
            this._strategy = state._strategy;
            this._currentAvgClusterLatency = state._currentAvgClusterLatency;
            this._currentOverrideDropRate = state._currentOverrideDropRate;
            this._initialized = state._initialized;
            this._serviceName = state._serviceName;
            this._ring = state._ring;
            this._pointsMap = state._pointsMap;
            this._recoveryMap = state._recoveryMap;
            this._updateStarted = new AtomicBoolean(false);
            this._errorDuringUpdateFlag = false;
            this._degraderProperties = state._degraderProperties;
            this._previousMaxDropRate = new HashMap<TrackerClient, Double>();
            this._currentClusterCallCount = state._currentClusterCallCount;
        }

        public DegraderLoadBalancerState(DegraderLoadBalancerState state, long clusterGenerationId, long updateIntervalMs, long lastUpdated, boolean errorDuringUpdate, boolean updateStarted) {
            this._clusterGenerationId = clusterGenerationId;
            this._lastUpdated = lastUpdated;
            this._updateIntervalMs = updateIntervalMs;
            this._strategy = state._strategy;
            this._currentAvgClusterLatency = state._currentAvgClusterLatency;
            this._currentOverrideDropRate = state._currentOverrideDropRate;
            this._initialized = state._initialized;
            this._serviceName = state._serviceName;
            this._ring = state._ring;
            this._pointsMap = state._pointsMap;
            this._recoveryMap = state._recoveryMap;
            this._updateStarted = new AtomicBoolean(updateStarted);
            this._errorDuringUpdateFlag = errorDuringUpdate;
            this._degraderProperties = state._degraderProperties;
            this._previousMaxDropRate = new HashMap<TrackerClient, Double>();
            this._currentClusterCallCount = state._currentClusterCallCount;
        }

        public DegraderLoadBalancerState(long updateIntervalMs, long clusterGenerationId, Map<URI, Integer> pointsMap, long lastUpdated, Strategy strategy, double currentOverrideDropRate, double currentAvgClusterLatency, boolean initState, Map<TrackerClient, Double> recoveryMap, String serviceName, Map<String, String> degraderProperties, long currentClusterCallCount) {
            this._lastUpdated = lastUpdated;
            this._updateIntervalMs = updateIntervalMs;
            this._clusterGenerationId = clusterGenerationId;
            this._ring = new ConsistentHashRing<URI>(pointsMap);
            this._pointsMap = pointsMap != null ? Collections.unmodifiableMap(new HashMap<URI, Integer>(pointsMap)) : Collections.emptyMap();
            this._strategy = strategy;
            this._currentOverrideDropRate = currentOverrideDropRate;
            this._currentAvgClusterLatency = currentAvgClusterLatency;
            this._initialized = initState;
            this._recoveryMap = recoveryMap != null ? Collections.unmodifiableMap(new HashMap<TrackerClient, Double>(recoveryMap)) : Collections.emptyMap();
            this._updateStarted = new AtomicBoolean(false);
            this._serviceName = serviceName;
            this._errorDuringUpdateFlag = false;
            this._degraderProperties = degraderProperties != null ? Collections.unmodifiableMap(new HashMap<String, String>(degraderProperties)) : Collections.emptyMap();
            this._previousMaxDropRate = new HashMap<TrackerClient, Double>();
            this._currentClusterCallCount = currentClusterCallCount;
        }

        public Map<String, String> getDegraderProperties() {
            return this._degraderProperties;
        }

        private String getServiceName() {
            return this._serviceName;
        }

        private boolean compareAndSetUpdateStarted() {
            return this._updateStarted.compareAndSet(false, true);
        }

        public boolean hasError() {
            return this._errorDuringUpdateFlag;
        }

        public long getLastUpdated() {
            return this._lastUpdated;
        }

        public long getCurrentClusterCallCount() {
            return this._currentClusterCallCount;
        }

        public long getUpdateIntervalMs() {
            return this._updateIntervalMs;
        }

        public long getClusterGenerationId() {
            return this._clusterGenerationId;
        }

        public Ring<URI> getRing() {
            return this._ring;
        }

        public Map<URI, Integer> getPointsMap() {
            return this._pointsMap;
        }

        public Strategy getStrategy() {
            return this._strategy;
        }

        public Map<TrackerClient, Double> getRecoveryMap() {
            return this._recoveryMap;
        }

        public double getCurrentOverrideDropRate() {
            return this._currentOverrideDropRate;
        }

        public double getCurrentAvgClusterLatency() {
            return this._currentAvgClusterLatency;
        }

        public boolean isInitialized() {
            return this._initialized;
        }

        public Map<TrackerClient, Double> getPreviousMaxDropRate() {
            return this._previousMaxDropRate;
        }

        public String toString() {
            return "DegraderLoadBalancerState [_serviceName=" + this._serviceName + ", _currentClusterCallCount=" + this._currentClusterCallCount + ", _currentAvgClusterLatency=" + this._currentAvgClusterLatency + ", _currentOverrideDropRate=" + this._currentOverrideDropRate + ", _clusterGenerationId=" + this._clusterGenerationId + ", _updateIntervalMs=" + this._updateIntervalMs + ", _lastUpdated=" + this._lastUpdated + ", _strategy=" + (Object)((Object)this._strategy) + ", _recoveryMap=" + this._recoveryMap + "]";
        }

        static /* synthetic */ long access$000(DegraderLoadBalancerState x0) {
            return x0._clusterGenerationId;
        }

        public static enum Strategy {
            LOAD_BALANCE,
            CALL_DROPPING;

        }
    }
}

