/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.strategies;

import com.linkedin.d2.balancer.clients.TrackerClient;
import com.linkedin.d2.balancer.util.hashing.Ring;
import com.linkedin.r2.message.Request;
import com.linkedin.r2.message.RequestContext;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public interface LoadBalancerStrategy {
    public TrackerClient getTrackerClient(Request var1, RequestContext var2, long var3, int var5, List<TrackerClient> var6);

    public Ring<URI> getRing(long var1, int var3, List<TrackerClient> var4);

    default public void shutdown() {
    }

    public static class ExcludedHostHints {
        private static final String EXCLUDED_HOST_KEY_NAME = "D2-Hint-ExcludedHosts";

        public static void addRequestContextExcludedHost(RequestContext context, URI excludedHost) {
            Set<URI> excludedHosts = ExcludedHostHints.getRequestContextExcludedHosts(context);
            if (excludedHosts == null) {
                excludedHosts = new HashSet<URI>();
                context.putLocalAttr(EXCLUDED_HOST_KEY_NAME, excludedHosts);
            }
            excludedHosts.add(excludedHost);
        }

        public static Set<URI> getRequestContextExcludedHosts(RequestContext context) {
            return (Set)context.getLocalAttr(EXCLUDED_HOST_KEY_NAME);
        }

        public static void clearRequestContextExcludedHosts(RequestContext context) {
            context.removeLocalAttr(EXCLUDED_HOST_KEY_NAME);
        }
    }
}

