/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.properties;

import com.linkedin.d2.balancer.properties.ClusterProperties;
import com.linkedin.d2.balancer.properties.HashBasedPartitionProperties;
import com.linkedin.d2.balancer.properties.NullPartitionProperties;
import com.linkedin.d2.balancer.properties.PartitionProperties;
import com.linkedin.d2.balancer.properties.RangeBasedPartitionProperties;
import com.linkedin.d2.balancer.properties.util.PropertyUtil;
import com.linkedin.d2.balancer.util.JacksonUtil;
import com.linkedin.d2.discovery.PropertyBuilder;
import com.linkedin.d2.discovery.PropertySerializationException;
import com.linkedin.d2.discovery.PropertySerializer;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterPropertiesJsonSerializer
implements PropertySerializer<ClusterProperties>,
PropertyBuilder<ClusterProperties> {
    private static final Logger _log = LoggerFactory.getLogger(ClusterPropertiesJsonSerializer.class);

    @Override
    public byte[] toBytes(ClusterProperties property) {
        try {
            return JacksonUtil.getObjectMapper().writeValueAsString((Object)property).getBytes("UTF-8");
        }
        catch (Exception e) {
            _log.error("Failed to write property to bytes: ", (Throwable)e);
            return null;
        }
    }

    @Override
    public ClusterProperties fromBytes(byte[] bytes) throws PropertySerializationException {
        try {
            Map untyped = (Map)JacksonUtil.getObjectMapper().readValue(new String(bytes, "UTF-8"), HashMap.class);
            return this.fromMap(untyped);
        }
        catch (Exception e) {
            throw new PropertySerializationException(e);
        }
    }

    private static <T> T mapGet(Map<String, Object> map, String key) {
        return (T)map.get(key);
    }

    @Override
    public ClusterProperties fromMap(Map<String, Object> map) {
        PartitionProperties partitionProperties;
        List bannedList = (List)ClusterPropertiesJsonSerializer.mapGet(map, "bannedUri");
        if (bannedList == null) {
            bannedList = Collections.emptyList();
        }
        HashSet<URI> banned = new HashSet<URI>(bannedList);
        String clusterName = PropertyUtil.checkAndGetValue(map, "clusterName", String.class, "ClusterProperties");
        List prioritizedSchemes = (List)ClusterPropertiesJsonSerializer.mapGet(map, "prioritizedSchemes");
        Map properties = (Map)ClusterPropertiesJsonSerializer.mapGet(map, "properties");
        Map partitionPropertiesMap = (Map)ClusterPropertiesJsonSerializer.mapGet(map, "partitionProperties");
        String scope = "cluster: " + clusterName;
        if (partitionPropertiesMap != null) {
            PartitionProperties.PartitionType partitionType = PropertyUtil.checkAndGetValue(partitionPropertiesMap, "partitionType", PartitionProperties.PartitionType.class, scope);
            switch (partitionType) {
                case RANGE: {
                    long keyRangeStart = PropertyUtil.checkAndGetValue(partitionPropertiesMap, "keyRangeStart", Number.class, scope).longValue();
                    long partitionSize = PropertyUtil.checkAndGetValue(partitionPropertiesMap, "partitionSize", Number.class, scope).longValue();
                    int partitionCount = PropertyUtil.checkAndGetValue(partitionPropertiesMap, "partitionCount", Number.class, scope).intValue();
                    String partitionKeyRegex = PropertyUtil.checkAndGetValue(partitionPropertiesMap, "partitionKeyRegex", String.class, scope);
                    partitionProperties = new RangeBasedPartitionProperties(partitionKeyRegex, keyRangeStart, partitionSize, partitionCount);
                    break;
                }
                case HASH: {
                    int partitionCount = PropertyUtil.checkAndGetValue(partitionPropertiesMap, "partitionCount", Number.class, scope).intValue();
                    String partitionKeyRegex = PropertyUtil.checkAndGetValue(partitionPropertiesMap, "partitionKeyRegex", String.class, scope);
                    HashBasedPartitionProperties.HashAlgorithm algorithm = PropertyUtil.checkAndGetValue(partitionPropertiesMap, "hashAlgorithm", HashBasedPartitionProperties.HashAlgorithm.class, scope);
                    partitionProperties = new HashBasedPartitionProperties(partitionKeyRegex, partitionCount, algorithm);
                    break;
                }
                case NONE: {
                    partitionProperties = NullPartitionProperties.getInstance();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("In " + scope + ": Unsupported partitionType: " + (Object)((Object)partitionType));
                }
            }
        } else {
            partitionProperties = NullPartitionProperties.getInstance();
        }
        return new ClusterProperties(clusterName, prioritizedSchemes, properties, banned, partitionProperties);
    }
}

