/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.d2.balancer.config;

import com.linkedin.d2.D2DegraderProperties;
import com.linkedin.d2.balancer.properties.util.PropertyUtil;
import com.linkedin.d2.latencyType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DegraderPropertiesConverter {
    public static Map<String, String> toProperties(D2DegraderProperties config) {
        if (config == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        if (config.hasLogEnabled()) {
            map.put("degrader.logEnabled", config.isLogEnabled().toString());
        }
        if (config.hasMaxDropRate()) {
            map.put("degrader.maxDropRate", config.getMaxDropRate().toString());
        }
        if (config.hasUpStep()) {
            map.put("degrader.upStep", config.getUpStep().toString());
        }
        if (config.hasDownStep()) {
            map.put("degrader.downStep", config.getDownStep().toString());
        }
        if (config.hasMinCallCount()) {
            map.put("degrader.minCallCount", config.getMinCallCount().toString());
        }
        if (config.hasHighLatency()) {
            map.put("degrader.highLatency", config.getHighLatency().toString());
        }
        if (config.hasLowLatency()) {
            map.put("degrader.lowLatency", config.getLowLatency().toString());
        }
        if (config.hasHighErrorRate()) {
            map.put("degrader.highErrorRate", config.getHighErrorRate().toString());
        }
        if (config.hasLowErrorRate()) {
            map.put("degrader.lowErrorRate", config.getLowErrorRate().toString());
        }
        if (config.hasHighOutstanding()) {
            map.put("degrader.highOutstanding", config.getHighOutstanding().toString());
        }
        if (config.hasLowOutstanding()) {
            map.put("degrader.lowOutstanding", config.getLowOutstanding().toString());
        }
        if (config.hasMinOutstandingCount()) {
            map.put("degrader.minOutstandingCount", config.getMinOutstandingCount().toString());
        }
        if (config.hasMaxDropDuration()) {
            map.put("degrader.maxDropDuration", config.getMaxDropDuration().toString());
        }
        if (config.hasLatencyToUse()) {
            map.put("degrader.latencyToUse", config.getLatencyToUse().name());
        }
        if (config.hasInitialDropRate()) {
            map.put("degrader.initialDropRate", config.getInitialDropRate().toString());
        }
        if (config.hasSlowStartThreshold()) {
            map.put("degrader.slowStartThreshold", config.getSlowStartThreshold().toString());
        }
        return map;
    }

    public static D2DegraderProperties toConfig(Map<String, String> properties) {
        D2DegraderProperties config = new D2DegraderProperties();
        if (properties.containsKey("degrader.logEnabled")) {
            config.setLogEnabled(PropertyUtil.coerce(properties.get("degrader.logEnabled"), Boolean.class));
        }
        if (properties.containsKey("degrader.maxDropRate")) {
            config.setMaxDropRate(PropertyUtil.coerce(properties.get("degrader.maxDropRate"), Double.class));
        }
        if (properties.containsKey("degrader.upStep")) {
            config.setUpStep(PropertyUtil.coerce(properties.get("degrader.upStep"), Double.class));
        }
        if (properties.containsKey("degrader.downStep")) {
            config.setDownStep(PropertyUtil.coerce(properties.get("degrader.downStep"), Double.class));
        }
        if (properties.containsKey("degrader.minCallCount")) {
            config.setMinCallCount(PropertyUtil.coerce(properties.get("degrader.minCallCount"), Integer.class));
        }
        if (properties.containsKey("degrader.highLatency")) {
            config.setHighLatency(PropertyUtil.coerce(properties.get("degrader.highLatency"), Integer.class));
        }
        if (properties.containsKey("degrader.lowLatency")) {
            config.setLowLatency(PropertyUtil.coerce(properties.get("degrader.lowLatency"), Integer.class));
        }
        if (properties.containsKey("degrader.highErrorRate")) {
            config.setHighErrorRate(PropertyUtil.coerce(properties.get("degrader.highErrorRate"), Double.class));
        }
        if (properties.containsKey("degrader.lowErrorRate")) {
            config.setLowErrorRate(PropertyUtil.coerce(properties.get("degrader.lowErrorRate"), Double.class));
        }
        if (properties.containsKey("degrader.highOutstanding")) {
            config.setHighOutstanding(PropertyUtil.coerce(properties.get("degrader.highOutstanding"), Integer.class));
        }
        if (properties.containsKey("degrader.lowOutstanding")) {
            config.setLowOutstanding(PropertyUtil.coerce(properties.get("degrader.lowOutstanding"), Integer.class));
        }
        if (properties.containsKey("degrader.minOutstandingCount")) {
            config.setMinOutstandingCount(PropertyUtil.coerce(properties.get("degrader.minOutstandingCount"), Integer.class));
        }
        if (properties.containsKey("degrader.maxDropDuration")) {
            config.setMaxDropDuration(PropertyUtil.coerce(properties.get("degrader.maxDropDuration"), Long.class));
        }
        if (properties.containsKey("degrader.latencyToUse")) {
            config.setLatencyToUse(latencyType.valueOf((String)properties.get("degrader.latencyToUse")));
        }
        if (properties.containsKey("degrader.initialDropRate")) {
            config.setInitialDropRate(PropertyUtil.coerce(properties.get("degrader.initialDropRate"), Double.class));
        }
        if (properties.containsKey("degrader.slowStartThreshold")) {
            config.setSlowStartThreshold(PropertyUtil.coerce(properties.get("degrader.slowStartThreshold"), Double.class));
        }
        return config;
    }
}

