/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.util.degrader;

import com.linkedin.common.util.ConfigHelper;
import com.linkedin.util.clock.Clock;
import com.linkedin.util.clock.SystemClock;
import com.linkedin.util.clock.Time;
import com.linkedin.util.degrader.CallTracker;
import com.linkedin.util.degrader.Degrader;
import com.linkedin.util.degrader.ErrorType;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DegraderImpl
implements Degrader {
    public static final String MODULE = Degrader.class.getName();
    private static final Logger log = LoggerFactory.getLogger((String)MODULE);
    public static final Clock DEFAULT_CLOCK = SystemClock.instance();
    public static final Boolean DEFAULT_LOG_ENABLED = false;
    public static final LatencyToUse DEFAULT_LATENCY_TO_USE = LatencyToUse.AVERAGE;
    public static final Double DEFAULT_OVERRIDE_DROP_RATE = -1.0;
    public static final Double DEFAULT_MAX_DROP_RATE = 1.0;
    public static final long DEFAULT_MAX_DROP_DURATION = Time.milliseconds(60000L);
    public static final Double DEFAULT_UP_STEP = 0.2;
    public static final Double DEFAULT_DOWN_STEP = 0.2;
    public static final Integer DEFAULT_MIN_CALL_COUNT = 10;
    public static final long DEFAULT_HIGH_LATENCY = Time.milliseconds(3000L);
    public static final long DEFAULT_LOW_LATENCY = Time.milliseconds(500L);
    public static final Double DEFAULT_HIGH_ERROR_RATE = 1.1;
    public static final Double DEFAULT_LOW_ERROR_RATE = 1.1;
    public static final long DEFAULT_HIGH_OUTSTANDING = Time.milliseconds(10000L);
    public static final long DEFAULT_LOW_OUTSTANDING = Time.milliseconds(500L);
    public static final Integer DEFAULT_MIN_OUTSTANDING_COUNT = 5;
    public static final Integer DEFAULT_OVERRIDE_MIN_CALL_COUNT = -1;
    public static final double DEFAULT_INITIAL_DROP_RATE = 0.0;
    public static final double DEFAULT_SLOW_START_THRESHOLD = 0.0;
    private ImmutableConfig _config;
    private String _name;
    private CallTracker _callTracker;
    private CallTracker.CallStats _callTrackerStats;
    private Clock _clock;
    private volatile long _maxDropDuration;
    private double _computedDropRate;
    private volatile double _dropRate;
    private long _latency;
    private long _outstandingLatency;
    private long _lastIntervalCountTotal;
    private long _lastIntervalDroppedCountTotal;
    private double _lastIntervalDroppedRate;
    private volatile long _lastResetTime;
    private final AtomicLong _lastNotDroppedTime = new AtomicLong();
    private final AtomicLong _countTotal = new AtomicLong();
    private final AtomicLong _noOverrideDropCountTotal = new AtomicLong();
    private final AtomicLong _droppedCountTotal = new AtomicLong();

    public DegraderImpl(Config config) {
        this._config = new ImmutableConfig(config);
        this._name = this._config.getName();
        this._clock = config.getClock();
        this._callTracker = config.getCallTracker();
        this._callTrackerStats = this._callTracker.getCallStats();
        this._maxDropDuration = config.getMaxDropDuration();
        this.reset();
        this._callTracker.addStatsRolloverEventListener(new CallTracker.StatsRolloverEventListener(){

            @Override
            public void onStatsRollover(CallTracker.StatsRolloverEvent event) {
                DegraderImpl.this.rolloverStats(event.getCallStats());
            }
        });
    }

    public synchronized void reset() {
        this.setComputedDropRate(this._config.getInitialDropRate());
        this._lastIntervalCountTotal = 0L;
        this._lastIntervalDroppedCountTotal = 0L;
        this._lastIntervalDroppedRate = 0.0;
        this._lastResetTime = this._clock.currentTimeMillis();
        this._lastNotDroppedTime.set(this._lastResetTime);
        this._countTotal.set(0L);
        this._noOverrideDropCountTotal.set(0L);
        this._droppedCountTotal.set(0L);
    }

    @Override
    public String getName() {
        return this._name;
    }

    public long getLastResetTime() {
        return this._lastResetTime;
    }

    public synchronized ImmutableConfig getConfig() {
        return this._config;
    }

    public synchronized void setConfig(Config config) {
        if (config.getName() != this._config.getName() || config.getCallTracker() != this._config.getCallTracker() || config.getClock() != this._config.getClock()) {
            throw new IllegalArgumentException("Degrader Name, CallTracker and Clock cannot be changed");
        }
        this._config = new ImmutableConfig(config);
        this._maxDropDuration = config.getMaxDropDuration();
        this.setComputedDropRate(this._computedDropRate);
    }

    @Override
    public boolean checkDrop(double code) {
        boolean drop;
        long now = this._clock.currentTimeMillis();
        this.checkStale(now);
        this._countTotal.incrementAndGet();
        double dropRate = this._dropRate;
        double computedDropRate = this._computedDropRate;
        if (code < dropRate) {
            long lastNotDropped = this._lastNotDroppedTime.get();
            drop = lastNotDropped + this._maxDropDuration <= now ? !this._lastNotDroppedTime.compareAndSet(lastNotDropped, now) : true;
            if (drop) {
                this._droppedCountTotal.incrementAndGet();
            }
        } else {
            drop = false;
            this._lastNotDroppedTime.set(now);
        }
        if (code < computedDropRate) {
            this._noOverrideDropCountTotal.incrementAndGet();
        }
        return drop;
    }

    @Override
    public boolean checkDrop() {
        return this.checkDrop(ThreadLocalRandom.current().nextDouble());
    }

    public synchronized Stats getStats() {
        this.checkStale(this._clock.currentTimeMillis());
        return new Stats(this._dropRate, this._computedDropRate, this._countTotal.get(), this._noOverrideDropCountTotal.get(), this._droppedCountTotal.get(), this._lastNotDroppedTime.get(), this._callTrackerStats.getInterval(), this._callTrackerStats.getIntervalEndTime(), this._lastIntervalDroppedRate, this._callTrackerStats.getCallCount(), this._latency, this._callTrackerStats.getErrorRate(), this._outstandingLatency, this._callTrackerStats.getOutstandingCount(), this._callTrackerStats.getErrorTypeCounts());
    }

    private void checkStale(long now) {
        if (this._callTrackerStats.stale(now)) {
            this._callTracker.getCallStats();
        }
    }

    private synchronized void rolloverStats(CallTracker.CallStats stats) {
        double oldDropRate;
        this._callTrackerStats = stats;
        this.snapLatency();
        this.snapOutstandingLatency();
        if (this._config.isLogEnabled()) {
            log.info(this._config.getName() + " " + this._callTrackerStats);
        }
        long countTotal = this._countTotal.get();
        long noOverrideDropCountTotal = this._noOverrideDropCountTotal.get();
        long droppedCountTotal = this._droppedCountTotal.get();
        long dropped = droppedCountTotal - this._lastIntervalDroppedCountTotal;
        long count = countTotal - this._lastIntervalCountTotal;
        double lastIntervalDroppedRate = count == 0L ? 0.0 : (double)dropped / (double)count;
        double newDropRate = oldDropRate = this._computedDropRate;
        if (oldDropRate < this._config.getMaxDropRate() && this.isHigh()) {
            newDropRate = Math.min(this._config.getMaxDropRate(), oldDropRate + this._config.getUpStep());
        } else if (oldDropRate > 0.0 && this.isLow()) {
            double oldTransmissionRate = 1.0 - oldDropRate;
            newDropRate = oldTransmissionRate < this._config.getSlowStartThreshold() ? (oldTransmissionRate > 0.0 ? Math.max(0.0, 1.0 - 2.0 * oldTransmissionRate) : 0.99) : Math.max(0.0, oldDropRate - this._config.getDownStep());
        }
        if (oldDropRate != newDropRate) {
            if (log.isWarnEnabled()) {
                log.warn(this._config.getName() + " ComputedDropRate " + (oldDropRate > newDropRate ? "decreased" : "increased") + " from " + oldDropRate + " to " + newDropRate + ", OverrideDropRate=" + this._config.getOverrideDropRate() + ", AdjustedMinCallCount=" + this.adjustedMinCallCount() + ", CallCount=" + this._callTrackerStats.getCallCount() + ", Latency=" + this._latency + ", ErrorRate=" + this.getErrorRateToDegrade() + ", OutstandingLatency=" + this._outstandingLatency + ", OutstandingCount=" + stats.getOutstandingCount() + ", NoOverrideDropCountTotal=" + noOverrideDropCountTotal + ", DroppedCountTotal=" + droppedCountTotal + ", LastIntervalDroppedRate=" + lastIntervalDroppedRate);
            }
        } else if (this._config.isLogEnabled() && log.isInfoEnabled()) {
            log.info(this._config.getName() + " ComputedDropRate=" + newDropRate + ", OverrideDropRate=" + this._config.getOverrideDropRate() + ", AdjustedMinCallCount=" + this.adjustedMinCallCount() + ", CallCount=" + this._callTrackerStats.getCallCount() + ", Latency=" + this._latency + ", ErrorRate=" + this.getErrorRateToDegrade() + ", OutstandingLatency=" + this._outstandingLatency + ", OutstandingCount=" + stats.getOutstandingCount() + ", CountTotal=" + countTotal + ", NoOverrideDropCountTotal=" + noOverrideDropCountTotal + ", DroppedCountTotal=" + droppedCountTotal + ", LastIntervalDroppedRate=" + lastIntervalDroppedRate);
        } else if (log.isDebugEnabled()) {
            log.debug(this._config.getName() + " ComputedDropRate=" + newDropRate + ", OverrideDropRate=" + this._config.getOverrideDropRate() + ", AdjustedMinCallCount=" + this.adjustedMinCallCount() + ", CallCount=" + this._callTrackerStats.getCallCount() + ", Latency=" + this._latency + ", ErrorRate=" + this.getErrorRateToDegrade() + ", OutstandingLatency=" + this._outstandingLatency + ", OutstandingCount=" + stats.getOutstandingCount() + ", CountTotal=" + countTotal + ", NoOverrideDropCountTotal=" + noOverrideDropCountTotal + ", DroppedCountTotal=" + droppedCountTotal + ", LastIntervalDroppedRate=" + lastIntervalDroppedRate);
        }
        this._lastIntervalCountTotal = countTotal;
        this._lastIntervalDroppedCountTotal = droppedCountTotal;
        this._lastIntervalDroppedRate = lastIntervalDroppedRate;
        this.setComputedDropRate(newDropRate);
    }

    private void setComputedDropRate(double newDropRate) {
        double overrideDropRate = this._config.getOverrideDropRate();
        this._dropRate = overrideDropRate >= 0.0 ? overrideDropRate : newDropRate;
        this._computedDropRate = newDropRate;
    }

    private void snapLatency() {
        CallTracker.CallStats stats = this._callTrackerStats;
        switch (this._config._latencyToUse) {
            case PCT50: {
                this._latency = stats.getCallTimeStats().get50Pct();
                break;
            }
            case PCT90: {
                this._latency = stats.getCallTimeStats().get90Pct();
                break;
            }
            case PCT95: {
                this._latency = stats.getCallTimeStats().get95Pct();
                break;
            }
            case PCT99: {
                this._latency = stats.getCallTimeStats().get99Pct();
                break;
            }
            case AVERAGE: {
                this._latency = Math.round(stats.getCallTimeStats().getAverage());
                break;
            }
            default: {
                throw new IllegalArgumentException("Latency to use " + (Object)((Object)this._config._latencyToUse) + " is unknown");
            }
        }
    }

    private void snapOutstandingLatency() {
        CallTracker.CallStats stats = this._callTrackerStats;
        this._outstandingLatency = stats.getOutstandingStartTimeAvg();
    }

    private int adjustedMinCallCount() {
        int overrideMinCallCount = this._config.getOverrideMinCallCount();
        if (overrideMinCallCount < 0) {
            return Math.max((int)Math.round((1.0 - this._dropRate) * (double)this._config.getMinCallCount()), 1);
        }
        return Math.max(overrideMinCallCount, 1);
    }

    protected boolean isHigh() {
        return this._callTrackerStats.getCallCount() >= this.adjustedMinCallCount() && (this._latency >= this._config.getHighLatency() || this.getErrorRateToDegrade() >= this._config.getHighErrorRate()) || this._callTrackerStats.getOutstandingCount() >= this._config.getMinOutstandingCount() && this._outstandingLatency >= this._config.getHighOutstanding();
    }

    protected boolean isLow() {
        return this._callTrackerStats.getCallCount() >= this.adjustedMinCallCount() && this._latency <= this._config.getLowLatency() && this.getErrorRateToDegrade() <= this._config.getLowErrorRate() && (this._callTrackerStats.getOutstandingCount() < this._config.getMinOutstandingCount() || this._outstandingLatency <= this._config.getLowOutstanding());
    }

    private double getErrorRateToDegrade() {
        Map<ErrorType, Integer> errorTypeCounts = this._callTrackerStats.getErrorTypeCounts();
        Integer connectExceptionCount = errorTypeCounts.getOrDefault((Object)ErrorType.CONNECT_EXCEPTION, 0);
        Integer closedChannelExceptionCount = errorTypeCounts.getOrDefault((Object)ErrorType.CLOSED_CHANNEL_EXCEPTION, 0);
        Integer serverErrorCount = errorTypeCounts.getOrDefault((Object)ErrorType.SERVER_ERROR, 0);
        Integer timeoutExceptionCount = errorTypeCounts.getOrDefault((Object)ErrorType.TIMEOUT_EXCEPTION, 0);
        return this.safeDivide(connectExceptionCount + closedChannelExceptionCount + serverErrorCount + timeoutExceptionCount, this._callTrackerStats.getCallCount());
    }

    private double safeDivide(double numerator, double denominator) {
        return denominator != 0.0 ? numerator / denominator : 0.0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[name = " + this._name + ",");
        builder.append(" maxDropDuration = " + this._maxDropDuration + ",");
        builder.append(" computedDropRate = " + this._computedDropRate + ",");
        builder.append(" dropRate = " + this._dropRate + ",");
        builder.append(" latency = " + this._latency + ",");
        builder.append(" outstandingLatency = " + this._outstandingLatency + ",");
        builder.append(" lastIntervalDroppedRate = " + this._lastIntervalDroppedRate + ",");
        builder.append(" callCount = " + this._callTrackerStats.getCallCount() + ",");
        builder.append(" droppedCountTotal = " + this._droppedCountTotal + "]");
        return builder.toString();
    }

    public static class Config
    extends ImmutableConfig {
        public Config() {
        }

        public Config(ImmutableConfig config) {
            super(config);
        }

        public void setName(String name) {
            this._name = name;
        }

        public void setCallTracker(CallTracker callTracker) {
            this._callTracker = callTracker;
        }

        public void setClock(Clock clock) {
            this._clock = clock;
        }

        public void setLogEnabled(Boolean logEnabled) {
            this._logEnabled = logEnabled;
        }

        public void setLatencyToUse(LatencyToUse latencyToUse) {
            this._latencyToUse = latencyToUse;
        }

        public void setOverrideDropRate(Double overrideDropRate) {
            this._overrideDropRate = overrideDropRate;
        }

        public void setMaxDropRate(Double maxDropRate) {
            this._maxDropRate = maxDropRate;
        }

        public void setInitialDropRate(double initialDropRate) {
            this._initialDropRate = initialDropRate;
        }

        public void setMaxDropDuration(long maxDropDuration) {
            this._maxDropDuration = maxDropDuration;
        }

        public void setUpStep(Double upStep) {
            this._upStep = upStep;
        }

        public void setDownStep(Double downStep) {
            this._downStep = downStep;
        }

        public void setMinCallCount(Integer minCallCount) {
            this._minCallCount = minCallCount;
        }

        public void setHighLatency(long highLatency) {
            this._highLatency = highLatency;
        }

        public void setLowLatency(long lowLatency) {
            this._lowLatency = lowLatency;
        }

        public void setHighErrorRate(Double highErrorRate) {
            this._highErrorRate = highErrorRate;
        }

        public void setLowErrorRate(Double lowErrorRate) {
            this._lowErrorRate = lowErrorRate;
        }

        public void setHighOutstanding(long highOutstanding) {
            this._highOutstanding = highOutstanding;
        }

        public void setLowOutstanding(long lowOutstanding) {
            this._lowOutstanding = lowOutstanding;
        }

        public void setMinOutstandingCount(Integer minOutstandingCount) {
            this._minOutstandingCount = minOutstandingCount;
        }

        public void setOverrideMinCallCount(Integer overrideMinCallCount) {
            this._overrideMinCallCount = overrideMinCallCount;
        }

        public void setSlowStartThreshold(double slowStartThreshold) {
            this._slowStartThreshold = slowStartThreshold;
        }
    }

    public static class ImmutableConfig {
        protected String _name;
        protected CallTracker _callTracker;
        protected Clock _clock = DEFAULT_CLOCK;
        protected boolean _logEnabled = DEFAULT_LOG_ENABLED;
        protected LatencyToUse _latencyToUse = DEFAULT_LATENCY_TO_USE;
        protected double _overrideDropRate = DEFAULT_OVERRIDE_DROP_RATE;
        protected double _maxDropRate = DEFAULT_MAX_DROP_RATE;
        protected long _maxDropDuration = DEFAULT_MAX_DROP_DURATION;
        protected double _upStep = DEFAULT_UP_STEP;
        protected double _downStep = DEFAULT_DOWN_STEP;
        protected int _minCallCount = DEFAULT_MIN_CALL_COUNT;
        protected long _highLatency = DEFAULT_HIGH_LATENCY;
        protected long _lowLatency = DEFAULT_LOW_LATENCY;
        protected double _highErrorRate = DEFAULT_HIGH_ERROR_RATE;
        protected double _lowErrorRate = DEFAULT_LOW_ERROR_RATE;
        protected long _highOutstanding = DEFAULT_HIGH_OUTSTANDING;
        protected long _lowOutstanding = DEFAULT_LOW_OUTSTANDING;
        protected int _minOutstandingCount = DEFAULT_MIN_OUTSTANDING_COUNT;
        protected int _overrideMinCallCount = DEFAULT_OVERRIDE_MIN_CALL_COUNT;
        protected double _initialDropRate = 0.0;
        protected double _slowStartThreshold = 0.0;

        public ImmutableConfig() {
        }

        public ImmutableConfig(ImmutableConfig config) {
            this._name = config._name;
            this._callTracker = config._callTracker;
            this._clock = config._clock;
            this._logEnabled = config._logEnabled;
            this._latencyToUse = config._latencyToUse;
            this._overrideDropRate = config._overrideDropRate;
            this._maxDropRate = config._maxDropRate;
            this._maxDropDuration = config._maxDropDuration;
            this._upStep = config._upStep;
            this._downStep = config._downStep;
            this._minCallCount = config._minCallCount;
            this._highLatency = config._highLatency;
            this._lowLatency = config._lowLatency;
            this._highErrorRate = config._highErrorRate;
            this._lowErrorRate = config._lowErrorRate;
            this._highOutstanding = config._highOutstanding;
            this._lowOutstanding = config._lowOutstanding;
            this._minOutstandingCount = config._minOutstandingCount;
            this._overrideMinCallCount = config._overrideMinCallCount;
            this._initialDropRate = config._initialDropRate;
            this._slowStartThreshold = config._slowStartThreshold;
        }

        public String getName() {
            return (String)ConfigHelper.getRequired((Object)this._name);
        }

        public CallTracker getCallTracker() {
            return (CallTracker)ConfigHelper.getRequired((Object)this._callTracker);
        }

        public Clock getClock() {
            return (Clock)ConfigHelper.getRequired((Object)this._clock);
        }

        public boolean isLogEnabled() {
            return this._logEnabled;
        }

        public LatencyToUse getLatencyToUse() {
            return (LatencyToUse)((Object)ConfigHelper.getRequired((Object)((Object)this._latencyToUse)));
        }

        public double getOverrideDropRate() {
            return this._overrideDropRate;
        }

        public double getMaxDropRate() {
            return this._maxDropRate;
        }

        public double getInitialDropRate() {
            return this._initialDropRate;
        }

        public long getMaxDropDuration() {
            return this._maxDropDuration;
        }

        public double getUpStep() {
            return this._upStep;
        }

        public double getDownStep() {
            return this._downStep;
        }

        public int getMinCallCount() {
            return this._minCallCount;
        }

        public long getHighLatency() {
            return this._highLatency;
        }

        public long getLowLatency() {
            return this._lowLatency;
        }

        public double getHighErrorRate() {
            return this._highErrorRate;
        }

        public double getLowErrorRate() {
            return this._lowErrorRate;
        }

        public long getHighOutstanding() {
            return this._highOutstanding;
        }

        public long getLowOutstanding() {
            return this._lowOutstanding;
        }

        public int getMinOutstandingCount() {
            return this._minOutstandingCount;
        }

        public int getOverrideMinCallCount() {
            return this._overrideMinCallCount;
        }

        public double getSlowStartThreshold() {
            return this._slowStartThreshold;
        }
    }

    public static class Stats {
        private final double _currentDropRate;
        private final double _currentComputedDropRate;
        private final long _currentCountTotal;
        private final long _currentNoOverrideDropCountTotal;
        private final long _currentDroppedCountTotal;
        private final long _lastNotDroppedTime;
        private final long _interval;
        private final long _intervalEndTime;
        private final double _droppedRate;
        private final int _callCount;
        private final long _latency;
        private final double _errorRate;
        private final long _outstandingLatency;
        private final int _outstandingCount;
        private final Map<ErrorType, Integer> _errorCountsMap;

        private Stats(double currentDropRate, double currentComputedDropRate, long currentCountTotal, long currentNoOverrideDropCountTotal, long currentDroppedCountTotal, long lastNotDroppedTime, long interval, long intervalEndTime, double droppedRate, int callCount, long latency, double errorRate, long outstandingLatency, int outstandingCount, Map<ErrorType, Integer> errorCountsMap) {
            this._currentDropRate = currentDropRate;
            this._currentComputedDropRate = currentComputedDropRate;
            this._currentCountTotal = currentCountTotal;
            this._currentNoOverrideDropCountTotal = currentNoOverrideDropCountTotal;
            this._currentDroppedCountTotal = currentDroppedCountTotal;
            this._lastNotDroppedTime = lastNotDroppedTime;
            this._interval = interval;
            this._intervalEndTime = intervalEndTime;
            this._droppedRate = droppedRate;
            this._callCount = callCount;
            this._latency = latency;
            this._errorRate = errorRate;
            this._outstandingLatency = outstandingLatency;
            this._outstandingCount = outstandingCount;
            this._errorCountsMap = errorCountsMap;
        }

        public double getCurrentDropRate() {
            return this._currentDropRate;
        }

        public double getCurrentComputedDropRate() {
            return this._currentComputedDropRate;
        }

        public long getCurrentCountTotal() {
            return this._currentCountTotal;
        }

        public long getCurrentNoOverrideDropCountTotal() {
            return this._currentNoOverrideDropCountTotal;
        }

        public long getCurrentDroppedCountTotal() {
            return this._currentDroppedCountTotal;
        }

        public long getLastNotDroppedTime() {
            return this._lastNotDroppedTime;
        }

        public long getInterval() {
            return this._interval;
        }

        public long getIntervalEndTime() {
            return this._intervalEndTime;
        }

        public double getDroppedRate() {
            return this._droppedRate;
        }

        public int getCallCount() {
            return this._callCount;
        }

        public long getLatency() {
            return this._latency;
        }

        public double getErrorRate() {
            return this._errorRate;
        }

        public long getOutstandingLatency() {
            return this._outstandingLatency;
        }

        public int getOutstandingCount() {
            return this._outstandingCount;
        }

        public Map<ErrorType, Integer> getErrorCountsMap() {
            return this._errorCountsMap;
        }
    }

    public static enum LatencyToUse {
        AVERAGE,
        PCT50,
        PCT90,
        PCT95,
        PCT99;

    }
}

