/*
 * Decompiled with CFR 0.152.
 */
package azkaban.webapp.plugin;

import azkaban.webapp.plugin.ViewerPlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class PluginRegistry {
    private static PluginRegistry registry;
    public TreeSet<ViewerPlugin> viewerPlugins = new TreeSet<ViewerPlugin>(ViewerPlugin.COMPARATOR);
    public Map<String, TreeSet<ViewerPlugin>> jobTypeViewerPlugins = new HashMap<String, TreeSet<ViewerPlugin>>();

    private PluginRegistry() {
    }

    public void register(ViewerPlugin plugin) {
        this.viewerPlugins.add(plugin);
        List<String> jobTypes = plugin.getJobTypes();
        if (jobTypes == null) {
            return;
        }
        for (String jobType : jobTypes) {
            TreeSet<ViewerPlugin> plugins = null;
            if (!this.jobTypeViewerPlugins.containsKey(jobType)) {
                plugins = new TreeSet<ViewerPlugin>(ViewerPlugin.COMPARATOR);
                plugins.add(plugin);
                this.jobTypeViewerPlugins.put(jobType, plugins);
                continue;
            }
            plugins = this.jobTypeViewerPlugins.get(jobType);
            plugins.add(plugin);
        }
    }

    public List<ViewerPlugin> getViewerPlugins() {
        return new ArrayList<ViewerPlugin>(this.viewerPlugins);
    }

    public List<ViewerPlugin> getViewerPluginsForJobType(String jobType) {
        TreeSet<ViewerPlugin> plugins = this.jobTypeViewerPlugins.get(jobType);
        if (plugins == null) {
            return null;
        }
        return new ArrayList<ViewerPlugin>(plugins);
    }

    public static PluginRegistry getRegistry() {
        if (registry == null) {
            registry = new PluginRegistry();
        }
        return registry;
    }
}

