/*
 * Decompiled with CFR 0.152.
 */
package azkaban.migration.schedule2trigger;

import azkaban.executor.ExecutionOptions;
import azkaban.migration.scheduler.JdbcScheduleLoader;
import azkaban.migration.scheduler.Schedule;
import azkaban.migration.sla.SLA;
import azkaban.migration.sla.SlaOptions;
import azkaban.sla.SlaOption;
import azkaban.trigger.Condition;
import azkaban.trigger.ConditionChecker;
import azkaban.trigger.JdbcTriggerLoader;
import azkaban.trigger.Trigger;
import azkaban.trigger.TriggerAction;
import azkaban.trigger.builtin.BasicTimeChecker;
import azkaban.trigger.builtin.ExecuteFlowAction;
import azkaban.utils.JSONUtils;
import azkaban.utils.Props;
import azkaban.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadablePeriod;

public class Schedule2Trigger {
    private static final Logger logger = Logger.getLogger(Schedule2Trigger.class);
    private static Props props;
    private static File outputDir;

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            Schedule2Trigger.printUsage();
        }
        File confFile = new File(args[0]);
        try {
            logger.info((Object)("Trying to load config from " + confFile.getAbsolutePath()));
            props = Schedule2Trigger.loadAzkabanConfig(confFile);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)e);
            return;
        }
        try {
            outputDir = File.createTempFile("schedules", null);
            logger.info((Object)"Creating temp dir for dumping existing schedules.");
            outputDir.delete();
            outputDir.mkdir();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)e);
            return;
        }
        try {
            Schedule2Trigger.schedule2File();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)e);
            return;
        }
        try {
            Schedule2Trigger.file2ScheduleTrigger();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)e);
            return;
        }
        logger.info((Object)"Uploaded all schedules. Removing temp dir.");
        FileUtils.deleteDirectory((File)outputDir);
        System.exit(0);
    }

    private static Props loadAzkabanConfig(File confFile) throws IOException {
        return new Props(null, confFile);
    }

    private static void printUsage() {
        System.out.println("Usage: schedule2Trigger PATH_TO_CONFIG_FILE");
    }

    private static void schedule2File() throws Exception {
        JdbcScheduleLoader scheduleLoader = new JdbcScheduleLoader(props);
        logger.info((Object)"Loading old schedule info from DB.");
        List<Schedule> schedules = scheduleLoader.loadSchedules();
        for (Schedule sched : schedules) {
            Schedule2Trigger.writeScheduleFile(sched, outputDir);
        }
    }

    private static void writeScheduleFile(Schedule sched, File outputDir) throws IOException {
        SlaOptions slaOptions;
        String scheduleFileName = sched.getProjectName() + "-" + sched.getFlowName();
        File outputFile = new File(outputDir, scheduleFileName);
        outputFile.createNewFile();
        Props props = new Props();
        props.put("flowName", sched.getFlowName());
        props.put("projectName", sched.getProjectName());
        props.put("projectId", String.valueOf(sched.getProjectId()));
        props.put("period", Schedule.createPeriodString(sched.getPeriod()));
        props.put("firstScheduleTimeLong", sched.getFirstSchedTime());
        props.put("timezone", sched.getTimezone().getID());
        props.put("submitUser", sched.getSubmitUser());
        props.put("submitTimeLong", sched.getSubmitTime());
        props.put("nextExecTimeLong", sched.getNextExecTime());
        ExecutionOptions executionOptions = sched.getExecutionOptions();
        if (executionOptions != null) {
            props.put("executionOptionsObj", JSONUtils.toJSON(executionOptions.toObject()));
        }
        if ((slaOptions = sched.getSlaOptions()) != null) {
            ArrayList settingsObj = new ArrayList();
            List<SLA.SlaSetting> settings = slaOptions.getSettings();
            for (SLA.SlaSetting set : settings) {
                HashMap<String, Object> setObj = new HashMap<String, Object>();
                String setId = set.getId();
                SLA.SlaRule rule = set.getRule();
                HashMap<String, Object> info = new HashMap<String, Object>();
                info.put("Duration", Schedule.createPeriodString(set.getDuration()));
                info.put("EmailList", slaOptions.getSlaEmails());
                ArrayList<String> actionsList = new ArrayList<String>();
                for (SLA.SlaAction act : set.getActions()) {
                    if (act.equals((Object)SLA.SlaAction.EMAIL)) {
                        actionsList.add("SlaAlert");
                        info.put("SlaAlertType", "email");
                        continue;
                    }
                    if (!act.equals((Object)SLA.SlaAction.KILL)) continue;
                    actionsList.add("SlaCancelFlow");
                }
                setObj.put("actions", actionsList);
                if (setId.equals("")) {
                    info.put("FlowName", sched.getFlowName());
                    if (rule.equals((Object)SLA.SlaRule.FINISH)) {
                        setObj.put("type", "FlowFinish");
                    } else if (rule.equals((Object)SLA.SlaRule.SUCCESS)) {
                        setObj.put("type", "FlowSucceed");
                    }
                } else {
                    info.put("JobName", setId);
                    if (rule.equals((Object)SLA.SlaRule.FINISH)) {
                        setObj.put("type", "JobFinish");
                    } else if (rule.equals((Object)SLA.SlaRule.SUCCESS)) {
                        setObj.put("type", "JobSucceed");
                    }
                }
                setObj.put("info", info);
                settingsObj.add(setObj);
            }
            props.put("slaOptionsObj", JSONUtils.toJSON(settingsObj));
        }
        props.storeLocal(outputFile);
    }

    private static void file2ScheduleTrigger() throws Exception {
        JdbcTriggerLoader triggerLoader = new JdbcTriggerLoader(props);
        for (File scheduleFile : outputDir.listFiles()) {
            logger.info((Object)("Trying to load schedule from " + scheduleFile.getAbsolutePath()));
            if (!scheduleFile.isFile()) continue;
            Props schedProps = new Props(null, scheduleFile);
            String flowName = schedProps.getString("flowName");
            String projectName = schedProps.getString("projectName");
            int projectId = schedProps.getInt("projectId");
            long firstSchedTimeLong = schedProps.getLong("firstScheduleTimeLong");
            String timezoneId = schedProps.getString("timezone");
            DateTimeZone timezone = DateTimeZone.forID((String)timezoneId);
            ReadablePeriod period = Utils.parsePeriodString(schedProps.getString("period"));
            long nextExecTimeLong = schedProps.getLong("nextExecTimeLong");
            long submitTimeLong = schedProps.getLong("submitTimeLong");
            String submitUser = schedProps.getString("submitUser");
            ExecutionOptions executionOptions = null;
            if (schedProps.containsKey("executionOptionsObj")) {
                String executionOptionsObj = schedProps.getString("executionOptionsObj");
                executionOptions = ExecutionOptions.createFromObject(JSONUtils.parseJSONFromString(executionOptionsObj));
            } else {
                executionOptions = new ExecutionOptions();
            }
            ArrayList<SlaOption> slaOptions = null;
            if (schedProps.containsKey("slaOptionsObj")) {
                slaOptions = new ArrayList<SlaOption>();
                List settingsObj = (List)JSONUtils.parseJSONFromString(schedProps.getString("slaOptionsObj"));
                for (Map sla : settingsObj) {
                    String type = (String)sla.get("type");
                    Map info = (Map)sla.get("info");
                    List actions = (List)sla.get("actions");
                    SlaOption slaOption = new SlaOption(type, actions, info);
                    slaOptions.add(slaOption);
                }
            }
            azkaban.scheduler.Schedule schedule = new azkaban.scheduler.Schedule(-1, projectId, projectName, flowName, "ready", firstSchedTimeLong, timezone, period, DateTime.now().getMillis(), nextExecTimeLong, submitTimeLong, submitUser, executionOptions, slaOptions);
            Trigger t = Schedule2Trigger.scheduleToTrigger(schedule);
            logger.info((Object)("Ready to insert trigger " + t.getDescription()));
            triggerLoader.addTrigger(t);
        }
    }

    private static Trigger scheduleToTrigger(azkaban.scheduler.Schedule s) {
        Condition triggerCondition = Schedule2Trigger.createTimeTriggerCondition(s);
        Condition expireCondition = Schedule2Trigger.createTimeExpireCondition(s);
        List<TriggerAction> actions = Schedule2Trigger.createActions(s);
        Trigger t = new Trigger(s.getScheduleId(), s.getLastModifyTime(), s.getSubmitTime(), s.getSubmitUser(), "SimpleTimeTrigger", triggerCondition, expireCondition, actions);
        if (s.isRecurring()) {
            t.setResetOnTrigger(true);
        }
        return t;
    }

    private static List<TriggerAction> createActions(azkaban.scheduler.Schedule s) {
        ArrayList<TriggerAction> actions = new ArrayList<TriggerAction>();
        ExecuteFlowAction executeAct = new ExecuteFlowAction("executeFlowAction", s.getProjectId(), s.getProjectName(), s.getFlowName(), s.getSubmitUser(), s.getExecutionOptions(), s.getSlaOptions());
        actions.add(executeAct);
        return actions;
    }

    private static Condition createTimeTriggerCondition(azkaban.scheduler.Schedule s) {
        HashMap<String, ConditionChecker> checkers = new HashMap<String, ConditionChecker>();
        BasicTimeChecker checker = new BasicTimeChecker("BasicTimeChecker_1", s.getFirstSchedTime(), s.getTimezone(), s.isRecurring(), s.skipPastOccurrences(), s.getPeriod());
        checkers.put(checker.getId(), checker);
        String expr = checker.getId() + ".eval()";
        Condition cond = new Condition(checkers, expr);
        return cond;
    }

    private static Condition createTimeExpireCondition(azkaban.scheduler.Schedule s) {
        HashMap<String, ConditionChecker> checkers = new HashMap<String, ConditionChecker>();
        BasicTimeChecker checker = new BasicTimeChecker("BasicTimeChecker_2", s.getFirstSchedTime(), s.getTimezone(), s.isRecurring(), s.skipPastOccurrences(), s.getPeriod());
        checkers.put(checker.getId(), checker);
        String expr = checker.getId() + ".eval()";
        Condition cond = new Condition(checkers, expr);
        return cond;
    }
}

