/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.request_allocation;

import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.PriorityQueue;

class PriorityMultiIterator<T>
implements Iterator<T> {
    private final PriorityQueue<TAndIterator> queue;
    private final Comparator<TAndIterator> actualComparator;

    public PriorityMultiIterator(Collection<Iterator<T>> orderedIterators, final Comparator<T> prioritizer) {
        this.actualComparator = new Comparator<TAndIterator>(){

            @Override
            public int compare(TAndIterator o1, TAndIterator o2) {
                return prioritizer.compare(o1.getT(), o2.getT());
            }
        };
        this.queue = new PriorityQueue<TAndIterator>(orderedIterators.size(), this.actualComparator);
        for (Iterator<T> iterator : orderedIterators) {
            if (!iterator.hasNext()) continue;
            this.queue.offer(new TAndIterator(iterator.next(), iterator));
        }
    }

    @Override
    public boolean hasNext() {
        return !this.queue.isEmpty();
    }

    @Override
    public T next() {
        TAndIterator nextTAndIterator = this.queue.poll();
        if (nextTAndIterator.getIterator().hasNext()) {
            this.queue.offer(new TAndIterator(nextTAndIterator.getIterator().next(), nextTAndIterator.getIterator()));
        }
        return nextTAndIterator.getT();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private class TAndIterator {
        private final T t;
        private final Iterator<T> iterator;

        @ConstructorProperties(value={"t", "iterator"})
        public TAndIterator(T t, Iterator<T> iterator) {
            this.t = t;
            this.iterator = iterator;
        }

        public T getT() {
            return this.t;
        }

        public Iterator<T> getIterator() {
            return this.iterator;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TAndIterator)) {
                return false;
            }
            TAndIterator other = (TAndIterator)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Object this$t = this.getT();
            Object other$t = other.getT();
            if (this$t == null ? other$t != null : !this$t.equals(other$t)) {
                return false;
            }
            Iterator this$iterator = this.getIterator();
            Iterator other$iterator = other.getIterator();
            return !(this$iterator == null ? other$iterator != null : !this$iterator.equals(other$iterator));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TAndIterator;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Object $t = this.getT();
            result = result * 59 + ($t == null ? 43 : $t.hashCode());
            Iterator $iterator = this.getIterator();
            result = result * 59 + ($iterator == null ? 43 : $iterator.hashCode());
            return result;
        }

        public String toString() {
            return "PriorityMultiIterator.TAndIterator(t=" + this.getT() + ", iterator=" + this.getIterator() + ")";
        }
    }
}

