/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.recordcount;

import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.gobblin.util.RecordCountProvider;
import org.apache.hadoop.fs.Path;

public class IngestionRecordCountProvider
extends RecordCountProvider {
    private static final String SEPARATOR = ".";

    public static String constructFilePath(String oldFilePath, long recordCounts) {
        return new Path(new Path(oldFilePath).getParent(), Files.getNameWithoutExtension((String)oldFilePath).toString() + SEPARATOR + recordCounts + SEPARATOR + Files.getFileExtension((String)oldFilePath)).toString();
    }

    public long getRecordCount(Path filepath) {
        String[] components = filepath.getName().split(Pattern.quote(SEPARATOR));
        Preconditions.checkArgument((components.length >= 2 && StringUtils.isNumeric((String)components[components.length - 2]) ? 1 : 0) != 0, (Object)String.format("Filename %s does not follow the pattern: FILENAME.RECORDCOUNT.EXTENSION", filepath));
        return Long.parseLong(components[components.length - 2]);
    }
}

