/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.io;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.fs.FSInputStream;

public class SeekableFSInputStream
extends FSInputStream {
    private InputStream in;
    private long pos;

    public SeekableFSInputStream(InputStream in) {
        this.in = in;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int val = this.in.read(b, off, len);
        if (val > 0) {
            this.pos += (long)val;
        }
        return val;
    }

    public long getPos() throws IOException {
        return this.pos;
    }

    public void seek(long pos) throws IOException {
        this.pos += this.in.skip(pos - this.pos);
    }

    public boolean seekToNewSource(long arg0) throws IOException {
        return false;
    }

    public int read() throws IOException {
        int val = this.in.read();
        if (val > 0) {
            this.pos += (long)val;
        }
        return val;
    }

    public void close() throws IOException {
        super.close();
        this.in.close();
    }
}

