/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.guid;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.gobblin.util.guid.HasGuid;

public class Guid {
    public static final int GUID_LENGTH = 20;
    final byte[] sha;

    public Guid(byte[] bytes) {
        this(bytes, false);
    }

    private Guid(byte[] bytes, boolean isSha) {
        this.sha = isSha ? bytes : Guid.computeGuid(bytes);
    }

    public static Guid fromHasGuid(HasGuid ... objs) throws IOException {
        byte[][] byteArrays = new byte[objs.length][];
        for (int i = 0; i < objs.length; ++i) {
            byteArrays[i] = objs[i].guid().sha;
        }
        return Guid.fromByteArrays(byteArrays);
    }

    public static Guid fromStrings(String ... strings) throws IOException {
        if (strings == null || strings.length == 0) {
            throw new IOException("Attempting to compute guid for an empty array.");
        }
        return new Guid(StringUtils.join((Object[])strings).getBytes(Charsets.UTF_8));
    }

    public static Guid fromByteArrays(byte[] ... byteArrays) throws IOException {
        if (byteArrays == null || byteArrays.length == 0) {
            throw new IOException("Attempting to compute guid for an empty array.");
        }
        if (byteArrays.length == 1) {
            return new Guid(byteArrays[0]);
        }
        byte[] tmp = new byte[]{};
        for (byte[] arr : byteArrays) {
            tmp = ArrayUtils.addAll((byte[])tmp, (byte[])arr);
        }
        return new Guid(tmp);
    }

    public static Guid deserialize(String str) throws IOException {
        if (str.length() != 40) {
            throw new IOException("String is not an encoded guid.");
        }
        try {
            return new Guid(Hex.decodeHex((char[])str.toCharArray()), true);
        }
        catch (DecoderException de) {
            throw new IOException(de);
        }
    }

    public static Guid combine(Guid ... guids) throws IOException {
        byte[][] byteArrays = new byte[guids.length][];
        for (int i = 0; i < guids.length; ++i) {
            byteArrays[i] = guids[i].sha;
        }
        return Guid.fromByteArrays(byteArrays);
    }

    public Guid append(byte[] ... byteArrays) throws IOException {
        if (byteArrays == null || byteArrays.length == 0) {
            return this;
        }
        return Guid.fromByteArrays((byte[][])ArrayUtils.add((Object[])byteArrays, (Object)this.sha));
    }

    public Guid append(Guid ... guids) throws IOException {
        if (guids == null || guids.length == 0) {
            return this;
        }
        return Guid.combine((Guid[])ArrayUtils.add((Object[])guids, (Object)this));
    }

    public Guid append(HasGuid ... objs) throws IOException {
        if (objs == null || objs.length == 0) {
            return this;
        }
        return Guid.fromHasGuid((HasGuid[])ArrayUtils.add((Object[])objs, (Object)new SimpleHasGuid(this)));
    }

    public String toString() {
        return Hex.encodeHexString((byte[])this.sha);
    }

    private static byte[] computeGuid(byte[] bytes) {
        return DigestUtils.sha((byte[])bytes);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Guid)) {
            return false;
        }
        Guid other = (Guid)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.equals(this.sha, other.sha);
    }

    protected boolean canEqual(Object other) {
        return other instanceof Guid;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.sha);
        return result;
    }

    static class SimpleHasGuid
    implements HasGuid {
        private final Guid guid;

        public SimpleHasGuid(Guid guid) {
            this.guid = guid;
        }

        @Override
        public Guid guid() throws IOException {
            return this.guid;
        }
    }
}

