/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.callbacks;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.gobblin.util.ExecutorsUtils;
import org.apache.gobblin.util.callbacks.CallbackResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallbacksDispatcher<L>
implements Closeable {
    private final Logger _log;
    private final List<L> _listeners = new ArrayList<L>();
    private final WeakHashMap<L, Void> _autoListeners = new WeakHashMap();
    private final ExecutorService _execService;

    public CallbacksDispatcher(Optional<ExecutorService> execService, Optional<Logger> log) {
        Preconditions.checkNotNull(execService);
        Preconditions.checkNotNull(log);
        this._log = log.isPresent() ? (Logger)log.get() : LoggerFactory.getLogger(this.getClass());
        this._execService = execService.isPresent() ? (ExecutorService)execService.get() : CallbacksDispatcher.getDefaultExecutor(this._log);
    }

    public static ExecutorService getDefaultExecutor(Logger log) {
        return Executors.newSingleThreadExecutor(ExecutorsUtils.newThreadFactory((Optional<Logger>)Optional.of((Object)log), (Optional<String>)Optional.of((Object)(log.getName() + "-%d"))));
    }

    public CallbacksDispatcher() {
        this((Optional<ExecutorService>)Optional.absent(), (Optional<Logger>)Optional.absent());
    }

    public CallbacksDispatcher(Logger log) {
        this((Optional<ExecutorService>)Optional.absent(), (Optional<Logger>)Optional.of((Object)log));
    }

    public CallbacksDispatcher(ExecutorService execService, Logger log) {
        this((Optional<ExecutorService>)Optional.of((Object)execService), (Optional<Logger>)Optional.of((Object)log));
    }

    @Override
    public void close() throws IOException {
        ExecutorsUtils.shutdownExecutorService(this._execService, (Optional<Logger>)Optional.of((Object)this._log), 5L, TimeUnit.SECONDS);
    }

    public synchronized List<L> getListeners() {
        ArrayList<L> res = new ArrayList<L>(this._listeners);
        for (Map.Entry<L, Void> entry : this._autoListeners.entrySet()) {
            res.add(entry.getKey());
        }
        return res;
    }

    public synchronized void addListener(L listener) {
        Preconditions.checkNotNull(listener);
        this._log.info("Adding listener:" + listener);
        this._listeners.add(listener);
    }

    public synchronized void addWeakListener(L listener) {
        Preconditions.checkNotNull(listener);
        this._log.info("Adding a weak listener " + listener);
        this._autoListeners.put(listener, null);
    }

    public synchronized void removeListener(L listener) {
        Preconditions.checkNotNull(listener);
        this._log.info("Removing listener:" + listener);
        this._listeners.remove(listener);
    }

    public Logger getLog() {
        return this._log;
    }

    public <R> CallbackResults<L, R> execCallbacks(Function<? super L, R> callback, L listener) throws InterruptedException {
        Preconditions.checkNotNull(listener);
        ArrayList<L> listenerList = new ArrayList<L>(1);
        listenerList.add(listener);
        return this.execCallbacks(callback, (List<L>)listenerList);
    }

    public <R> CallbackResults<L, R> execCallbacks(Function<? super L, R> callback) throws InterruptedException {
        Preconditions.checkNotNull(callback);
        List<L> listeners = this.getListeners();
        return this.execCallbacks(callback, listeners);
    }

    private <R> CallbackResults<L, R> execCallbacks(Function<? super L, R> callback, List<L> listeners) throws InterruptedException {
        CallbackResults res = new CallbackResults();
        if (0 == listeners.size()) {
            return res;
        }
        ArrayList<CallbackCallable<R>> callbacks = new ArrayList<CallbackCallable<R>>(listeners.size());
        for (L listener : listeners) {
            callbacks.add(new CallbackCallable<R>(callback, listener));
        }
        List futures = this._execService.invokeAll(callbacks);
        for (int i = 0; i < listeners.size(); ++i) {
            CallbackResult cr = CallbackResult.createFromFuture(futures.get(i));
            L listener = listeners.get(i);
            if (cr.isCanceled()) {
                this._log.warn("Callback cancelled: " + callbacks.get(i) + " on " + listener);
                res.cancellations.put(listener, cr);
                continue;
            }
            if (cr.hasFailed()) {
                this._log.error("Callback error: " + callbacks.get(i) + " on " + listener + ":" + cr.getError());
                res.failures.put(listener, cr);
                continue;
            }
            res.successes.put(listener, cr);
        }
        return res;
    }

    public static class CallbackResults<L, R> {
        private final Map<L, CallbackResult<R>> successes = new IdentityHashMap<L, CallbackResult<R>>();
        private final Map<L, CallbackResult<R>> failures = new IdentityHashMap<L, CallbackResult<R>>();
        private final Map<L, CallbackResult<R>> cancellations = new IdentityHashMap<L, CallbackResult<R>>();

        public Map<L, CallbackResult<R>> getSuccesses() {
            return this.successes;
        }

        public Map<L, CallbackResult<R>> getFailures() {
            return this.failures;
        }

        public Map<L, CallbackResult<R>> getCancellations() {
            return this.cancellations;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CallbackResults)) {
                return false;
            }
            CallbackResults other = (CallbackResults)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<L, CallbackResult<R>> this$successes = this.getSuccesses();
            Map<L, CallbackResult<R>> other$successes = other.getSuccesses();
            if (this$successes == null ? other$successes != null : !((Object)this$successes).equals(other$successes)) {
                return false;
            }
            Map<L, CallbackResult<R>> this$failures = this.getFailures();
            Map<L, CallbackResult<R>> other$failures = other.getFailures();
            if (this$failures == null ? other$failures != null : !((Object)this$failures).equals(other$failures)) {
                return false;
            }
            Map<L, CallbackResult<R>> this$cancellations = this.getCancellations();
            Map<L, CallbackResult<R>> other$cancellations = other.getCancellations();
            return !(this$cancellations == null ? other$cancellations != null : !((Object)this$cancellations).equals(other$cancellations));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CallbackResults;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<L, CallbackResult<R>> $successes = this.getSuccesses();
            result = result * 59 + ($successes == null ? 43 : ((Object)$successes).hashCode());
            Map<L, CallbackResult<R>> $failures = this.getFailures();
            result = result * 59 + ($failures == null ? 43 : ((Object)$failures).hashCode());
            Map<L, CallbackResult<R>> $cancellations = this.getCancellations();
            result = result * 59 + ($cancellations == null ? 43 : ((Object)$cancellations).hashCode());
            return result;
        }

        public String toString() {
            return "CallbacksDispatcher.CallbackResults(successes=" + this.getSuccesses() + ", failures=" + this.getFailures() + ", cancellations=" + this.getCancellations() + ")";
        }
    }

    public class CallbackCallable<R>
    implements Callable<R> {
        final Function<? super L, R> _callback;
        final L _listener;

        @Override
        public R call() throws Exception {
            CallbacksDispatcher.this._log.info("Calling " + this._callback + " on " + this._listener);
            return (R)this._callback.apply(this._listener);
        }

        @ConstructorProperties(value={"_callback", "_listener"})
        public CallbackCallable(Function<? super L, R> _callback, L _listener) {
            this._callback = _callback;
            this._listener = _listener;
        }
    }
}

