/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util.binpacking;

import com.google.common.base.Predicate;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.MinMaxPriorityQueue;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import org.apache.gobblin.source.workunit.MultiWorkUnit;
import org.apache.gobblin.source.workunit.WorkUnit;
import org.apache.gobblin.source.workunit.WorkUnitBinPacker;
import org.apache.gobblin.source.workunit.WorkUnitWeighter;

public class WorstFitDecreasingBinPacking
implements WorkUnitBinPacker {
    public static final String TOTAL_MULTI_WORK_UNIT_WEIGHT = "binpacking.multiWorkUnit.totalWeight";
    private final long maxWeightPerUnit;

    @OverridingMethodsMustInvokeSuper
    public List<WorkUnit> pack(List<WorkUnit> workUnitsIn, WorkUnitWeighter weighter) {
        if (this.maxWeightPerUnit <= 0L) {
            return workUnitsIn;
        }
        ArrayList workUnits = Lists.newArrayList(workUnitsIn);
        long smallUnitSize = 0L;
        int largeUnits = 0;
        for (WorkUnit workUnit : workUnits) {
            long weight = weighter.weight(workUnit);
            if (weight <= this.maxWeightPerUnit) {
                smallUnitSize += weight;
                continue;
            }
            ++largeUnits;
        }
        int estimateByWeight = largeUnits + (int)((smallUnitSize - 1L) / this.maxWeightPerUnit) + 1;
        int estimatedMultiWorkUnits = Math.min(estimateByWeight, workUnits.size());
        MinMaxPriorityQueue pQueue = MinMaxPriorityQueue.orderedBy((Comparator)new MultiWorkUnitComparator()).create();
        for (int i = 0; i < estimatedMultiWorkUnits; ++i) {
            pQueue.add((Object)MultiWorkUnit.createEmpty());
        }
        Collections.sort(workUnits, Collections.reverseOrder(new WeightComparator(weighter)));
        for (WorkUnit workUnit : workUnits) {
            MultiWorkUnit lightestMultiWorkUnit = (MultiWorkUnit)pQueue.peek();
            long weight = Math.max(1L, weighter.weight(workUnit));
            long multiWorkUnitWeight = WorstFitDecreasingBinPacking.getMultiWorkUnitWeight(lightestMultiWorkUnit);
            if (multiWorkUnitWeight == 0L || weight + multiWorkUnitWeight <= this.maxWeightPerUnit && weight + multiWorkUnitWeight > multiWorkUnitWeight) {
                WorstFitDecreasingBinPacking.addToMultiWorkUnit(lightestMultiWorkUnit, workUnit, weight);
                pQueue.poll();
                pQueue.add((Object)lightestMultiWorkUnit);
                continue;
            }
            MultiWorkUnit newMultiWorkUnit = MultiWorkUnit.createEmpty();
            WorstFitDecreasingBinPacking.addToMultiWorkUnit(newMultiWorkUnit, workUnit, weight);
            pQueue.add((Object)newMultiWorkUnit);
        }
        return Lists.newArrayList((Iterable)Iterables.filter((Iterable)pQueue, (Predicate)new Predicate<MultiWorkUnit>(){

            @SuppressWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"}, justification="Allowing nullable values")
            public boolean apply(@Nullable MultiWorkUnit input) {
                return WorstFitDecreasingBinPacking.getMultiWorkUnitWeight(input) > 0L;
            }
        }));
    }

    private static void addToMultiWorkUnit(MultiWorkUnit multiWorkUnit, WorkUnit workUnit, long weight) {
        multiWorkUnit.addWorkUnit(workUnit);
        WorstFitDecreasingBinPacking.setMultiWorkUnitWeight(multiWorkUnit, WorstFitDecreasingBinPacking.getMultiWorkUnitWeight(multiWorkUnit) + weight);
    }

    private static long getMultiWorkUnitWeight(MultiWorkUnit multiWorkUnit) {
        return multiWorkUnit.contains(TOTAL_MULTI_WORK_UNIT_WEIGHT) ? multiWorkUnit.getPropAsLong(TOTAL_MULTI_WORK_UNIT_WEIGHT) : 0L;
    }

    private static void setMultiWorkUnitWeight(MultiWorkUnit multiWorkUnit, long weight) {
        multiWorkUnit.setProp(TOTAL_MULTI_WORK_UNIT_WEIGHT, (Object)Long.toString(weight));
    }

    @ConstructorProperties(value={"maxWeightPerUnit"})
    public WorstFitDecreasingBinPacking(long maxWeightPerUnit) {
        this.maxWeightPerUnit = maxWeightPerUnit;
    }

    private static class MultiWorkUnitComparator
    implements Comparator<MultiWorkUnit>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private MultiWorkUnitComparator() {
        }

        @Override
        public int compare(MultiWorkUnit o1, MultiWorkUnit o2) {
            return Long.compare(WorstFitDecreasingBinPacking.getMultiWorkUnitWeight(o1), WorstFitDecreasingBinPacking.getMultiWorkUnitWeight(o2));
        }
    }

    private static class WeightComparator
    implements Comparator<WorkUnit> {
        private final WorkUnitWeighter weighter;
        private final LoadingCache<WorkUnit, Long> weightCache;

        public WeightComparator(WorkUnitWeighter weighter) {
            this.weighter = weighter;
            this.weightCache = CacheBuilder.newBuilder().softValues().build((CacheLoader)new CacheLoader<WorkUnit, Long>(){

                public Long load(WorkUnit key) throws Exception {
                    return weighter.weight(key);
                }
            });
        }

        @Override
        public int compare(WorkUnit o1, WorkUnit o2) {
            try {
                return Long.compare((Long)this.weightCache.get((Object)o1), (Long)this.weightCache.get((Object)o2));
            }
            catch (ExecutionException ee) {
                throw new RuntimeException(ee);
            }
        }
    }
}

