/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.gobblin.compat.hadoop.WritableShim;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.Serialization;
import org.apache.hadoop.io.serializer.Serializer;

public class WritableShimSerialization
implements Serialization<WritableShim> {
    public static void addToHadoopConfiguration(Configuration conf) {
        String SERIALIZATION_KEY = "io.serializations";
        String existingSerializers = conf.get("io.serializations");
        if (existingSerializers != null) {
            conf.set("io.serializations", existingSerializers + "," + WritableShimSerialization.class.getName());
        } else {
            conf.set("io.serializations", "org.apache.hadoop.io.serializer.WritableSerialization," + WritableShimSerialization.class.getName());
        }
    }

    public boolean accept(Class<?> c) {
        return WritableShim.class.isAssignableFrom(c);
    }

    public Serializer<WritableShim> getSerializer(Class<WritableShim> c) {
        return new WritableShimSerializer();
    }

    public Deserializer<WritableShim> getDeserializer(Class<WritableShim> c) {
        return new WritableShimDeserializer(c);
    }

    private static class WritableShimDeserializer
    implements Deserializer<WritableShim> {
        private final Class<WritableShim> clazz;
        private DataInputStream in;

        public WritableShimDeserializer(Class<WritableShim> c) {
            this.clazz = c;
            this.in = null;
        }

        public void open(InputStream in) throws IOException {
            this.in = new DataInputStream(in);
        }

        public WritableShim deserialize(WritableShim writableShim) throws IOException {
            try {
                if (writableShim == null) {
                    writableShim = this.clazz.newInstance();
                }
                writableShim.readFields((DataInput)this.in);
                return writableShim;
            }
            catch (ReflectiveOperationException e) {
                throw new IOException("Error creating new object", e);
            }
        }

        public void close() throws IOException {
        }
    }

    private static class WritableShimSerializer
    implements Serializer<WritableShim> {
        private DataOutputStream out = null;

        public void open(OutputStream out) throws IOException {
            this.out = new DataOutputStream(out);
        }

        public void serialize(WritableShim writableShim) throws IOException {
            writableShim.write((DataOutput)this.out);
        }

        public void close() throws IOException {
            this.out.flush();
            this.out.close();
            this.out = null;
        }
    }
}

