/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util;

import com.google.common.base.Optional;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.apache.gobblin.util.Decorator;
import org.apache.gobblin.util.DecoratorUtils;
import org.apache.gobblin.util.filesystem.ThrottledFileSystem;
import org.apache.gobblin.util.limiter.Limiter;
import org.apache.gobblin.util.limiter.RateBasedLimiter;
import org.apache.hadoop.fs.FileSystem;

@Deprecated
public class RateControlledFileSystem
extends ThrottledFileSystem {
    private static final int DEFAULT_MAX_CACHE_SIZE = 100;
    private static final Cache<String, RateBasedLimiter> FS_URI_TO_RATE_LIMITER_CACHE = CacheBuilder.newBuilder().maximumSize(100L).build();
    private final long limitPerSecond;
    private final Callable<RateBasedLimiter> callableLimiter;

    public static Optional<Long> getRateIfRateControlled(FileSystem fs) {
        if (fs instanceof Decorator) {
            List lineage = DecoratorUtils.getDecoratorLineage((Object)fs);
            for (Object obj : lineage) {
                if (!(obj instanceof RateControlledFileSystem)) continue;
                return Optional.of((Object)((RateControlledFileSystem)((Object)obj)).limitPerSecond);
            }
            return Optional.absent();
        }
        return Optional.absent();
    }

    public RateControlledFileSystem(FileSystem fs, final long limitPerSecond) {
        super(fs, null, null);
        this.limitPerSecond = limitPerSecond;
        this.callableLimiter = new Callable<RateBasedLimiter>(){

            @Override
            public RateBasedLimiter call() throws Exception {
                return new RateBasedLimiter(limitPerSecond);
            }
        };
    }

    public void startRateControl() throws ExecutionException {
        this.getRateLimiter().start();
    }

    @Override
    protected Limiter getRateLimiter() {
        try {
            String key = this.getUri().toString();
            RateBasedLimiter limiter = (RateBasedLimiter)FS_URI_TO_RATE_LIMITER_CACHE.get((Object)key, this.callableLimiter);
            if (limiter.getRateLimitPerSecond() < (double)this.limitPerSecond) {
                try {
                    limiter = this.callableLimiter.call();
                    FS_URI_TO_RATE_LIMITER_CACHE.put((Object)key, (Object)limiter);
                }
                catch (Exception exc) {
                    throw new ExecutionException(exc);
                }
            }
            return limiter;
        }
        catch (ExecutionException ee) {
            throw new RuntimeException(ee);
        }
    }
}

