/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.util;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class PropertiesUtils {
    public static Properties combineProperties(Properties ... properties) {
        Properties combinedProperties = new Properties();
        for (Properties props : properties) {
            combinedProperties.putAll((Map<?, ?>)props);
        }
        return combinedProperties;
    }

    public static Map<String, ?> propsToStringKeyMap(Properties properties) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            mapBuilder.put((Object)entry.getKey().toString(), entry.getValue());
        }
        return mapBuilder.build();
    }

    public static boolean getPropAsBoolean(Properties properties, String key, String defaultValue) {
        return Boolean.valueOf(properties.getProperty(key, defaultValue));
    }

    public static Properties extractPropertiesWithPrefix(Properties properties, Optional<String> prefix) {
        Preconditions.checkNotNull((Object)properties);
        Preconditions.checkNotNull(prefix);
        Properties extractedProperties = new Properties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (!StringUtils.startsWith((CharSequence)entry.getKey().toString(), (CharSequence)((CharSequence)prefix.or((Object)"")))) continue;
            extractedProperties.put(entry.getKey().toString(), entry.getValue());
        }
        return extractedProperties;
    }
}

